/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.GithubIcons;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestState;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMergeabilityState;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRStateService;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRStatePanel$WhenMappings;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRStatusChecksComponent;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRCloseAction;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRCommitMergeAction;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRRebaseMergeAction;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRReopenAction;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRSquashMergeAction;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;
import org.jetbrains.plugins.github.ui.util.SingleValueModel;
import org.jetbrains.plugins.github.util.DelayedTaskScheduler;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001#B;\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0003H\u0014J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0002H\u0014R+\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00028B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u00070\u0011\u00a2\u0006\u0002\b\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel;", "Lcom/intellij/ui/CardLayoutPanel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProvider;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "stateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;", "detailsModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lcom/intellij/openapi/Disposable;)V", "<set-?>", "currentState", "getCurrentState", "()Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;", "setCurrentState", "(Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;)V", "currentState$delegate", "Lkotlin/properties/ReadWriteProperty;", "openComponentDisposable", "Lorg/jetbrains/annotations/NotNull;", "create", "ui", "dispose", "", "key", "prepare", "StateUI", "intellij.vcs.github"})
public final class GHPRStatePanel
extends CardLayoutPanel<GHPullRequestState, StateUI, JComponent> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadWriteProperty currentState$delegate;
    private Disposable openComponentDisposable;
    private final Project project;
    private final GHPRDataProvider dataProvider;
    private final GHPRSecurityService securityService;
    private final GHPRStateService stateService;
    private final SingleValueModel<GHPullRequestShort> detailsModel;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GHPRStatePanel.class), "currentState", "getCurrentState()Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;"))};
    }

    private final GHPullRequestState getCurrentState() {
        return (GHPullRequestState)((Object)this.currentState$delegate.getValue((Object)this, $$delegatedProperties[0]));
    }

    private final void setCurrentState(GHPullRequestState gHPullRequestState) {
        this.currentState$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)gHPullRequestState);
    }

    @NotNull
    protected StateUI prepare(@NotNull GHPullRequestState key) {
        StateUI stateUI;
        Intrinsics.checkParameterIsNotNull((Object)((Object)key), (String)"key");
        switch (GHPRStatePanel$WhenMappings.$EnumSwitchMapping$0[key.ordinal()]) {
            case 1: {
                stateUI = StateUI.Merged.INSTANCE;
                break;
            }
            case 2: {
                stateUI = new StateUI.Closed(this.dataProvider, this.securityService, this.detailsModel.getValue().getViewerDidAuthor(), this.stateService);
                break;
            }
            case 3: {
                stateUI = new StateUI.Open(this.project, this.dataProvider, this.securityService, this.stateService, this.detailsModel, this.openComponentDisposable);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stateUI;
    }

    protected void dispose(@Nullable GHPullRequestState key) {
        if (key == GHPullRequestState.OPEN) {
            Disposer.dispose((Disposable)this.openComponentDisposable);
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
            this.openComponentDisposable = disposable;
        }
    }

    @NotNull
    protected JComponent create(@NotNull StateUI ui) {
        Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
        return ui.createComponent();
    }

    /*
     * WARNING - void declaration
     */
    public GHPRStatePanel(@NotNull Project project, @NotNull GHPRDataProvider dataProvider, @NotNull GHPRSecurityService securityService, @NotNull GHPRStateService stateService, @NotNull SingleValueModel<GHPullRequestShort> detailsModel, @NotNull Disposable parentDisposable) {
        void initialValue$iv;
        ReadWriteProperty readWriteProperty;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkParameterIsNotNull((Object)securityService, (String)"securityService");
        Intrinsics.checkParameterIsNotNull((Object)stateService, (String)"stateService");
        Intrinsics.checkParameterIsNotNull(detailsModel, (String)"detailsModel");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.dataProvider = dataProvider;
        this.securityService = securityService;
        this.stateService = stateService;
        this.detailsModel = detailsModel;
        Delegates delegates = Delegates.INSTANCE;
        GHPullRequestState gHPullRequestState = this.detailsModel.getValue().getState();
        GHPRStatePanel gHPRStatePanel = this;
        boolean $i$f$observable = false;
        gHPRStatePanel.currentState$delegate = readWriteProperty = (ReadWriteProperty)new ObservableProperty<GHPullRequestState>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ GHPRStatePanel this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = gHPRStatePanel;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                void oldValue2;
                Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                GHPullRequestState gHPullRequestState = (GHPullRequestState)((Object)newValue);
                GHPullRequestState gHPullRequestState2 = (GHPullRequestState)((Object)oldValue);
                KProperty $noName_0 = property;
                boolean bl = false;
                GHPRStatePanel.access$resetValue(this.this$0, (GHPullRequestState)oldValue2);
                this.this$0.select(newValue2, true);
            }
        };
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
        this.openComponentDisposable = disposable;
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
        this.detailsModel.addAndInvokeValueChangedListener((Disposable)this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.setCurrentState(((GHPullRequestShort)detailsModel.getValue()).getState());
            }
        }));
    }

    public static final /* synthetic */ JComponent access$resetValue(GHPRStatePanel $this, GHPullRequestState p0) {
        return (JComponent)$this.resetValue((Object)p0);
    }

    public static final /* synthetic */ GHPullRequestState access$getCurrentState$p(GHPRStatePanel $this) {
        return $this.getCurrentState();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \r2\u00020\u0001:\u0004\f\r\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H&J\u0006\u0010\n\u001a\u00020\u0005J\b\u0010\u000b\u001a\u00020\u0005H&\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI;", "", "()V", "createButtons", "", "Ljavax/swing/JComponent;", "errorHandler", "Lkotlin/Function1;", "", "", "createComponent", "createStatusComponent", "Closed", "Companion", "Merged", "Open", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Merged;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Closed;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Open;", "intellij.vcs.github"})
    public static abstract class StateUI {
        public static final int STATUSES_GAP = 4;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final JComponent createComponent() {
            JComponent statusComponent = this.createStatusComponent();
            JPanel buttonsPanel = new JPanel(new FlowLayout(0, 0, 0));
            HtmlEditorPane htmlEditorPane = new HtmlEditorPane();
            boolean bl = false;
            boolean bl2 = false;
            HtmlEditorPane $this$apply = htmlEditorPane;
            boolean bl3 = false;
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleTextAttributes, (String)"SimpleTextAttributes.ERROR_ATTRIBUTES");
            $this$apply.setForeground(simpleTextAttributes.getFgColor());
            HtmlEditorPane errorComponent = htmlEditorPane;
            BorderLayoutPanel borderLayoutPanel = ((BorderLayoutPanel)new BorderLayoutPanel().andTransparent()).addToLeft((Component)buttonsPanel).addToCenter((Component)errorComponent);
            Intrinsics.checkExpressionValueIsNotNull((Object)borderLayoutPanel, (String)"BorderLayoutPanel().andT\u2026dToCenter(errorComponent)");
            BorderLayoutPanel actionsPanel = borderLayoutPanel;
            for (JComponent button : this.createButtons((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(errorComponent){
                final /* synthetic */ HtmlEditorPane $errorComponent;

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$errorComponent.setBody(it);
                }
                {
                    this.$errorComponent = htmlEditorPane;
                    super(1);
                }
            }))) {
                buttonsPanel.add(button);
            }
            NonOpaquePanel nonOpaquePanel = new NonOpaquePanel((LayoutManager)new VerticalLayout(4));
            boolean bl4 = false;
            boolean bl5 = false;
            NonOpaquePanel $this$apply2 = nonOpaquePanel;
            boolean bl6 = false;
            $this$apply2.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
            $this$apply2.add((Component)statusComponent, (Object)"fill_h");
            $this$apply2.add((Component)actionsPanel, (Object)"fill_h");
            return (JComponent)nonOpaquePanel;
        }

        @NotNull
        public abstract JComponent createStatusComponent();

        @NotNull
        public abstract List<JComponent> createButtons(@NotNull Function1<? super String, Unit> var1);

        private StateUI() {
        }

        public /* synthetic */ StateUI(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Merged;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI;", "()V", "createButtons", "", "Ljavax/swing/JComponent;", "errorHandler", "Lkotlin/Function1;", "", "", "createStatusComponent", "Ljavax/swing/JLabel;", "intellij.vcs.github"})
        public static final class Merged
        extends StateUI {
            public static final Merged INSTANCE;

            @Override
            @NotNull
            public JLabel createStatusComponent() {
                return new JLabel("Pull request is merged", GithubIcons.PullRequestMerged, 2);
            }

            @Override
            @NotNull
            public List<JComponent> createButtons(@NotNull Function1<? super String, Unit> errorHandler) {
                Intrinsics.checkParameterIsNotNull(errorHandler, (String)"errorHandler");
                return CollectionsKt.emptyList();
            }

            private Merged() {
                super(null);
            }

            static {
                Merged merged;
                INSTANCE = merged = new Merged();
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Closed;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProvider;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "viewerIsAuthor", "", "stateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;ZLorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;)V", "canReopen", "createButtons", "", "Ljavax/swing/JComponent;", "errorHandler", "Lkotlin/Function1;", "", "", "createStatusComponent", "intellij.vcs.github"})
        public static final class Closed
        extends StateUI {
            private final boolean canReopen;
            private final GHPRDataProvider dataProvider;
            private final GHPRStateService stateService;

            @Override
            @NotNull
            public JComponent createStatusComponent() {
                JComponent jComponent;
                JLabel stateLabel = new JLabel("Pull request is closed", GithubIcons.PullRequestClosed, 2);
                if (this.canReopen) {
                    jComponent = stateLabel;
                } else {
                    JComponent jComponent2 = new JLabel();
                    boolean bl = false;
                    boolean bl2 = false;
                    JLabel $this$apply = jComponent2;
                    boolean bl3 = false;
                    $this$apply.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$apply.setText("Repository access required to manage pull requests");
                    JLabel accessDeniedLabel = jComponent2;
                    jComponent2 = new JPanel((LayoutManager)new VerticalLayout(4));
                    bl = false;
                    bl2 = false;
                    $this$apply = jComponent2;
                    boolean bl4 = false;
                    $this$apply.add((Component)stateLabel, "fill_h");
                    $this$apply.add((Component)accessDeniedLabel, "fill_h");
                    jComponent = jComponent2;
                }
                return jComponent;
            }

            @Override
            @NotNull
            public List<JComponent> createButtons(@NotNull Function1<? super String, Unit> errorHandler) {
                List list2;
                Intrinsics.checkParameterIsNotNull(errorHandler, (String)"errorHandler");
                if (this.canReopen) {
                    GHPRReopenAction action2 = new GHPRReopenAction(new SingleValueModel<Boolean>(false), errorHandler, this.stateService, this.dataProvider.getNumber());
                    list2 = CollectionsKt.listOf((Object)new JButton(action2));
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                return list2;
            }

            public Closed(@NotNull GHPRDataProvider dataProvider, @NotNull GHPRSecurityService securityService, boolean viewerIsAuthor, @NotNull GHPRStateService stateService) {
                Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
                Intrinsics.checkParameterIsNotNull((Object)securityService, (String)"securityService");
                Intrinsics.checkParameterIsNotNull((Object)stateService, (String)"stateService");
                super(null);
                this.dataProvider = dataProvider;
                this.stateService = stateService;
                this.canReopen = securityService.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.TRIAGE) || viewerIsAuthor;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0004'()*B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 H\u0016J\u0016\u0010#\u001a\u00020\u001c2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000bH\u0002J\b\u0010$\u001a\u00020\u001cH\u0002J\b\u0010%\u001a\u00020\u001cH\u0016J\b\u0010&\u001a\u00020\"H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Open;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProvider;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "stateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;", "detailsModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lcom/intellij/openapi/Disposable;)V", "canClose", "", "canCommitMerge", "canMerge", "canRebaseMerge", "canSquashMerge", "mergeForbidden", "mergeabilityModel", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "mergeabilityPoller", "Lorg/jetbrains/plugins/github/util/DelayedTaskScheduler;", "createAccessDeniedLabel", "Ljavax/swing/JComponent;", "createButtons", "", "errorHandler", "Lkotlin/Function1;", "", "", "createLoadedComponent", "createNotLoadedComponent", "createStatusComponent", "loadMergeability", "ConflictsController", "LoadingController", "RequiredReviewsController", "RestrictionsController", "intellij.vcs.github"})
        public static final class Open
        extends StateUI {
            private final boolean canClose;
            private final boolean canMerge;
            private final boolean mergeForbidden;
            private final boolean canCommitMerge;
            private final boolean canSquashMerge;
            private final boolean canRebaseMerge;
            private final SingleValueModel<GHPRMergeabilityState> mergeabilityModel;
            private final DelayedTaskScheduler mergeabilityPoller;
            private final Project project;
            private final GHPRDataProvider dataProvider;
            private final GHPRStateService stateService;
            private final SingleValueModel<GHPullRequestShort> detailsModel;

            private final void loadMergeability() {
                GithubAsyncUtilKt.successOnEdt(this.dataProvider.getMergeabilityStateRequest(), (Function1)new Function1<GHPRMergeabilityState, Unit>(this){
                    final /* synthetic */ Open this$0;

                    public final void invoke(@NotNull GHPRMergeabilityState it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Open.access$getMergeabilityModel$p(this.this$0).setValue(it);
                    }
                    {
                        this.this$0 = open;
                        super(1);
                    }
                });
            }

            @Override
            @NotNull
            public JComponent createStatusComponent() {
                Wrapper panel2 = new Wrapper();
                new LoadingController(this.mergeabilityModel, panel2, (Function0<? extends JComponent>)((Function0)new Function0<JComponent>(this){

                    @NotNull
                    public final JComponent invoke() {
                        return Open.access$createNotLoadedComponent((Open)this.receiver);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Open.class);
                    }

                    public final String getName() {
                        return "createNotLoadedComponent";
                    }

                    public final String getSignature() {
                        return "createNotLoadedComponent()Ljavax/swing/JComponent;";
                    }
                }), (Function1<? super SingleValueModel<GHPRMergeabilityState>, ? extends JComponent>)((Function1)new Function1<SingleValueModel<GHPRMergeabilityState>, JComponent>(this){

                    @NotNull
                    public final JComponent invoke(@NotNull SingleValueModel<GHPRMergeabilityState> p1) {
                        Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                        return Open.access$createLoadedComponent((Open)this.receiver, p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(Open.class);
                    }

                    public final String getName() {
                        return "createLoadedComponent";
                    }

                    public final String getSignature() {
                        return "createLoadedComponent(Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;)Ljavax/swing/JComponent;";
                    }
                }));
                return (JComponent)panel2;
            }

            private final JComponent createNotLoadedComponent() {
                JComponent jComponent;
                JLabel stateLabel = new JLabel("Loading pull request status...", AllIcons.RunConfigurations.TestNotRan, 2);
                JComponent accessDeniedLabel = this.createAccessDeniedLabel();
                if (accessDeniedLabel == null) {
                    jComponent = stateLabel;
                } else {
                    JPanel jPanel = new JPanel((LayoutManager)new VerticalLayout(4));
                    boolean bl = false;
                    boolean bl2 = false;
                    JPanel $this$apply = jPanel;
                    boolean bl3 = false;
                    $this$apply.add((Component)stateLabel, "fill_h");
                    $this$apply.add((Component)accessDeniedLabel, "fill_h");
                    jComponent = jPanel;
                }
                return jComponent;
            }

            private final JComponent createLoadedComponent(SingleValueModel<GHPRMergeabilityState> mergeabilityModel) {
                JComponent statusChecks = GHPRStatusChecksComponent.INSTANCE.create(mergeabilityModel);
                JLabel conflictsLabel = new JLabel();
                new ConflictsController(mergeabilityModel, conflictsLabel);
                JLabel requiredReviewsLabel = new JLabel();
                new RequiredReviewsController(mergeabilityModel, requiredReviewsLabel);
                JLabel restrictionsLabel = new JLabel();
                new RestrictionsController(mergeabilityModel, restrictionsLabel);
                JComponent accessDeniedLabel = this.createAccessDeniedLabel();
                JPanel jPanel = new JPanel((LayoutManager)new VerticalLayout(4));
                boolean bl = false;
                boolean bl2 = false;
                JPanel $this$apply = jPanel;
                boolean bl3 = false;
                $this$apply.add((Component)statusChecks, "fill_h");
                $this$apply.add((Component)requiredReviewsLabel, "fill_h");
                $this$apply.add((Component)conflictsLabel, "fill_h");
                $this$apply.add((Component)restrictionsLabel, "fill_h");
                if (accessDeniedLabel != null) {
                    $this$apply.add((Component)accessDeniedLabel, "fill_h");
                }
                return jPanel;
            }

            private final JComponent createAccessDeniedLabel() {
                JComponent jComponent;
                if (!this.canClose) {
                    JLabel jLabel = new JLabel();
                    boolean bl = false;
                    boolean bl2 = false;
                    JLabel $this$apply = jLabel;
                    boolean bl3 = false;
                    $this$apply.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$apply.setText("Repository access required to manage pull requests");
                    jComponent = jLabel;
                } else if (!this.canMerge) {
                    JLabel jLabel = new JLabel();
                    boolean bl = false;
                    boolean bl4 = false;
                    JLabel $this$apply = jLabel;
                    boolean bl5 = false;
                    $this$apply.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$apply.setText("Repository write access required to merge pull requests");
                    jComponent = jLabel;
                } else if (this.mergeForbidden) {
                    JLabel jLabel = new JLabel();
                    boolean bl = false;
                    boolean bl6 = false;
                    JLabel $this$apply = jLabel;
                    boolean bl7 = false;
                    $this$apply.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$apply.setText("Merging is disabled for this project");
                    jComponent = jLabel;
                } else {
                    jComponent = null;
                }
                return jComponent;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public List<JComponent> createButtons(@NotNull Function1<? super String, Unit> errorHandler) {
                Intrinsics.checkParameterIsNotNull(errorHandler, (String)"errorHandler");
                boolean bl = false;
                List list2 = new ArrayList();
                SingleValueModel<Boolean> busyStateModel = new SingleValueModel<Boolean>(false);
                if (this.canMerge && !this.mergeForbidden) {
                    Action[] actionArray;
                    boolean bl2 = false;
                    List allowedActions = new ArrayList();
                    if (this.canCommitMerge) {
                        allowedActions.add(new GHPRCommitMergeAction(busyStateModel, errorHandler, this.detailsModel, this.mergeabilityModel, this.project, this.stateService));
                    }
                    if (this.canRebaseMerge) {
                        allowedActions.add(new GHPRRebaseMergeAction(busyStateModel, errorHandler, this.mergeabilityModel, this.stateService));
                    }
                    if (this.canSquashMerge) {
                        allowedActions.add(new GHPRSquashMergeAction(busyStateModel, errorHandler, this.mergeabilityModel, this.project, this.stateService, this.dataProvider));
                    }
                    Action action2 = (Action)CollectionsKt.firstOrNull((List)allowedActions);
                    if (allowedActions.size() > 1) {
                        int n = allowedActions.size() - 1;
                        Action[] actionArray2 = new Action[n];
                        int n2 = 0;
                        while (n2 < n) {
                            void it;
                            Action action3;
                            int n3 = n2;
                            int n4 = n2++;
                            Action[] actionArray3 = actionArray2;
                            boolean bl3 = false;
                            actionArray3[n4] = action3 = (Action)allowedActions.get((int)(it + true));
                        }
                        actionArray = actionArray2;
                    } else {
                        actionArray = new Action[]{};
                    }
                    Action[] actions = actionArray;
                    JBOptionButton mergeButton = new JBOptionButton(action2, actions);
                    list2.add(mergeButton);
                }
                if (this.canClose) {
                    GHPRCloseAction action4 = new GHPRCloseAction(new SingleValueModel<Boolean>(false), errorHandler, this.stateService, this.dataProvider.getNumber());
                    list2.add(new JButton(action4));
                }
                return list2;
            }

            public Open(@NotNull Project project, @NotNull GHPRDataProvider dataProvider, @NotNull GHPRSecurityService securityService, @NotNull GHPRStateService stateService, @NotNull SingleValueModel<GHPullRequestShort> detailsModel, @NotNull Disposable parentDisposable) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
                Intrinsics.checkParameterIsNotNull((Object)securityService, (String)"securityService");
                Intrinsics.checkParameterIsNotNull((Object)stateService, (String)"stateService");
                Intrinsics.checkParameterIsNotNull(detailsModel, (String)"detailsModel");
                Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
                super(null);
                this.project = project;
                this.dataProvider = dataProvider;
                this.stateService = stateService;
                this.detailsModel = detailsModel;
                this.canClose = securityService.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.TRIAGE) || this.detailsModel.getValue().getViewerDidAuthor();
                this.canMerge = securityService.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.WRITE);
                this.mergeForbidden = securityService.isMergeForbiddenForProject();
                this.canCommitMerge = securityService.isMergeAllowed();
                this.canSquashMerge = securityService.isSquashMergeAllowed();
                this.canRebaseMerge = securityService.isRebaseMergeAllowed();
                this.mergeabilityModel = new SingleValueModel<Object>(null);
                this.mergeabilityPoller = new DelayedTaskScheduler(3L, parentDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ Open this$0;

                    public final void invoke() {
                        Open.access$getDataProvider$p(this.this$0).reloadMergeabilityState();
                    }
                    {
                        this.this$0 = open;
                        super(0);
                    }
                }));
                this.dataProvider.addRequestsChangesListener(parentDisposable, new GHPRDataProvider.RequestsChangedListener(){

                    @Override
                    public void mergeabilityStateRequestChanged() {
                        this.loadMergeability();
                    }

                    @Override
                    public void detailsRequestChanged() {
                        GHPRDataProvider.RequestsChangedListener.DefaultImpls.detailsRequestChanged(this);
                    }

                    @Override
                    public void commitsRequestChanged() {
                        GHPRDataProvider.RequestsChangedListener.DefaultImpls.commitsRequestChanged(this);
                    }

                    @Override
                    public void reviewThreadsRequestChanged() {
                        GHPRDataProvider.RequestsChangedListener.DefaultImpls.reviewThreadsRequestChanged(this);
                    }
                });
                this.loadMergeability();
                this.mergeabilityModel.addValueChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        GHPRMergeabilityState state2 = (GHPRMergeabilityState)mergeabilityModel.getValue();
                        if (state2 != null && state2.getHasConflicts() == null) {
                            mergeabilityPoller.start();
                        } else {
                            mergeabilityPoller.stop();
                        }
                    }
                }));
            }

            public static final /* synthetic */ JComponent access$createNotLoadedComponent(Open $this) {
                return $this.createNotLoadedComponent();
            }

            public static final /* synthetic */ JComponent access$createLoadedComponent(Open $this, SingleValueModel mergeabilityModel) {
                return $this.createLoadedComponent(mergeabilityModel);
            }

            public static final /* synthetic */ GHPRDataProvider access$getDataProvider$p(Open $this) {
                return $this.dataProvider;
            }

            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BT\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012'\u0010\n\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0011\u001a\u00020\u0012H\u0002R/\u0010\n\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Open$LoadingController;", "", "loadingMergeabilityModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "panel", "Lcom/intellij/ui/components/panels/Wrapper;", "notLoadedContentFactory", "Lkotlin/Function0;", "Ljavax/swing/JComponent;", "loadedContentFactory", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "mergeabilityModel", "(Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lcom/intellij/ui/components/panels/Wrapper;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "loadedMergeabilityModel", "update", "", "intellij.vcs.github"})
            private static final class LoadingController {
                private SingleValueModel<GHPRMergeabilityState> loadedMergeabilityModel;
                private final SingleValueModel<GHPRMergeabilityState> loadingMergeabilityModel;
                private final Wrapper panel;
                private final Function0<JComponent> notLoadedContentFactory;
                private final Function1<SingleValueModel<GHPRMergeabilityState>, JComponent> loadedContentFactory;

                private final void update() {
                    GHPRMergeabilityState mergeability = this.loadingMergeabilityModel.getValue();
                    if (mergeability == null) {
                        this.loadedMergeabilityModel = null;
                        this.panel.setContent((JComponent)this.notLoadedContentFactory.invoke());
                    } else {
                        SingleValueModel<GHPRMergeabilityState> mergeabilityModel = this.loadedMergeabilityModel;
                        if (mergeabilityModel == null) {
                            mergeabilityModel = new SingleValueModel<GHPRMergeabilityState>(mergeability);
                            this.panel.setContent((JComponent)this.loadedContentFactory.invoke(mergeabilityModel));
                            this.panel.revalidate();
                            this.loadedMergeabilityModel = mergeabilityModel;
                        } else {
                            mergeabilityModel.setValue(mergeability);
                        }
                    }
                }

                public LoadingController(@NotNull SingleValueModel<GHPRMergeabilityState> loadingMergeabilityModel, @NotNull Wrapper panel2, @NotNull Function0<? extends JComponent> notLoadedContentFactory, @NotNull Function1<? super SingleValueModel<GHPRMergeabilityState>, ? extends JComponent> loadedContentFactory) {
                    Intrinsics.checkParameterIsNotNull(loadingMergeabilityModel, (String)"loadingMergeabilityModel");
                    Intrinsics.checkParameterIsNotNull((Object)panel2, (String)"panel");
                    Intrinsics.checkParameterIsNotNull(notLoadedContentFactory, (String)"notLoadedContentFactory");
                    Intrinsics.checkParameterIsNotNull(loadedContentFactory, (String)"loadedContentFactory");
                    this.loadingMergeabilityModel = loadingMergeabilityModel;
                    this.panel = panel2;
                    this.notLoadedContentFactory = notLoadedContentFactory;
                    this.loadedContentFactory = loadedContentFactory;
                    this.loadingMergeabilityModel.addAndInvokeValueChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(this){

                        public final void invoke() {
                            ((LoadingController)this.receiver).update();
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(LoadingController.class);
                        }

                        public final String getName() {
                            return "update";
                        }

                        public final String getSignature() {
                            return "update()V";
                        }
                    }));
                }
            }

            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Open$ConflictsController;", "", "mergeabilityModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "label", "Ljavax/swing/JLabel;", "(Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Ljavax/swing/JLabel;)V", "update", "", "intellij.vcs.github"})
            private static final class ConflictsController {
                private final SingleValueModel<GHPRMergeabilityState> mergeabilityModel;
                private final JLabel label;

                private final void update() {
                    block1: {
                        Boolean bl;
                        block2: {
                            block0: {
                                bl = this.mergeabilityModel.getValue().getHasConflicts();
                                if (!Intrinsics.areEqual((Object)bl, (Object)false)) break block0;
                                this.label.setIcon(AllIcons.RunConfigurations.TestPassed);
                                this.label.setText("Branch has no conflicts with base branch");
                                break block1;
                            }
                            if (!Intrinsics.areEqual((Object)bl, (Object)true)) break block2;
                            this.label.setIcon(AllIcons.RunConfigurations.TestError);
                            this.label.setText("Branch has conflicts that must be resolved");
                            break block1;
                        }
                        if (bl != null) break block1;
                        this.label.setIcon(AllIcons.RunConfigurations.TestNotRan);
                        this.label.setText("Checking for ability to merge automatically...");
                    }
                }

                public ConflictsController(@NotNull SingleValueModel<GHPRMergeabilityState> mergeabilityModel, @NotNull JLabel label) {
                    Intrinsics.checkParameterIsNotNull(mergeabilityModel, (String)"mergeabilityModel");
                    Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
                    this.mergeabilityModel = mergeabilityModel;
                    this.label = label;
                    this.mergeabilityModel.addAndInvokeValueChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(this){

                        public final void invoke() {
                            ((ConflictsController)this.receiver).update();
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(ConflictsController.class);
                        }

                        public final String getName() {
                            return "update";
                        }

                        public final String getSignature() {
                            return "update()V";
                        }
                    }));
                }
            }

            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Open$RequiredReviewsController;", "", "mergeabilityModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "label", "Ljavax/swing/JLabel;", "(Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Ljavax/swing/JLabel;)V", "update", "", "intellij.vcs.github"})
            private static final class RequiredReviewsController {
                private final SingleValueModel<GHPRMergeabilityState> mergeabilityModel;
                private final JLabel label;

                private final void update() {
                    int requiredApprovingReviewsCount = this.mergeabilityModel.getValue().getRequiredApprovingReviewsCount();
                    this.label.setVisible(requiredApprovingReviewsCount > 0);
                    JLabel jLabel = this.label;
                    boolean bl = false;
                    boolean bl2 = false;
                    JLabel $this$with = jLabel;
                    boolean bl3 = false;
                    $this$with.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$with.setText("At least " + requiredApprovingReviewsCount + " approving review is required by reviewers with write access");
                }

                public RequiredReviewsController(@NotNull SingleValueModel<GHPRMergeabilityState> mergeabilityModel, @NotNull JLabel label) {
                    Intrinsics.checkParameterIsNotNull(mergeabilityModel, (String)"mergeabilityModel");
                    Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
                    this.mergeabilityModel = mergeabilityModel;
                    this.label = label;
                    this.mergeabilityModel.addAndInvokeValueChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(this){

                        public final void invoke() {
                            ((RequiredReviewsController)this.receiver).update();
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(RequiredReviewsController.class);
                        }

                        public final String getName() {
                            return "update";
                        }

                        public final String getSignature() {
                            return "update()V";
                        }
                    }));
                }
            }

            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Open$RestrictionsController;", "", "mergeabilityModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "label", "Ljavax/swing/JLabel;", "(Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Ljavax/swing/JLabel;)V", "update", "", "intellij.vcs.github"})
            private static final class RestrictionsController {
                private final SingleValueModel<GHPRMergeabilityState> mergeabilityModel;
                private final JLabel label;

                private final void update() {
                    JLabel jLabel = this.label;
                    boolean bl = false;
                    boolean bl2 = false;
                    JLabel $this$with = jLabel;
                    boolean bl3 = false;
                    $this$with.setVisible(this.mergeabilityModel.getValue().isRestricted());
                    $this$with.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$with.setText("You are not authorized to merge pull requests into this branch");
                }

                public RestrictionsController(@NotNull SingleValueModel<GHPRMergeabilityState> mergeabilityModel, @NotNull JLabel label) {
                    Intrinsics.checkParameterIsNotNull(mergeabilityModel, (String)"mergeabilityModel");
                    Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
                    this.mergeabilityModel = mergeabilityModel;
                    this.label = label;
                    this.mergeabilityModel.addAndInvokeValueChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(this){

                        public final void invoke() {
                            ((RestrictionsController)this.receiver).update();
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(RestrictionsController.class);
                        }

                        public final String getName() {
                            return "update";
                        }

                        public final String getSignature() {
                            return "update()V";
                        }
                    }));
                }
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Companion;", "", "()V", "STATUSES_GAP", "", "intellij.vcs.github"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

