/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CollectionListModel;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.messages.MessageBusOwner;
import git4idea.commands.Git;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHRepositoryOwnerName;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermission;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLPagedRequestResponse;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLRequestPagination;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoaderBase;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataLoaderImpl;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.GHPRListLoaderImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRCommentServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRMetadataServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRReviewServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRStateServiceImpl;
import org.jetbrains.plugins.github.pullrequest.search.GithubPullRequestSearchQueryHolderImpl;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.GithubSharedProjectSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContextRepository;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getContext", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "gitRemoteCoordinates", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "Companion", "intellij.vcs.github"})
public final class GHPRDataContextRepository {
    private final Project project;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final GHPRDataContext getContext(@NotNull ProgressIndicator indicator, @NotNull GithubAccount account, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GitRemoteUrlCoordinates gitRemoteCoordinates) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Intrinsics.checkParameterIsNotNull((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)gitRemoteCoordinates, (String)"gitRemoteCoordinates");
        GHRepositoryPath gHRepositoryPath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(gitRemoteCoordinates.getUrl());
        if (gHRepositoryPath == null) {
            throw (Throwable)new IllegalArgumentException("Invalid GitHub Repository URL - " + gitRemoteCoordinates.getUrl() + " is not a GitHub repository");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gHRepositoryPath, (String)"GithubUrlUtil.getUserAnd\u2026not a GitHub repository\")");
        GHRepositoryPath fullPath = gHRepositoryPath;
        indicator.setText("Loading account information");
        GithubAuthenticatedUser accountDetails = GithubAccountInformationProvider.Companion.getInstance().getInformation(requestExecutor, indicator, account);
        indicator.checkCanceled();
        indicator.setText("Loading repository information");
        GithubServerPath githubServerPath = account.getServer();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"account.server");
        GHRepositoryPermission gHRepositoryPermission = (GHRepositoryPermission)requestExecutor.execute(indicator, (GithubApiRequest)GHGQLRequests.Repo.INSTANCE.findPermission(new GHRepositoryCoordinates(githubServerPath, fullPath)));
        if (gHRepositoryPermission == null) {
            throw (Throwable)new IllegalArgumentException("Repository " + fullPath + " does not exist at " + account.getServer() + " or you don't have access.");
        }
        GHRepositoryPermission repoWithPermissions = gHRepositoryPermission;
        String string = accountDetails.getNodeId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"accountDetails.nodeId");
        String string2 = accountDetails.getLogin();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"accountDetails.login");
        String string3 = accountDetails.getHtmlUrl();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"accountDetails.htmlUrl");
        String string4 = accountDetails.getAvatarUrl();
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"accountDetails.avatarUrl!!");
        GHUser currentUser = new GHUser(string, string2, string3, string4, accountDetails.getName());
        indicator.setText("Loading user teams information");
        GHRepositoryOwnerName repoOwner = repoWithPermissions.getOwner();
        List<GHTeam> currentUserTeams2 = repoOwner instanceof GHRepositoryOwnerName.Organization ? new SimpleGHGQLPagesLoader(requestExecutor, (Function1)new Function1<GHGQLRequestPagination, GithubApiRequest.Post.GQLQuery<? extends GHGQLPagedRequestResponse<? extends GHTeam>>>(account, repoOwner, currentUser){
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ GHRepositoryOwnerName $repoOwner;
            final /* synthetic */ GHUser $currentUser;

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHGQLPagedRequestResponse<GHTeam>> invoke(@NotNull GHGQLRequestPagination it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                GithubServerPath githubServerPath = this.$account.getServer();
                Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"account.server");
                return GHGQLRequests.Organization.Team.INSTANCE.findByUserLogins(githubServerPath, this.$repoOwner.getLogin(), CollectionsKt.listOf((Object)this.$currentUser.getLogin()), it);
            }
            {
                this.$account = githubAccount;
                this.$repoOwner = gHRepositoryOwnerName;
                this.$currentUser = gHUser;
                super(1);
            }
        }, false, 0, 12, null).loadAll(indicator) : CollectionsKt.emptyList();
        GithubServerPath githubServerPath2 = account.getServer();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath2, (String)"account.server");
        GHRepositoryCoordinates repositoryCoordinates = new GHRepositoryCoordinates(githubServerPath2, repoWithPermissions.getPath());
        MessageBus messageBus2 = MessageBusFactory.getInstance().createMessageBus(new MessageBusOwner(this){
            final /* synthetic */ GHPRDataContextRepository this$0;

            public boolean isDisposed() {
                return GHPRDataContextRepository.access$getProject$p(this.this$0).isDisposed();
            }

            @NotNull
            public Void createListener(@NotNull ListenerDescriptor descriptor) {
                Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                throw (Throwable)new UnsupportedOperationException();
            }
            {
                this.this$0 = $outer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBus2, (String)"MessageBusFactory.getIns\u2026erationException()\n    })");
        MessageBus messageBus3 = messageBus2;
        GHPRSecurityServiceImpl securityService = new GHPRSecurityServiceImpl(GithubSharedProjectSettings.Companion.getInstance(this.project), currentUser, currentUserTeams2, repoWithPermissions);
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        GHPRReviewServiceImpl reviewService = new GHPRReviewServiceImpl(progressManager, messageBus3, securityService, requestExecutor, repositoryCoordinates);
        ProgressManager progressManager2 = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager2, (String)"ProgressManager.getInstance()");
        GHPRCommentServiceImpl commentService = new GHPRCommentServiceImpl(progressManager2, messageBus3, securityService, requestExecutor, repositoryCoordinates);
        CollectionListModel listModel = new CollectionListModel((Object[])new GHPullRequestShort[0]);
        GithubPullRequestSearchQueryHolderImpl searchHolder = new GithubPullRequestSearchQueryHolderImpl();
        ProgressManager progressManager3 = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager3, (String)"ProgressManager.getInstance()");
        GithubServerPath githubServerPath3 = account.getServer();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath3, (String)"account.server");
        GHPRListLoaderImpl listLoader = new GHPRListLoaderImpl(progressManager3, requestExecutor, githubServerPath3, repoWithPermissions.getPath(), (CollectionListModel<GHPullRequestShort>)listModel, searchHolder);
        GHPRDataLoaderImpl dataLoader2 = new GHPRDataLoaderImpl((Function1<? super Long, ? extends GHPRDataProvider>)((Function1)new Function1<Long, GHPRDataProviderImpl>(this, securityService, requestExecutor, gitRemoteCoordinates, repositoryCoordinates){
            final /* synthetic */ GHPRDataContextRepository this$0;
            final /* synthetic */ GHPRSecurityServiceImpl $securityService;
            final /* synthetic */ GithubApiRequestExecutor $requestExecutor;
            final /* synthetic */ GitRemoteUrlCoordinates $gitRemoteCoordinates;
            final /* synthetic */ GHRepositoryCoordinates $repositoryCoordinates;

            @NotNull
            public final GHPRDataProviderImpl invoke(long it) {
                Project project = GHPRDataContextRepository.access$getProject$p(this.this$0);
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                Git git = Git.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)git, (String)"Git.getInstance()");
                return new GHPRDataProviderImpl(project, progressManager, git, this.$securityService, this.$requestExecutor, this.$gitRemoteCoordinates, this.$repositoryCoordinates, it);
            }
            {
                this.this$0 = gHPRDataContextRepository;
                this.$securityService = gHPRSecurityServiceImpl;
                this.$requestExecutor = githubApiRequestExecutor;
                this.$gitRemoteCoordinates = gitRemoteUrlCoordinates;
                this.$repositoryCoordinates = gHRepositoryCoordinates;
                super(1);
            }
        }));
        requestExecutor.addListener(dataLoader2, (Function0<Unit>)((Function0)new Function0<Unit>(dataLoader2){
            final /* synthetic */ GHPRDataLoaderImpl $dataLoader;

            public final void invoke() {
                this.$dataLoader.invalidateAllData();
            }
            {
                this.$dataLoader = gHPRDataLoaderImpl;
                super(0);
            }
        }));
        messageBus3.connect().subscribe(GHPRDataContext.Companion.getPULL_REQUEST_EDITED_TOPIC(), (Object)new GHPRDataContext.Companion.PullRequestEditedListener(dataLoader2, listLoader){
            final /* synthetic */ GHPRDataLoaderImpl $dataLoader;
            final /* synthetic */ GHPRListLoaderImpl $listLoader;

            public void onPullRequestEdited(long number) {
                Application app$iv;
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application application = app$iv = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                if (application.isDispatchThread()) {
                    Object object;
                    Object object2;
                    GHPRDataProvider dataProvider;
                    boolean bl = false;
                    GHPRDataProvider gHPRDataProvider = dataProvider = this.$dataLoader.findDataProvider(number);
                    if (gHPRDataProvider != null) {
                        gHPRDataProvider.reloadDetails();
                    }
                    if ((object2 = dataProvider) != null && (object2 = object2.getDetailsRequest()) != null) {
                        Object object3 = object2;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Object it = object3;
                        boolean bl4 = false;
                        this.$listLoader.reloadData((CompletableFuture<? extends GHPullRequestShort>)it);
                    }
                    if ((object = dataProvider) != null && (object = object.getTimelineLoader()) != null) {
                        ((GHListLoaderBase)object).loadMore(true);
                    }
                } else {
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, number){
                        final /* synthetic */ getContext.2 this$0;
                        final /* synthetic */ long $number$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$number$inlined = l;
                        }

                        public final void run() {
                            block2: {
                                Object object;
                                Object object2;
                                GHPRDataProvider dataProvider;
                                boolean bl = false;
                                GHPRDataProvider gHPRDataProvider = dataProvider = this.this$0.$dataLoader.findDataProvider(this.$number$inlined);
                                if (gHPRDataProvider != null) {
                                    gHPRDataProvider.reloadDetails();
                                }
                                if ((object2 = dataProvider) != null && (object2 = object2.getDetailsRequest()) != null) {
                                    Object object3 = object2;
                                    boolean bl2 = false;
                                    boolean bl3 = false;
                                    Object it = object3;
                                    boolean bl4 = false;
                                    this.this$0.$listLoader.reloadData((CompletableFuture<? extends GHPullRequestShort>)it);
                                }
                                if ((object = dataProvider) == null || (object = object.getTimelineLoader()) == null) break block2;
                                ((GHListLoaderBase)object).loadMore(true);
                            }
                        }
                    }, ModalityState.defaultModalityState());
                }
            }

            public void onPullRequestReviewsEdited(long number) {
                Application app$iv;
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application application = app$iv = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                if (application.isDispatchThread()) {
                    Object object;
                    GHPRDataProvider dataProvider;
                    boolean bl = false;
                    GHPRDataProvider gHPRDataProvider = dataProvider = this.$dataLoader.findDataProvider(number);
                    if (gHPRDataProvider != null) {
                        gHPRDataProvider.reloadReviewThreads();
                    }
                    if ((object = dataProvider) != null && (object = object.getTimelineLoader()) != null) {
                        ((GHListLoaderBase)object).loadMore(true);
                    }
                } else {
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, number){
                        final /* synthetic */ getContext.2 this$0;
                        final /* synthetic */ long $number$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$number$inlined = l;
                        }

                        public final void run() {
                            block1: {
                                Object object;
                                GHPRDataProvider dataProvider;
                                boolean bl = false;
                                GHPRDataProvider gHPRDataProvider = dataProvider = this.this$0.$dataLoader.findDataProvider(this.$number$inlined);
                                if (gHPRDataProvider != null) {
                                    gHPRDataProvider.reloadReviewThreads();
                                }
                                if ((object = dataProvider) == null || (object = object.getTimelineLoader()) == null) break block1;
                                ((GHListLoaderBase)object).loadMore(true);
                            }
                        }
                    }, ModalityState.defaultModalityState());
                }
            }

            public void onPullRequestCommentsEdited(long number) {
                Application app$iv;
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application application = app$iv = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                if (application.isDispatchThread()) {
                    boolean bl = false;
                    GHPRDataProvider dataProvider = this.$dataLoader.findDataProvider(number);
                    Object object = dataProvider;
                    if (object != null && (object = object.getTimelineLoader()) != null) {
                        ((GHListLoaderBase)object).loadMore(true);
                    }
                } else {
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, number){
                        final /* synthetic */ getContext.2 this$0;
                        final /* synthetic */ long $number$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$number$inlined = l;
                        }

                        public final void run() {
                            block0: {
                                boolean bl = false;
                                GHPRDataProvider dataProvider = this.this$0.$dataLoader.findDataProvider(this.$number$inlined);
                                Object object = dataProvider;
                                if (object == null || (object = object.getTimelineLoader()) == null) break block0;
                                ((GHListLoaderBase)object).loadMore(true);
                            }
                        }
                    }, ModalityState.defaultModalityState());
                }
            }
            {
                this.$dataLoader = $captured_local_variable$0;
                this.$listLoader = $captured_local_variable$1;
            }
        });
        ProgressManager progressManager4 = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager4, (String)"ProgressManager.getInstance()");
        GithubServerPath githubServerPath4 = account.getServer();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath4, (String)"account.server");
        GHPRMetadataServiceImpl metadataService = new GHPRMetadataServiceImpl(progressManager4, messageBus3, requestExecutor, githubServerPath4, repoWithPermissions.getPath(), repoOwner);
        ProgressManager progressManager5 = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager5, (String)"ProgressManager.getInstance()");
        GithubServerPath githubServerPath5 = account.getServer();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath5, (String)"account.server");
        GHPRStateServiceImpl stateService = new GHPRStateServiceImpl(progressManager5, messageBus3, requestExecutor, githubServerPath5, repoWithPermissions.getPath());
        return new GHPRDataContext(gitRemoteCoordinates, repositoryCoordinates, account, requestExecutor, messageBus3, (ListModel)listModel, searchHolder, listLoader, dataLoader2, securityService, metadataService, stateService, reviewService, commentService);
    }

    public GHPRDataContextRepository(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRDataContextRepository $this) {
        return $this.project;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContextRepository$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContextRepository;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final GHPRDataContextRepository getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(GHPRDataContextRepository.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
            return (GHPRDataContextRepository)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

