/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.AuthData;
import git4idea.DialogManager;
import git4idea.remote.InteractiveGitHttpAuthDataProvider;
import java.awt.Component;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GithubChooseAccountDialog;
import org.jetbrains.plugins.github.extensions.GithubHttpAuthDataProvider;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/extensions/InteractiveSelectGithubAccountHttpAuthDataProvider;", "Lgit4idea/remote/InteractiveGitHttpAuthDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "potentialAccounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;)V", "getAuthData", "Lcom/intellij/util/AuthData;", "parentComponent", "Ljava/awt/Component;", "intellij.vcs.github"})
public final class InteractiveSelectGithubAccountHttpAuthDataProvider
implements InteractiveGitHttpAuthDataProvider {
    private final Project project;
    private final Collection<GithubAccount> potentialAccounts;
    private final GithubAuthenticationManager authenticationManager;

    @Nullable
    public AuthData getAuthData(@Nullable Component parentComponent) {
        GithubChooseAccountDialog dialog2 = new GithubChooseAccountDialog(this.project, parentComponent, this.potentialAccounts, null, false, true, "Choose GitHub Account", "Log In");
        DialogManager.show((DialogWrapper)dialog2);
        if (!dialog2.isOK()) {
            return null;
        }
        GithubAccount account = dialog2.getAccount();
        String string = this.authenticationManager.getTokenForAccount$intellij_vcs_github(account);
        if (string == null) {
            string = this.authenticationManager.requestNewToken$intellij_vcs_github(account, this.project, parentComponent);
        }
        if (string == null) {
            return null;
        }
        String token = string;
        if (dialog2.getSetDefault()) {
            this.authenticationManager.setDefaultAccount(this.project, account);
        }
        return new GithubHttpAuthDataProvider.GithubAccountAuthData(account, "x-oauth-basic", token);
    }

    public InteractiveSelectGithubAccountHttpAuthDataProvider(@NotNull Project project, @NotNull Collection<? extends GithubAccount> potentialAccounts, @NotNull GithubAuthenticationManager authenticationManager) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(potentialAccounts, (String)"potentialAccounts");
        Intrinsics.checkParameterIsNotNull((Object)authenticationManager, (String)"authenticationManager");
        this.project = project;
        this.potentialAccounts = potentialAccounts;
        this.authenticationManager = authenticationManager;
    }
}

