/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.FileChannelUtil;
import com.intellij.util.io.MappedBufferWrapper;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ReadOnlyMappedBufferWrapper
extends MappedBufferWrapper {
    protected ReadOnlyMappedBufferWrapper(Path file, int pos) throws IOException {
        super(file, pos, Files.size(file) - (long)pos);
    }

    @Override
    protected MappedByteBuffer map() throws IOException {
        try (FileChannel channel = FileChannelUtil.unInterruptible(FileChannel.open(this.myFile, new OpenOption[0]));){
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, this.myPosition, this.myLength);
            return mappedByteBuffer;
        }
    }
}

