/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import cx.ath.matthew.unix.UnixServerSocket;
import cx.ath.matthew.unix.UnixSocket;
import cx.ath.matthew.unix.UnixSocketAddress;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import org.freedesktop.Hexdump;
import org.freedesktop.dbus.MessageReader;
import org.freedesktop.dbus.MessageWriter;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.SASL;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.messages.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transport
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MessageReader min;
    private MessageWriter mout;
    private UnixServerSocket unixServerSocket;

    public Transport() {
    }

    public static String genGUID() {
        Random r = new Random();
        byte[] buf = new byte[16];
        r.nextBytes(buf);
        String guid = Hexdump.toHex(buf);
        return guid.replaceAll(" ", "");
    }

    public Transport(BusAddress address) throws IOException {
        this.connect(address);
    }

    public Transport(String address) throws IOException, DBusException {
        this.connect(new BusAddress(address));
    }

    public Transport(String address, int timeout) throws IOException, DBusException {
        this.connect(new BusAddress(address), timeout);
    }

    public Transport(BusAddress address, int timeout) throws IOException, DBusException {
        this.connect(address, timeout);
    }

    public void writeMessage(Message message) throws IOException {
        if (this.mout != null) {
            this.mout.writeMessage(message);
        }
    }

    public Message readMessage() throws IOException, DBusException {
        if (this.min != null) {
            try {
                return this.min.readMessage();
            }
            catch (Exception _ex) {
                if (_ex instanceof EOFException) {
                    return null;
                }
                this.logger.warn("Error while waiting for message: ", (Throwable)_ex);
            }
        }
        return null;
    }

    private void connect(BusAddress address) throws IOException {
        this.connect(address, 0);
    }

    private void connect(BusAddress address, int timeout) throws IOException {
        this.logger.debug("Connecting to {}", (Object)address);
        OutputStream out = null;
        InputStream in = null;
        UnixSocket us = null;
        Socket s = null;
        int mode = 0;
        int types = 0;
        if (address.getBusType() == BusAddress.AddressBusTypes.UNIX) {
            types = 1;
            if (null != address.getParameter("listen")) {
                mode = 1;
                this.unixServerSocket = new UnixServerSocket();
                if (null != address.getParameter("abstract")) {
                    this.unixServerSocket.bind(new UnixSocketAddress(address.getParameter("abstract"), true));
                } else if (null != address.getParameter("path")) {
                    this.unixServerSocket.bind(new UnixSocketAddress(address.getParameter("path"), false));
                }
                us = this.unixServerSocket.accept();
            } else {
                mode = 2;
                us = new UnixSocket();
                if (null != address.getParameter("abstract")) {
                    us.connect(new UnixSocketAddress(address.getParameter("abstract"), true));
                } else if (null != address.getParameter("path")) {
                    us.connect(new UnixSocketAddress(address.getParameter("path"), false));
                }
            }
            us.setPassCred(true);
            in = us.getInputStream();
            out = us.getOutputStream();
        } else if (address.getBusType() == BusAddress.AddressBusTypes.TCP) {
            types = 2;
            if (null != address.getParameter("listen")) {
                mode = 1;
                try (ServerSocket ss = new ServerSocket();){
                    ss.bind(new InetSocketAddress(address.getParameter("host"), Integer.parseInt(address.getParameter("port"))));
                    s = ss.accept();
                }
            } else {
                mode = 2;
                s = new Socket();
                s.connect(new InetSocketAddress(address.getParameter("host"), Integer.parseInt(address.getParameter("port"))));
            }
            in = s.getInputStream();
            out = s.getOutputStream();
        } else {
            throw new IOException("unknown address type " + address.getType());
        }
        if (!new SASL().auth(mode, types, address.getParameter("guid"), out, in, us)) {
            out.close();
            throw new IOException("Failed to auth");
        }
        if (null != us) {
            this.logger.trace("Setting timeout to {} on Socket", (Object)timeout);
            if (timeout == 1) {
                us.setBlocking(false);
            } else {
                us.setSoTimeout(timeout);
            }
        }
        if (null != s) {
            this.logger.trace("Setting timeout to {} on Socket", (Object)timeout);
            s.setSoTimeout(timeout);
        }
        this.mout = new MessageWriter(out);
        this.min = new MessageReader(in);
    }

    public synchronized void disconnect() throws IOException {
        this.logger.debug("Disconnecting Transport");
        this.min.close();
        this.mout.close();
        if (this.unixServerSocket != null && !this.unixServerSocket.isClosed()) {
            this.unixServerSocket.close();
        }
    }

    public boolean isConnected() {
        return this.min.isClosed() || this.mout.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }
}

