/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteMappingsManager;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.extensions.python.ProgressManagerExtKt;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import java.nio.charset.Charset;
import java.util.Collection;
import kotlin.jvm.functions.Function0;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonRemoteInterpreterManager {
    public static final ExtensionPointName<PythonRemoteInterpreterManager> EP_NAME = ExtensionPointName.create((String)"Pythonid.remoteInterpreterManager");
    public static final Key<PathMapper> PATH_MAPPING_SETTINGS_KEY = Key.create((String)"PATH_MAPPING_SETTINGS_KEY");
    public static final Key<PathMappingSettings> ADDITIONAL_MAPPINGS = Key.create((String)"ADDITIONAL_MAPPINGS");
    public static final String PYTHON_PREFIX = "python";

    public abstract boolean editSdk(@NotNull Project var1, @NotNull SdkModificator var2, @NotNull Collection<Sdk> var3);

    @Nullable
    public static PythonRemoteInterpreterManager getInstance() {
        if (((PythonRemoteInterpreterManager[])EP_NAME.getExtensions()).length > 0) {
            return ((PythonRemoteInterpreterManager[])EP_NAME.getExtensions())[0];
        }
        return null;
    }

    public static void addUnbuffered(@NotNull ParamsGroup exeGroup) {
        if (exeGroup == null) {
            PythonRemoteInterpreterManager.$$$reportNull$$$0(0);
        }
        for (String param : exeGroup.getParametersList().getParameters()) {
            if (!"-u".equals(param)) continue;
            return;
        }
        exeGroup.addParameter("-u");
    }

    public static String toSystemDependent(@NotNull String path, boolean isWin) {
        if (path == null) {
            PythonRemoteInterpreterManager.$$$reportNull$$$0(1);
        }
        char separator = isWin ? (char)'\\' : '/';
        return FileUtil.toSystemIndependentName((String)path).replace('/', separator);
    }

    public static void addHelpersMapping(@NotNull RemoteSdkProperties data, @NotNull PyRemotePathMapper pathMapper) {
        if (data == null) {
            PythonRemoteInterpreterManager.$$$reportNull$$$0(2);
        }
        if (pathMapper == null) {
            PythonRemoteInterpreterManager.$$$reportNull$$$0(3);
        }
        pathMapper.addMapping(PythonHelpersLocator.getHelpersRoot().getPath(), data.getHelpersPath(), PyRemotePathMapper.PyPathMappingType.HELPERS);
    }

    @NotNull
    public static PyRemotePathMapper appendBasicMappings(final @Nullable Project project, @Nullable PyRemotePathMapper pathMapper, final @NotNull RemoteSdkAdditionalData<?> data) {
        if (data == null) {
            PythonRemoteInterpreterManager.$$$reportNull$$$0(4);
        }
        @NotNull PyRemotePathMapper newPathMapper = PyRemotePathMapper.cloneMapper(pathMapper);
        PythonRemoteInterpreterManager.addHelpersMapping(data, newPathMapper);
        newPathMapper.addAll(data.getPathMappings().getPathMappings(), PyRemotePathMapper.PyPathMappingType.SYS_PATH);
        if (project != null) {
            RemoteMappingsManager.Mappings mappings = RemoteMappingsManager.getInstance((Project)project).getForServer(PYTHON_PREFIX, data.getSdkId());
            if (mappings != null) {
                newPathMapper.addAll(mappings.getSettings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
            }
            for (final PathMappingProvider mappingProvider : PathMappingProvider.getSuitableMappingProviders(data)) {
                PathMappingSettings settings = ProgressManagerExtKt.runUnderProgress(ProgressManager.getInstance(), "Accessing remote interpreter...", new Function0<PathMappingSettings>(){

                    public PathMappingSettings invoke() {
                        return mappingProvider.getPathMappingSettings(project, data);
                    }
                });
                newPathMapper.addAll(settings.getPathMappings(), PyRemotePathMapper.PyPathMappingType.REPLICATED_FOLDER);
            }
        }
        PyRemotePathMapper pyRemotePathMapper = newPathMapper;
        if (pyRemotePathMapper == null) {
            PythonRemoteInterpreterManager.$$$reportNull$$$0(5);
        }
        return pyRemotePathMapper;
    }

    @NotNull
    public abstract SdkAdditionalData loadRemoteSdkData(@NotNull Sdk var1, @Nullable Element var2);

    @NotNull
    public abstract PyConsoleProcessHandler createConsoleProcessHandler(@NotNull Process var1, @NotNull PythonConsoleView var2, @NotNull PydevConsoleCommunication var3, @NotNull String var4, @NotNull Charset var5, @Nullable PyRemotePathMapper var6, @NotNull PyRemoteSocketToLocalHostProvider var7);

    public abstract String @NotNull [] chooseRemoteFiles(@NotNull Project var1, @NotNull PyRemoteSdkAdditionalDataBase var2, boolean var3) throws ExecutionException, InterruptedException;

    public abstract void runVagrant(@NotNull String var1, @Nullable String var2) throws ExecutionException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exeGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PythonRemoteInterpreterManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PythonRemoteInterpreterManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "appendBasicMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addUnbuffered";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addHelpersMapping";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendBasicMappings";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PyHelpersNotReadyException
    extends RuntimeException {
        public PyHelpersNotReadyException(Throwable cause) {
            super("Python helpers are not copied yet to the remote host. Please wait until remote interpreter initialization finishes.", cause);
        }
    }
}

