/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.extractmethod;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractMethodDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodDecorator;
import com.intellij.refactoring.extractMethod.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.ExtractMethodSettings;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragment;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExtractMethodUtil {
    public static final String NAME = "extract.method.name";

    private PyExtractMethodUtil() {
    }

    public static void extractFromStatements(@NotNull Project project, @NotNull Editor editor2, @NotNull PyCodeFragment fragment, @NotNull PsiElement statement1, @NotNull PsiElement statement2) {
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(1);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(2);
        }
        if (statement1 == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(3);
        }
        if (statement2 == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(4);
        }
        if (!fragment.getOutputVariables().isEmpty() && fragment.isReturnInstructionInside()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyBundle.message("refactoring.extract.method.error.local.variable.modifications.and.returns", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)statement1, PyFunction.class);
        PyUtil.MethodFlags flags = function == null ? null : PyUtil.MethodFlags.of(function);
        boolean isClassMethod = flags != null && flags.isClassMethod();
        boolean isStaticMethod = flags != null && flags.isStaticMethod();
        List elementsRange = PsiTreeUtil.getElementsOfRange((PsiElement)statement1, (PsiElement)statement2);
        if (elementsRange.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyBundle.message("refactoring.extract.method.error.empty.fragment", new Object[0]), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
            return;
        }
        Pair<String, AbstractVariableData[]> data = PyExtractMethodUtil.getNameAndVariableData(project, fragment, statement1, isClassMethod, isStaticMethod);
        if (data.first == null || data.second == null) {
            return;
        }
        String methodName = (String)data.first;
        AbstractVariableData[] variableData = (AbstractVariableData[])data.second;
        SimpleDuplicatesFinder finder = new SimpleDuplicatesFinder(statement1, statement2, fragment.getOutputVariables(), variableData);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            RefactoringEventData beforeData = new RefactoringEventData();
            beforeData.addElements(new PsiElement[]{statement1, statement2});
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(PyExtractMethodUtil.getRefactoringId(), beforeData);
            StringBuilder builder = new StringBuilder();
            boolean isAsync = fragment.isAsync();
            if (isAsync) {
                builder.append("async ");
            }
            builder.append("def f():\n    ");
            ArrayList<PsiElement> newMethodElements = new ArrayList<PsiElement>(elementsRange);
            boolean hasOutputVariables = !fragment.getOutputVariables().isEmpty();
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            LanguageLevel languageLevel = LanguageLevel.forElement(statement1);
            if (hasOutputVariables) {
                String outputVariables = StringUtil.join((Collection)fragment.getOutputVariables(), (String)", ");
                String newMethodText = builder + "return " + outputVariables;
                builder.append(outputVariables);
                PyFunction function1 = generator.createFromText(languageLevel, PyFunction.class, newMethodText);
                PyStatement returnStatement = function1.getStatementList().getStatements()[0];
                newMethodElements.add((PsiElement)returnStatement);
            }
            PyFunction generatedMethod = PyExtractMethodUtil.generateMethodFromElements(methodName, variableData, newMethodElements, flags, isAsync);
            PyFunction insertedMethod = (PyFunction)WriteAction.compute(() -> PyExtractMethodUtil.insertGeneratedMethod(statement1, generatedMethod));
            PsiElement firstElement = (PsiElement)elementsRange.get(0);
            boolean isMethod = PyPsiUtils.isMethodContext(firstElement);
            WriteAction.run(() -> {
                PyExtractMethodUtil.processParameters(project, insertedMethod, variableData, isMethod, isClassMethod, isStaticMethod);
                PyExtractMethodUtil.processGlobalWrites(insertedMethod, fragment);
                PyExtractMethodUtil.processNonlocalWrites(insertedMethod, fragment);
            });
            if (hasOutputVariables) {
                builder.append(" = ");
            } else if (fragment.isReturnInstructionInside()) {
                builder.append("return ");
            }
            if (isAsync) {
                builder.append("await ");
            } else if (fragment.isYieldInside()) {
                builder.append("yield from ");
            }
            if (isMethod) {
                PyExtractMethodUtil.appendSelf(firstElement, builder, isStaticMethod);
            }
            builder.append(methodName).append("(");
            builder.append(PyExtractMethodUtil.createCallArgsString(variableData)).append(")");
            PyFunction function1 = generator.createFromText(languageLevel, PyFunction.class, builder.toString());
            PyStatement callElement = function1.getStatementList().getStatements()[0];
            PyPsiUtils.assertValid(statement1);
            PyPsiUtils.assertValid(statement2);
            List<SimpleMatch> duplicates = PyExtractMethodUtil.collectDuplicates(finder, statement1, insertedMethod);
            PsiElement insertedCallElement = (PsiElement)WriteAction.compute(() -> PyExtractMethodUtil.lambda$null$2(elementsRange, (PsiElement)callElement));
            insertedCallElement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)insertedCallElement);
            if (insertedCallElement != null) {
                PyExtractMethodUtil.processDuplicates(duplicates, insertedCallElement, editor2);
            }
            PyExtractMethodUtil.setSelectionAndCaret(editor2, insertedCallElement);
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement((PsiElement)insertedMethod);
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(PyExtractMethodUtil.getRefactoringId(), afterData);
        }, PyBundle.message("refactoring.extract.method", new Object[0]), null);
    }

    @NotNull
    private static List<SimpleMatch> collectDuplicates(@NotNull SimpleDuplicatesFinder finder, @NotNull PsiElement originalScopeAnchor, @NotNull PyFunction generatedMethod) {
        if (finder == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(5);
        }
        if (originalScopeAnchor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(6);
        }
        if (generatedMethod == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(7);
        }
        List<PsiElement> scopes = PyExtractMethodUtil.collectScopes(originalScopeAnchor, generatedMethod);
        List list = ExtractMethodHelper.collectDuplicates((SimpleDuplicatesFinder)finder, scopes, (PsiElement)generatedMethod);
        if (list == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> collectScopes(@NotNull PsiElement anchor, @NotNull PyFunction generatedMethod) {
        ScopeOwner owner;
        if (anchor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(9);
        }
        if (generatedMethod == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(10);
        }
        if ((owner = ScopeUtil.getScopeOwner(anchor)) instanceof PsiFile) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PyExtractMethodUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList<PsiElement> scope = new ArrayList<PsiElement>();
        if (owner instanceof PyFunction) {
            scope.add((PsiElement)owner);
            PyClass containingClass = ((PyFunction)owner).getContainingClass();
            if (containingClass != null) {
                for (PyFunction function : containingClass.getMethods()) {
                    if (function.equals(owner) || function.equals(generatedMethod)) continue;
                    scope.add(function);
                }
            }
        }
        ArrayList<PsiElement> arrayList = scope;
        if (arrayList == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static void processDuplicates(@NotNull List<SimpleMatch> duplicates, @NotNull PsiElement replacement, @NotNull Editor editor2) {
        if (duplicates == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(13);
        }
        if (replacement == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(14);
        }
        if (editor2 == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(15);
        }
        ExtractMethodHelper.replaceDuplicates((PsiElement)replacement, (Editor)editor2, pair -> PyExtractMethodUtil.replaceElements((SimpleMatch)pair.first, ((PsiElement)pair.second).copy()), duplicates);
    }

    private static void processGlobalWrites(@NotNull PyFunction function, @NotNull PyCodeFragment fragment) {
        if (function == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(16);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(17);
        }
        Set<String> globalWrites = fragment.getGlobalWrites();
        LinkedHashSet<String> newGlobalNames = new LinkedHashSet<String>();
        Scope scope = ControlFlowCache.getScope(function);
        for (String name : globalWrites) {
            if (scope.isGlobal(name)) continue;
            newGlobalNames.add(name);
        }
        if (!newGlobalNames.isEmpty()) {
            PyElementGenerator generator = PyElementGenerator.getInstance(function.getProject());
            PyGlobalStatement globalStatement = generator.createFromText(LanguageLevel.forElement(function), PyGlobalStatement.class, "global " + StringUtil.join(newGlobalNames, (String)", "));
            PyStatementList statementList = function.getStatementList();
            statementList.addBefore(globalStatement, statementList.getFirstChild());
        }
    }

    private static void processNonlocalWrites(@NotNull PyFunction function, @NotNull PyCodeFragment fragment) {
        if (function == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(18);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(19);
        }
        Set<String> nonlocalWrites = fragment.getNonlocalWrites();
        LinkedHashSet<String> newNonlocalNames = new LinkedHashSet<String>();
        Scope scope = ControlFlowCache.getScope(function);
        for (String name : nonlocalWrites) {
            if (scope.isNonlocal(name)) continue;
            newNonlocalNames.add(name);
        }
        if (!newNonlocalNames.isEmpty()) {
            PyElementGenerator generator = PyElementGenerator.getInstance(function.getProject());
            PyNonlocalStatement nonlocalStatement = generator.createFromText(LanguageLevel.forElement(function), PyNonlocalStatement.class, "nonlocal " + StringUtil.join(newNonlocalNames, (String)", "));
            PyStatementList statementList = function.getStatementList();
            statementList.addBefore((PsiElement)nonlocalStatement, statementList.getFirstChild());
        }
    }

    private static void appendSelf(@NotNull PsiElement firstElement, @NotNull StringBuilder builder, boolean staticMethod) {
        if (firstElement == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(20);
        }
        if (builder == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(21);
        }
        if (staticMethod) {
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)firstElement, PyClass.class);
            assert (containingClass != null);
            builder.append(containingClass.getName());
        } else {
            builder.append(PyUtil.getFirstParameterName((PyFunction)PsiTreeUtil.getParentOfType((PsiElement)firstElement, PyFunction.class)));
        }
        builder.append(".");
    }

    public static void extractFromExpression(@NotNull Project project, @NotNull Editor editor2, @NotNull PyCodeFragment fragment, @NotNull PsiElement expression) {
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(22);
        }
        if (editor2 == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(23);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(24);
        }
        if (expression == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(25);
        }
        if (!fragment.getOutputVariables().isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyBundle.message("refactoring.extract.method.error.local.variable.modifications", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return;
        }
        if (fragment.isReturnInstructionInside()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyBundle.message("refactoring.extract.method.error.returns", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, PyFunction.class);
        PyUtil.MethodFlags flags = function == null ? null : PyUtil.MethodFlags.of(function);
        boolean isClassMethod = flags != null && flags.isClassMethod();
        boolean isStaticMethod = flags != null && flags.isClassMethod();
        Pair<String, AbstractVariableData[]> data = PyExtractMethodUtil.getNameAndVariableData(project, fragment, expression, isClassMethod, isStaticMethod);
        if (data.first == null || data.second == null) {
            return;
        }
        String methodName = (String)data.first;
        AbstractVariableData[] variableData = (AbstractVariableData[])data.second;
        SimpleDuplicatesFinder finder = new SimpleDuplicatesFinder(expression, expression, fragment.getOutputVariables(), variableData);
        if (fragment.getOutputVariables().isEmpty()) {
            CommandProcessor.getInstance().executeCommand(project, () -> {
                boolean isAsync = fragment.isAsync();
                PyFunction generatedMethod = PyExtractMethodUtil.generateMethodFromExpression(methodName, variableData, expression, flags, isAsync);
                PyFunction insertedMethod = (PyFunction)WriteAction.compute(() -> PyExtractMethodUtil.insertGeneratedMethod(expression, generatedMethod));
                boolean isMethod = PyPsiUtils.isMethodContext(expression);
                WriteAction.run(() -> PyExtractMethodUtil.processParameters(project, insertedMethod, variableData, isMethod, isClassMethod, isStaticMethod));
                StringBuilder builder = new StringBuilder();
                if (isAsync) {
                    builder.append("async ");
                }
                builder.append("def f():\n    ");
                if (isAsync) {
                    builder.append("await ");
                } else if (fragment.isYieldInside()) {
                    builder.append("yield from ");
                } else {
                    builder.append("return ");
                }
                if (isMethod) {
                    PyExtractMethodUtil.appendSelf(expression, builder, isStaticMethod);
                }
                builder.append(methodName);
                builder.append("(").append(PyExtractMethodUtil.createCallArgsString(variableData)).append(")");
                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                PyFunction function1 = generator.createFromText(LanguageLevel.forElement(expression), PyFunction.class, builder.toString());
                PyStatement generated = function1.getStatementList().getStatements()[0];
                PyExpression callElement = generated instanceof PyReturnStatement ? ((PyReturnStatement)generated).getExpression() : (generated instanceof PyExpressionStatement ? ((PyExpressionStatement)generated).getExpression() : null);
                PyPsiUtils.assertValid(expression);
                List<SimpleMatch> duplicates = PyExtractMethodUtil.collectDuplicates(finder, expression, insertedMethod);
                PsiElement insertedCallElement = null;
                if (callElement != null && (insertedCallElement = (PsiElement)WriteAction.compute(() -> PyExtractMethodUtil.lambda$null$7(expression, (PsiElement)callElement))) != null) {
                    PyExtractMethodUtil.processDuplicates(duplicates, insertedCallElement, editor2);
                }
                PyExtractMethodUtil.setSelectionAndCaret(editor2, insertedCallElement);
            }, PyBundle.message("refactoring.extract.method", new Object[0]), null);
        }
    }

    private static void setSelectionAndCaret(@NotNull Editor editor2, @Nullable PsiElement callElement) {
        if (editor2 == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(26);
        }
        editor2.getSelectionModel().removeSelection();
        if (callElement != null) {
            int offset = callElement.getTextOffset();
            editor2.getCaretModel().moveToOffset(offset);
        }
    }

    @NotNull
    private static PsiElement replaceElements(@NotNull List<PsiElement> elementsRange, @NotNull PsiElement callElement) {
        if (elementsRange == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(27);
        }
        if (callElement == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(28);
        }
        callElement = elementsRange.get(0).replace(callElement);
        if (elementsRange.size() > 1) {
            callElement.getParent().deleteChildRange(elementsRange.get(1), elementsRange.get(elementsRange.size() - 1));
        }
        PsiElement psiElement = callElement;
        if (psiElement == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(29);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement replaceElements(@NotNull SimpleMatch match, @NotNull PsiElement element) {
        if (match == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(30);
        }
        if (element == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(31);
        }
        List elementsRange = PsiTreeUtil.getElementsOfRange((PsiElement)match.getStartElement(), (PsiElement)match.getEndElement());
        Map changedParameters = match.getChangedParameters();
        Object callElement = element;
        PyElementGenerator generator = PyElementGenerator.getInstance(callElement.getProject());
        if (element instanceof PyAssignmentStatement) {
            PyExpression[] targets;
            PyExpression value = ((PyAssignmentStatement)element).getAssignedValue();
            if (value != null) {
                callElement = value;
            }
            if ((targets = ((PyAssignmentStatement)element).getTargets()).length == 1) {
                String output = match.getChangedOutput();
                PyExpression text2 = generator.createFromText(LanguageLevel.forElement(callElement), PyAssignmentStatement.class, output + " = 1").getTargets()[0];
                targets[0].replace((PsiElement)text2);
            }
        }
        if (element instanceof PyExpressionStatement) {
            callElement = ((PyExpressionStatement)element).getExpression();
        }
        if (callElement instanceof PyCallExpression) {
            Set keys = changedParameters.keySet();
            PyArgumentList argumentList = ((PyCallExpression)callElement).getArgumentList();
            if (argumentList != null) {
                for (PyExpression arg : argumentList.getArguments()) {
                    String argText = arg.getText();
                    if (argText == null || !keys.contains(argText)) continue;
                    arg.replace((PsiElement)generator.createExpressionFromText(LanguageLevel.forElement(callElement), (String)changedParameters.get(argText)));
                }
            }
        }
        return PyExtractMethodUtil.replaceElements(elementsRange, element);
    }

    @NotNull
    private static String createCallArgsString(AbstractVariableData @NotNull [] variableDatas) {
        if (variableDatas == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(32);
        }
        String string = StringUtil.join((Collection)ContainerUtil.mapNotNull((Object[])variableDatas, data -> data.isPassAsParameter() ? data.getOriginalName() : null), (String)",");
        if (string == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static void processParameters(@NotNull Project project, @NotNull PyFunction generatedMethod, AbstractVariableData @NotNull [] variableData, boolean isMethod, boolean isClassMethod, boolean isStaticMethod) {
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(34);
        }
        if (generatedMethod == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(35);
        }
        if (variableData == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(36);
        }
        Map<String, String> map2 = PyExtractMethodUtil.createMap(variableData);
        for (PyParameter parameter : generatedMethod.getParameterList().getParameters()) {
            String name = parameter.getName();
            String newName = map2.get(name);
            if (name == null || newName == null || name.equals(newName)) continue;
            HashMap<PyParameter, String> allRenames = new HashMap<PyParameter, String>();
            allRenames.put(parameter, newName);
            UsageInfo[] usages = RenameUtil.findUsages((PsiElement)parameter, (String)newName, (boolean)false, (boolean)false, allRenames);
            try {
                RenameUtil.doRename((PsiElement)parameter, (String)newName, (UsageInfo[])usages, (Project)project, (RefactoringElementListener)new RefactoringElementListenerComposite());
            }
            catch (IncorrectOperationException e) {
                RenameUtil.showErrorMessage((IncorrectOperationException)e, (PsiElement)parameter, (Project)project);
                return;
            }
        }
        PyFunctionBuilder builder = new PyFunctionBuilder("foo", generatedMethod);
        if (isClassMethod) {
            builder.parameter("cls");
        } else if (isMethod && !isStaticMethod) {
            builder.parameter("self");
        }
        for (AbstractVariableData data : variableData) {
            if (!data.isPassAsParameter()) continue;
            builder.parameter(data.getName());
        }
        PyParameterList pyParameterList = builder.buildFunction().getParameterList();
        generatedMethod.getParameterList().replace((PsiElement)pyParameterList);
    }

    @NotNull
    private static Map<String, String> createMap(AbstractVariableData @NotNull [] variableData) {
        if (variableData == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(37);
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (AbstractVariableData data : variableData) {
            map2.put(data.getOriginalName(), data.getName());
        }
        HashMap<String, String> hashMap = map2;
        if (hashMap == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(38);
        }
        return hashMap;
    }

    @NotNull
    private static PyFunction insertGeneratedMethod(@NotNull PsiElement anchor, @NotNull PyFunction generatedMethod) {
        PsiElement result;
        PsiNamedElement parent;
        Pair data;
        if (anchor == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(39);
        }
        if (generatedMethod == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(40);
        }
        if ((data = (Pair)anchor.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE)) != null) {
            anchor = (PsiElement)data.first;
        }
        if ((parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{PyFile.class, PyClass.class, PyFunction.class})) instanceof PyFunction) {
            result = parent.getParent().addAfter((PsiElement)generatedMethod, (PsiElement)parent);
        } else {
            PsiNamedElement target = parent instanceof PyClass ? ((PyClass)parent).getStatementList() : parent;
            PsiElement insertionAnchor = PyPsiUtils.getParentRightBefore(anchor, (PsiElement)target);
            assert (insertionAnchor != null);
            List<PsiComment> comments = PyPsiUtils.getPrecedingComments(insertionAnchor);
            result = insertionAnchor.getParent().addBefore((PsiElement)generatedMethod, !comments.isEmpty() ? (PsiElement)comments.get(0) : insertionAnchor);
        }
        result.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                CodeEditUtil.setNodeGenerated((ASTNode)element.getNode(), (boolean)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$1", "visitElement"));
            }
        });
        PyFunction pyFunction = (PyFunction)result;
        if (pyFunction == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(41);
        }
        return pyFunction;
    }

    @NotNull
    private static PyFunction generateMethodFromExpression(@NotNull String methodName, AbstractVariableData @NotNull [] variableData, @NotNull PsiElement expression, @Nullable PyUtil.MethodFlags flags, boolean isAsync) {
        if (methodName == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(42);
        }
        if (expression == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(43);
        }
        if (variableData == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(44);
        }
        PyFunctionBuilder builder = new PyFunctionBuilder(methodName, expression);
        PyExtractMethodUtil.addDecorators(builder, flags);
        PyExtractMethodUtil.addFakeParameters(builder, variableData);
        if (isAsync) {
            builder.makeAsync();
        }
        String text2 = expression instanceof PyYieldExpression ? String.format("(%s)", expression.getText()) : expression.getText();
        builder.statement("return " + text2);
        PyFunction pyFunction = builder.buildFunction();
        if (pyFunction == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(45);
        }
        return pyFunction;
    }

    @NotNull
    private static PyFunction generateMethodFromElements(@NotNull String methodName, AbstractVariableData @NotNull [] variableData, @NotNull List<PsiElement> elementsRange, @Nullable PyUtil.MethodFlags flags, boolean isAsync) {
        if (methodName == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(46);
        }
        if (elementsRange == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(47);
        }
        if (variableData == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(48);
        }
        assert (!elementsRange.isEmpty()) : "Empty statements list was selected!";
        PyFunctionBuilder builder = new PyFunctionBuilder(methodName, elementsRange.get(0));
        if (isAsync) {
            builder.makeAsync();
        }
        PyExtractMethodUtil.addDecorators(builder, flags);
        PyExtractMethodUtil.addFakeParameters(builder, variableData);
        PyFunction method = builder.buildFunction();
        PyStatementList statementList = method.getStatementList();
        for (PsiElement element : elementsRange) {
            if (element instanceof PsiWhiteSpace) continue;
            statementList.add(element);
        }
        PsiElement child = statementList.getFirstChild();
        if (child != null) {
            child.delete();
        }
        PyStatementList last = statementList;
        while (last != null) {
            if (!((last = last.getLastChild()) instanceof PsiWhiteSpace)) continue;
            last.delete();
        }
        PyFunction pyFunction = method;
        if (pyFunction == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(49);
        }
        return pyFunction;
    }

    private static void addDecorators(@NotNull PyFunctionBuilder builder, @Nullable PyUtil.MethodFlags flags) {
        if (builder == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(50);
        }
        if (flags != null) {
            if (flags.isClassMethod()) {
                builder.decorate("classmethod");
            } else if (flags.isStaticMethod()) {
                builder.decorate("staticmethod");
            }
        }
    }

    private static void addFakeParameters(@NotNull PyFunctionBuilder builder, AbstractVariableData @NotNull [] variableData) {
        if (builder == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(51);
        }
        if (variableData == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(52);
        }
        for (AbstractVariableData data : variableData) {
            builder.parameter(data.getOriginalName());
        }
    }

    @NotNull
    private static Pair<String, AbstractVariableData[]> getNameAndVariableData(@NotNull Project project, @NotNull CodeFragment fragment, @NotNull PsiElement element, final boolean isClassMethod, final boolean isStaticMethod) {
        if (project == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(53);
        }
        if (fragment == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(54);
        }
        if (element == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(55);
        }
        PyExtractMethodValidator validator = new PyExtractMethodValidator(element, project);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String error;
            String name = System.getProperty(NAME);
            if (name == null) {
                name = "foo";
            }
            if ((error = validator.check(name)) != null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new CommonRefactoringUtil.RefactoringErrorHintException(error);
                }
                if (Messages.showOkCancelDialog((String)(error + ". " + RefactoringBundle.message((String)"do.you.wish.to.continue")), (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getWarningIcon()) != 0) {
                    throw new CommonRefactoringUtil.RefactoringErrorHintException(error);
                }
            }
            ArrayList<AbstractVariableData> data = new ArrayList<AbstractVariableData>();
            for (String in : fragment.getInputVariables()) {
                AbstractVariableData d = new AbstractVariableData();
                d.name = in + "_new";
                d.originalName = in;
                d.passAsParameter = true;
                data.add(d);
            }
            Pair pair = Pair.create((Object)name, (Object)data.toArray(new AbstractVariableData[0]));
            if (pair == null) {
                PyExtractMethodUtil.$$$reportNull$$$0(56);
            }
            return pair;
        }
        final boolean isMethod = PyPsiUtils.isMethodContext(element);
        ExtractMethodDecorator<Object> decorator = new ExtractMethodDecorator<Object>(){

            @NotNull
            public String createMethodSignature(@NotNull ExtractMethodSettings<Object> settings) {
                if (settings == null) {
                    2.$$$reportNull$$$0(0);
                }
                StringBuilder builder = new StringBuilder();
                if (isClassMethod) {
                    builder.append("cls");
                } else if (isMethod && !isStaticMethod) {
                    builder.append("self");
                }
                for (AbstractVariableData variableData : settings.getAbstractVariableData()) {
                    if (!variableData.passAsParameter) continue;
                    if (builder.length() != 0) {
                        builder.append(", ");
                    }
                    builder.append(variableData.name);
                }
                builder.insert(0, "(");
                builder.insert(0, settings.getMethodName());
                builder.insert(0, "def ");
                builder.append(")");
                String string = builder.toString();
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMethodSignature";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createMethodSignature";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        AbstractExtractMethodDialog<Object> dialog = new AbstractExtractMethodDialog<Object>(project, "method_name", fragment, ArrayUtilRt.EMPTY_OBJECT_ARRAY, (ExtractMethodValidator)validator, (ExtractMethodDecorator)decorator, (FileType)PythonFileType.INSTANCE){

            protected String getHelpId() {
                return "python.reference.extractMethod";
            }
        };
        dialog.show();
        if (!dialog.isOK()) {
            Pair pair = Pair.empty();
            if (pair == null) {
                PyExtractMethodUtil.$$$reportNull$$$0(57);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)dialog.getMethodName(), (Object)dialog.getAbstractVariableData());
        if (pair == null) {
            PyExtractMethodUtil.$$$reportNull$$$0(58);
        }
        return pair;
    }

    @NotNull
    public static String getRefactoringId() {
        return "refactoring.python.extract.method";
    }

    private static /* synthetic */ PsiElement lambda$null$7(PsiElement expression, PsiElement callElement) throws RuntimeException {
        return PyReplaceExpressionUtil.replaceExpression(expression, callElement);
    }

    private static /* synthetic */ PsiElement lambda$null$2(List elementsRange, PsiElement callElement) throws RuntimeException {
        return PyExtractMethodUtil.replaceElements(elementsRange, callElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 33: 
            case 38: 
            case 41: 
            case 45: 
            case 49: 
            case 56: 
            case 57: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 33: 
            case 38: 
            case 41: 
            case 45: 
            case 49: 
            case 56: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 15: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 17: 
            case 19: 
            case 24: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScopeAnchor";
                break;
            }
            case 7: 
            case 10: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMethod";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 33: 
            case 38: 
            case 41: 
            case 45: 
            case 49: 
            case 56: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil";
                break;
            }
            case 9: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
            case 21: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 25: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 27: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsRange";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 31: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDatas";
                break;
            }
            case 36: 
            case 37: 
            case 44: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableData";
                break;
            }
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDuplicates";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectScopes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceElements";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallArgsString";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "insertGeneratedMethod";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodFromExpression";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodFromElements";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameAndVariableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractFromStatements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectDuplicates";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 33: 
            case 38: 
            case 41: 
            case 45: 
            case 49: 
            case 56: 
            case 57: 
            case 58: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectScopes";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicates";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalWrites";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processNonlocalWrites";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "appendSelf";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "extractFromExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setSelectionAndCaret";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "replaceElements";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createCallArgsString";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processParameters";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createMap";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "insertGeneratedMethod";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodFromExpression";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodFromElements";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addDecorators";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addFakeParameters";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getNameAndVariableData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 33: 
            case 38: 
            case 41: 
            case 45: 
            case 49: 
            case 56: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PyExtractMethodValidator
    implements ExtractMethodValidator {
        private final PsiElement myElement;
        private final Project myProject;
        @Nullable
        private final Function<String, Boolean> myFunction;

        PyExtractMethodValidator(PsiElement element, Project project) {
            this.myElement = element;
            this.myProject = project;
            ScopeOwner parent = ScopeUtil.getScopeOwner(this.myElement);
            this.myFunction = s -> {
                ScopeOwner owner = parent;
                while (owner != null) {
                    if (owner instanceof PyClass && ((PyClass)owner).findMethodByName((String)s, true, null) != null) {
                        return false;
                    }
                    Scope scope = ControlFlowCache.getScope(owner);
                    if (scope.containsDeclaration((String)s)) {
                        return false;
                    }
                    owner = ScopeUtil.getScopeOwner((PsiElement)owner);
                }
                return true;
            };
        }

        @Nullable
        public String check(String name) {
            if (this.myFunction != null && !((Boolean)this.myFunction.fun((Object)name)).booleanValue()) {
                return PyBundle.message("refactoring.extract.method.error.name.clash", new Object[0]);
            }
            return null;
        }

        public boolean isValidName(@NotNull String name) {
            if (name == null) {
                PyExtractMethodValidator.$$$reportNull$$$0(0);
            }
            return LanguageNamesValidation.isIdentifier((Language)PythonLanguage.getInstance(), (String)name, (Project)this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$PyExtractMethodValidator", "isValidName"));
        }
    }
}

