/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyImplicitImportNameDefiner;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDefUseUtil {
    private PyDefUseUtil() {
    }

    @NotNull
    public static List<Instruction> getLatestDefs(ScopeOwner block, String varName, PsiElement anchor, boolean acceptTypeAssertions, boolean acceptImplicitImports) {
        return PyDefUseUtil.getLatestDefs(ControlFlowCache.getControlFlow(block), varName, anchor, acceptTypeAssertions, acceptImplicitImports);
    }

    @NotNull
    public static List<Instruction> getLatestDefs(ControlFlow controlFlow, String varName, PsiElement anchor, boolean acceptTypeAssertions, boolean acceptImplicitImports) {
        Collection pred;
        int instr;
        Instruction[] instructions = controlFlow.getInstructions();
        PyAugAssignmentStatement augAssignment = PyAugAssignmentStatementNavigator.getStatementByTarget(anchor);
        if (augAssignment != null) {
            anchor = augAssignment;
        }
        if ((instr = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)anchor)) < 0) {
            List<Instruction> list = Collections.emptyList();
            if (list == null) {
                PyDefUseUtil.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (anchor instanceof PyTargetExpression && !(pred = instructions[instr].allPred()).isEmpty()) {
            instr = ((Instruction)pred.iterator().next()).num();
        }
        Collection<Instruction> result = PyDefUseUtil.getLatestDefs(varName, instructions, instr, acceptTypeAssertions, acceptImplicitImports);
        return new ArrayList<Instruction>(result);
    }

    private static Collection<Instruction> getLatestDefs(String varName, Instruction[] instructions, int instr, boolean acceptTypeAssertions, boolean acceptImplicitImports) {
        LinkedHashSet<Instruction> result = new LinkedHashSet<Instruction>();
        ControlFlowUtil.iteratePrev((int)instr, (Instruction[])instructions, instruction -> {
            PsiElement element = instruction.getElement();
            PyImplicitImportNameDefiner implicit = PyUtil.as(element, PyImplicitImportNameDefiner.class);
            if (instruction instanceof ReadWriteInstruction) {
                String name;
                ReadWriteInstruction rwInstruction = (ReadWriteInstruction)((Object)instruction);
                ReadWriteInstruction.ACCESS access = rwInstruction.getAccess();
                if ((access.isWriteAccess() || acceptTypeAssertions && access.isAssertTypeAccess()) && Comparing.strEqual((String)(name = PyDefUseUtil.elementName(element)), (String)varName)) {
                    result.add((Instruction)rwInstruction);
                    return ControlFlowUtil.Operation.CONTINUE;
                }
            } else if (acceptImplicitImports && implicit != null && !implicit.multiResolveName(varName).isEmpty()) {
                result.add((Instruction)instruction);
                return ControlFlowUtil.Operation.CONTINUE;
            }
            return ControlFlowUtil.Operation.NEXT;
        });
        return result;
    }

    @Nullable
    private static String elementName(PsiElement element) {
        QualifiedName qname;
        if (element instanceof PyImportElement) {
            return ((PyImportElement)element).getVisibleName();
        }
        if ((element instanceof PyReferenceExpression || element instanceof PyTargetExpression) && (qname = ((PyQualifiedExpression)element).asQualifiedName()) != null) {
            return qname.toString();
        }
        return element instanceof PyElement ? ((PyElement)element).getName() : null;
    }

    public static PsiElement @NotNull [] getPostRefs(ScopeOwner block, PyTargetExpression var, PyExpression anchor) {
        ControlFlow controlFlow = ControlFlowCache.getControlFlow(block);
        Instruction[] instructions = controlFlow.getInstructions();
        int instr = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)anchor);
        if (instr < 0) {
            if (PyElement.EMPTY_ARRAY == null) {
                PyDefUseUtil.$$$reportNull$$$0(1);
            }
            return PyElement.EMPTY_ARRAY;
        }
        boolean[] visited = new boolean[instructions.length];
        HashSet result = Sets.newHashSet();
        for (Instruction instruction : instructions[instr].allSucc()) {
            PyDefUseUtil.getPostRefs(var, instructions, instruction.num(), visited, result);
        }
        PsiElement[] psiElementArray = (PsiElement[])result.toArray(PyElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            PyDefUseUtil.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    private static void getPostRefs(PyTargetExpression var, Instruction[] instructions, int instr, boolean[] visited, Collection<PyElement> result) {
        ReadWriteInstruction instruction;
        PsiElement element;
        String name;
        if (visited[instr]) {
            return;
        }
        visited[instr] = true;
        if (instructions[instr] instanceof ReadWriteInstruction && Comparing.strEqual((String)(name = PyDefUseUtil.elementName(element = (instruction = (ReadWriteInstruction)instructions[instr]).getElement())), (String)var.getName())) {
            ReadWriteInstruction.ACCESS access = instruction.getAccess();
            if (access.isWriteAccess()) {
                return;
            }
            result.add((PyElement)instruction.getElement());
        }
        for (Instruction instruction2 : instructions[instr].allSucc()) {
            PyDefUseUtil.getPostRefs(var, instructions, instruction2.num(), visited, result);
        }
    }

    public static boolean isDefinedBefore(@NotNull PsiElement searched, @NotNull PsiElement target) {
        Instruction[] instructions;
        int index;
        if (searched == null) {
            PyDefUseUtil.$$$reportNull$$$0(3);
        }
        if (target == null) {
            PyDefUseUtil.$$$reportNull$$$0(4);
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(searched);
        Ref definedBefore = Ref.create((Object)false);
        if (scopeOwner != null && scopeOwner == ScopeUtil.getScopeOwner(target) && (index = ControlFlowUtil.findInstructionNumberByElement((Instruction[])(instructions = ControlFlowCache.getControlFlow(scopeOwner).getInstructions()), (PsiElement)target)) >= 0) {
            ControlFlowUtil.iteratePrev((int)index, (Instruction[])instructions, instruction -> {
                if (instruction.getElement() == searched) {
                    boolean isWriteAccess;
                    boolean isImport = searched instanceof PyImportedNameDefiner;
                    boolean bl = isWriteAccess = instruction instanceof ReadWriteInstruction && ((ReadWriteInstruction)((Object)instruction)).getAccess().isWriteAccess();
                    if (isImport || isWriteAccess) {
                        definedBefore.set((Object)true);
                        return ControlFlowUtil.Operation.BREAK;
                    }
                }
                return ControlFlowUtil.Operation.NEXT;
            });
        }
        return (Boolean)definedBefore.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/PyDefUseUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searched";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDefs";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostRefs";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/PyDefUseUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDefinedBefore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InstructionNotFoundException
    extends RuntimeException {
    }
}

