/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PyResolveContext {
    private final boolean myAllowImplicits;
    private final boolean myAllowProperties;
    private final boolean myAllowRemote;
    private final TypeEvalContext myTypeEvalContext;
    private static final PyResolveContext ourDefaultContext = new PyResolveContext(false, true);
    private static final PyResolveContext ourImplicitsContext = new PyResolveContext(true, true);
    private static final PyResolveContext ourNoPropertiesContext = new PyResolveContext(false, false);

    private PyResolveContext(boolean allowImplicits, boolean allowProperties) {
        this.myAllowImplicits = allowImplicits;
        this.myAllowProperties = allowProperties;
        this.myTypeEvalContext = null;
        this.myAllowRemote = false;
    }

    private PyResolveContext(boolean allowImplicits, boolean allowProperties, boolean allowRemote, TypeEvalContext typeEvalContext) {
        this.myAllowImplicits = allowImplicits;
        this.myAllowProperties = allowProperties;
        this.myAllowRemote = allowRemote;
        this.myTypeEvalContext = typeEvalContext;
    }

    public boolean allowImplicits() {
        return this.myAllowImplicits;
    }

    public boolean allowProperties() {
        return this.myAllowProperties;
    }

    public boolean allowRemote() {
        return this.myAllowRemote;
    }

    public static PyResolveContext defaultContext() {
        return ourDefaultContext;
    }

    @NotNull
    public static PyResolveContext implicitContext() {
        PyResolveContext pyResolveContext = ourImplicitsContext;
        if (pyResolveContext == null) {
            PyResolveContext.$$$reportNull$$$0(0);
        }
        return pyResolveContext;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static PyResolveContext noImplicits() {
        return PyResolveContext.defaultContext();
    }

    public static PyResolveContext noProperties() {
        return ourNoPropertiesContext;
    }

    public PyResolveContext withTypeEvalContext(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyResolveContext.$$$reportNull$$$0(1);
        }
        return new PyResolveContext(this.myAllowImplicits, this.myAllowProperties, this.myAllowRemote, context);
    }

    public PyResolveContext withoutImplicits() {
        return new PyResolveContext(false, this.myAllowProperties, this.myAllowRemote, this.myTypeEvalContext);
    }

    public PyResolveContext withRemote() {
        return new PyResolveContext(this.myAllowImplicits, this.myAllowProperties, true, this.myTypeEvalContext);
    }

    public TypeEvalContext getTypeEvalContext() {
        return this.myTypeEvalContext != null ? this.myTypeEvalContext : TypeEvalContext.codeInsightFallback(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyResolveContext that = (PyResolveContext)o;
        if (this.myAllowImplicits != that.myAllowImplicits) {
            return false;
        }
        return !(this.myTypeEvalContext != null ? !this.myTypeEvalContext.equals(that.myTypeEvalContext) : that.myTypeEvalContext != null);
    }

    public int hashCode() {
        int result = this.myAllowImplicits ? 1 : 0;
        result = 31 * result + (this.myTypeEvalContext != null ? this.myTypeEvalContext.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/PyResolveContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "implicitContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/PyResolveContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withTypeEvalContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

