/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing.console;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.PyParser;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.parsing.console.PyConsoleParsingContext;
import com.jetbrains.python.parsing.console.PyConsoleTokenTypes;
import com.jetbrains.python.parsing.console.PythonConsoleData;
import com.jetbrains.python.psi.LanguageLevel;

public class PyConsoleParser
extends PyParser {
    private static final ImmutableSet<IElementType> IPYTHON_START_SYMBOLS = new ImmutableSet.Builder().add((Object[])new IElementType[]{PyConsoleTokenTypes.PLING, PyConsoleTokenTypes.QUESTION_MARK, PyTokenTypes.COMMA, PyTokenTypes.DIV, PyTokenTypes.PERC, PyTokenTypes.SEMICOLON}).build();
    private final PythonConsoleData myPythonConsoleData;

    public PyConsoleParser(PythonConsoleData pythonConsoleData, LanguageLevel languageLevel) {
        this.myPythonConsoleData = pythonConsoleData;
        this.myLanguageLevel = languageLevel;
    }

    public static boolean startsWithIPythonSpecialSymbol(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        return IPYTHON_START_SYMBOLS.contains((Object)tokenType);
    }

    @Override
    protected ParsingContext createParsingContext(PsiBuilder builder, LanguageLevel languageLevel, StatementParsing.FUTURE futureFlag) {
        boolean iPythonStartSymbol = this.myPythonConsoleData.isIPythonEnabled() && PyConsoleParser.startsWithIPythonSpecialSymbol(builder);
        return new PyConsoleParsingContext(builder, languageLevel, futureFlag, this.myPythonConsoleData, iPythonStartSymbol);
    }
}

