/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementImpl;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRequirementParser {
    @NotNull
    private static final String LINE_WS_REGEXP = "[ \t]";
    @NotNull
    private static final String COMMENT_GROUP = "comment";
    @NotNull
    private static final String COMMENT_REGEXP = "(?<comment>[ \t]+#.*)?";
    @NotNull
    private static final String NAME_GROUP = "name";
    @NotNull
    private static final String IDENTIFIER_REGEXP = "[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*";
    @NotNull
    private static final String NAME_REGEXP = "(?<name>[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)";
    @NotNull
    private static final String EXTRAS_REGEXP = "\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\]";
    @NotNull
    private static final Pattern GITHUB_ARCHIVE_URL = Pattern.compile("https?://github\\.com/[^/\\s]+/(?<name>[^/\\s]+)/archive/\\S+(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final Pattern GITLAB_ARCHIVE_URL = Pattern.compile("https?://gitlab\\.com/[^/\\s]+/(?<name>[^/\\s]+)/repository/\\S+(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final Pattern ARCHIVE_URL = Pattern.compile("https?://\\S+/(?<name>\\S+)(\\.tar\\.gz|\\.zip)(#(sha1|sha224|sha256|sha384|sha512|md5)=\\w+)?(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final String VCS_EDITABLE_GROUP = "editable";
    @NotNull
    private static final String VCS_EDITABLE_REGEXP = "((?<editable>-e|--editable)[ \t]+)?";
    @NotNull
    private static final String VCS_SRC_BEFORE_GROUP = "srcb";
    @NotNull
    private static final String VCS_SRC_AFTER_GROUP = "srca";
    @NotNull
    private static final String VCS_SRC_BEFORE_REGEXP = "(?<srcb>--src[ \t]+\\S+[ \t]+)?";
    @NotNull
    private static final String VCS_SRC_AFTER_REGEXP = "(?<srca>[ \t]+--src[ \t]+\\S+)?";
    @NotNull
    private static final String PATH_IN_VCS_GROUP = "path";
    @NotNull
    private static final String PATH_IN_VCS_REGEXP = "(?<path>[^@#\\s]+)";
    @NotNull
    private static final String VCS_REVISION_REGEXP = "(@[^#\\s]+)?";
    @NotNull
    private static final String VCS_EGG_BEFORE_SUBDIR_GROUP = "eggb";
    @NotNull
    private static final String VCS_EGG_AFTER_SUBDIR_GROUP = "egga";
    @NotNull
    private static final String VCS_EXTRAS_BEFORE_SUBDIR_GROUP = "extrasb";
    @NotNull
    private static final String VCS_EXTRAS_AFTER_SUBDIR_GROUP = "extrasa";
    @NotNull
    private static final String VCS_PARAMS_REGEXP = "((#egg=(?<eggb>[^&\\s\\[\\]]+)(?<extrasb>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?(&subdirectory=\\S+)?)|(#subdirectory=[^&\\s]+&egg=(?<egga>[^\\s\\[\\]]+)(?<extrasa>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?))?";
    @NotNull
    private static final String VCS_GROUP = "vcs";
    @NotNull
    private static final String VCS_URL_PREFIX = "(?<srcb>--src[ \t]+\\S+[ \t]+)?((?<editable>-e|--editable)[ \t]+)?(?<vcs>";
    @NotNull
    private static final String VCS_URL_SUFFIX = "(?<path>[^@#\\s]+)(@[^#\\s]+)?((#egg=(?<eggb>[^&\\s\\[\\]]+)(?<extrasb>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?(&subdirectory=\\S+)?)|(#subdirectory=[^&\\s]+&egg=(?<egga>[^\\s\\[\\]]+)(?<extrasa>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?))?)(?<srca>[ \t]+--src[ \t]+\\S+)?(?<comment>[ \t]+#.*)?";
    @NotNull
    private static final String GIT_USER_AT_REGEXP = "[\\w-]+@";
    @NotNull
    private static final Pattern GIT_PROJECT_URL = Pattern.compile("(?<srcb>--src[ \t]+\\S+[ \t]+)?((?<editable>-e|--editable)[ \t]+)?(?<vcs>git\\+[\\w-]+@[^:\\s]+:(?<path>[^@#\\s]+)(@[^#\\s]+)?((#egg=(?<eggb>[^&\\s\\[\\]]+)(?<extrasb>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?(&subdirectory=\\S+)?)|(#subdirectory=[^&\\s]+&egg=(?<egga>[^\\s\\[\\]]+)(?<extrasa>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?))?)(?<srca>[ \t]+--src[ \t]+\\S+)?(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final Pattern BZR_PROJECT_URL = Pattern.compile("(?<srcb>--src[ \t]+\\S+[ \t]+)?((?<editable>-e|--editable)[ \t]+)?(?<vcs>bzr\\+lp:(?<path>[^@#\\s]+)(@[^#\\s]+)?((#egg=(?<eggb>[^&\\s\\[\\]]+)(?<extrasb>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?(&subdirectory=\\S+)?)|(#subdirectory=[^&\\s]+&egg=(?<egga>[^\\s\\[\\]]+)(?<extrasa>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?))?)(?<srca>[ \t]+--src[ \t]+\\S+)?(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final Pattern VCS_PROJECT_URL = Pattern.compile("(?<srcb>--src[ \t]+\\S+[ \t]+)?((?<editable>-e|--editable)[ \t]+)?(?<vcs>(bzr|git|hg|svn)(\\+[A-Za-z]+)?://?[^/]+/(?<path>[^@#\\s]+)(@[^#\\s]+)?((#egg=(?<eggb>[^&\\s\\[\\]]+)(?<extrasb>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?(&subdirectory=\\S+)?)|(#subdirectory=[^&\\s]+&egg=(?<egga>[^\\s\\[\\]]+)(?<extrasa>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?))?)(?<srca>[ \t]+--src[ \t]+\\S+)?(?<comment>[ \t]+#.*)?");
    @NotNull
    private static final String REQUIREMENT_EXTRAS_GROUP = "extras";
    @NotNull
    private static final String REQUIREMENT_EXTRAS_REGEXP = "(?<extras>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?";
    @NotNull
    private static final String REQUIREMENT_VERSIONS_SPECS_GROUP = "versionspecs";
    @NotNull
    private static final String REQUIREMENT_VERSION_SPEC_REGEXP = "(<=?|!=|===?|>=?|~=)[ \t]*[\\.\\*\\+!\\w-]+";
    @NotNull
    private static final String REQUIREMENT_VERSIONS_SPECS_REGEXP = "(?<versionspecs>(<=?|!=|===?|>=?|~=)[ \t]*[\\.\\*\\+!\\w-]+([ \t]*,[ \t]*(<=?|!=|===?|>=?|~=)[ \t]*[\\.\\*\\+!\\w-]+)*)?";
    @NotNull
    private static final String REQUIREMENT_OPTIONS_GROUP = "options";
    @NotNull
    private static final String REQUIREMENT_OPTIONS_REGEXP = "(?<options>([ \t]+(--global-option|--install-option)=\"[^\"]*\")+)?";
    @NotNull
    private static final String REQUIREMENT_GROUP = "requirement";
    @NotNull
    private static final Pattern REQUIREMENT = Pattern.compile("(?<requirement>(?<name>[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)[ \t]*(?<extras>\\[[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*([ \t]*,[ \t]*[A-Za-z0-9]([-_\\.]?[A-Za-z0-9])*)*\\])?[ \t]*(?<versionspecs>(<=?|!=|===?|>=?|~=)[ \t]*[\\.\\*\\+!\\w-]+([ \t]*,[ \t]*(<=?|!=|===?|>=?|~=)[ \t]*[\\.\\*\\+!\\w-]+)*)?)(?<options>([ \t]+(--global-option|--install-option)=\"[^\"]*\")+)?(?<comment>[ \t]+#.*)?");

    @Nullable
    public static PyRequirement fromLine(@NotNull String line2) {
        PyRequirement githubArchiveUrl;
        if (line2 == null) {
            PyRequirementParser.$$$reportNull$$$0(0);
        }
        if ((githubArchiveUrl = PyRequirementParser.parseGitArchiveUrl(GITHUB_ARCHIVE_URL, line2)) != null) {
            return githubArchiveUrl;
        }
        PyRequirement gitlabArchiveUrl = PyRequirementParser.parseGitArchiveUrl(GITLAB_ARCHIVE_URL, line2);
        if (gitlabArchiveUrl != null) {
            return gitlabArchiveUrl;
        }
        PyRequirement archiveUrl = PyRequirementParser.parseArchiveUrl(line2);
        if (archiveUrl != null) {
            return archiveUrl;
        }
        PyRequirement vcsProjectUrl = PyRequirementParser.parseVcsProjectUrl(line2);
        if (vcsProjectUrl != null) {
            return vcsProjectUrl;
        }
        return PyRequirementParser.parseRequirement(line2);
    }

    @NotNull
    public static List<PyRequirement> fromText(@NotNull String text2) {
        if (text2 == null) {
            PyRequirementParser.$$$reportNull$$$0(1);
        }
        return PyRequirementParser.fromText(text2, null, new HashSet<VirtualFile>());
    }

    @NotNull
    public static List<PyRequirement> fromFile(@NotNull VirtualFile file) {
        if (file == null) {
            PyRequirementParser.$$$reportNull$$$0(2);
        }
        return PyRequirementParser.fromText(PyRequirementParser.loadText(file), file, new HashSet<VirtualFile>());
    }

    @Nullable
    private static PyRequirement parseGitArchiveUrl(@NotNull Pattern pattern, @NotNull String line2) {
        Matcher matcher;
        if (pattern == null) {
            PyRequirementParser.$$$reportNull$$$0(3);
        }
        if (line2 == null) {
            PyRequirementParser.$$$reportNull$$$0(4);
        }
        if ((matcher = pattern.matcher(line2)).matches()) {
            return new PyRequirementImpl(matcher.group(NAME_GROUP), Collections.emptyList(), Collections.singletonList(PyRequirementParser.dropComments(line2, matcher)), "");
        }
        return null;
    }

    @Nullable
    private static PyRequirement parseArchiveUrl(@NotNull String line2) {
        Matcher matcher;
        if (line2 == null) {
            PyRequirementParser.$$$reportNull$$$0(5);
        }
        if ((matcher = ARCHIVE_URL.matcher(line2)).matches()) {
            return PyRequirementParser.createVcsOrArchiveRequirement(PyRequirementParser.parseNameAndVersionFromVcsOrArchive(matcher.group(NAME_GROUP)), Collections.singletonList(PyRequirementParser.dropComments(line2, matcher)), null);
        }
        return null;
    }

    @Nullable
    private static PyRequirement parseVcsProjectUrl(@NotNull String line2) {
        Matcher vcsMatcher;
        if (line2 == null) {
            PyRequirementParser.$$$reportNull$$$0(6);
        }
        if ((vcsMatcher = VCS_PROJECT_URL.matcher(line2)).matches()) {
            return PyRequirementParser.createVcsRequirement(vcsMatcher);
        }
        Matcher gitMatcher = GIT_PROJECT_URL.matcher(line2);
        if (gitMatcher.matches()) {
            return PyRequirementParser.createVcsRequirement(gitMatcher);
        }
        Matcher bzrMatcher = BZR_PROJECT_URL.matcher(line2);
        if (bzrMatcher.matches()) {
            return PyRequirementParser.createVcsRequirement(bzrMatcher);
        }
        return null;
    }

    @Nullable
    private static PyRequirement parseRequirement(@NotNull String line2) {
        Matcher matcher;
        if (line2 == null) {
            PyRequirementParser.$$$reportNull$$$0(7);
        }
        if ((matcher = REQUIREMENT.matcher(line2)).matches()) {
            String name = matcher.group(NAME_GROUP);
            List<PyRequirementVersionSpec> versionSpecs = PyRequirementParser.parseVersionSpecs(matcher.group(REQUIREMENT_VERSIONS_SPECS_GROUP));
            List<String> installOptions = PyRequirementParser.calculateRequirementInstallOptions(matcher);
            String extras = matcher.group(REQUIREMENT_EXTRAS_GROUP);
            if (extras == null) {
                return new PyRequirementImpl(name, versionSpecs, installOptions, "");
            }
            return new PyRequirementImpl(name, versionSpecs, installOptions, extras);
        }
        return null;
    }

    @NotNull
    static List<PyRequirement> fromText(@NotNull String text2, @Nullable VirtualFile containingFile, @NotNull Set<VirtualFile> visitedFiles) {
        if (text2 == null) {
            PyRequirementParser.$$$reportNull$$$0(8);
        }
        if (visitedFiles == null) {
            PyRequirementParser.$$$reportNull$$$0(9);
        }
        if (containingFile != null) {
            visitedFiles.add(containingFile);
        }
        List list = ((StreamEx)StreamEx.of(PyRequirementParser.splitByLinesAndCollapse(text2)).flatCollection(line2 -> PyRequirementParser.parseLine(line2, containingFile, visitedFiles)).nonNull().distinct()).toList();
        if (list == null) {
            PyRequirementParser.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static String loadText(@NotNull VirtualFile file) {
        Document document;
        if (file == null) {
            PyRequirementParser.$$$reportNull$$$0(11);
        }
        String string = (document = FileDocumentManager.getInstance().getDocument(file)) == null ? "" : document.getText();
        if (string == null) {
            PyRequirementParser.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String dropComments(@NotNull String line2, @NotNull Matcher matcher) {
        int commentIndex;
        if (line2 == null) {
            PyRequirementParser.$$$reportNull$$$0(13);
        }
        if (matcher == null) {
            PyRequirementParser.$$$reportNull$$$0(14);
        }
        if ((commentIndex = matcher.start(COMMENT_GROUP)) == -1) {
            String string = line2;
            if (string == null) {
                PyRequirementParser.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = line2.substring(0, PyRequirementParser.findFirstNotWhiteSpaceBefore(line2, commentIndex) + 1);
        if (string == null) {
            PyRequirementParser.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static Pair<String, String> parseNameAndVersionFromVcsOrArchive(@NotNull String name) {
        if (name == null) {
            PyRequirementParser.$$$reportNull$$$0(17);
        }
        boolean isName = true;
        ArrayList<String> nameParts = new ArrayList<String>();
        ArrayList<String> versionParts = new ArrayList<String>();
        for (String part : StringUtil.split((String)name, (String)"-")) {
            boolean partStartsWithDigit;
            boolean bl = partStartsWithDigit = !part.isEmpty() && Character.isDigit(part.charAt(0));
            if (partStartsWithDigit || "dev".equals(part)) {
                isName = false;
            }
            if (isName) {
                nameParts.add(part);
                continue;
            }
            versionParts.add(part);
        }
        Pair pair = Pair.create((Object)PyRequirementParser.normalizeVcsOrArchiveNameParts(nameParts), (Object)PyRequirementParser.normalizeVcsOrArchiveVersionParts(versionParts));
        if (pair == null) {
            PyRequirementParser.$$$reportNull$$$0(18);
        }
        return pair;
    }

    @NotNull
    private static PyRequirement createVcsOrArchiveRequirement(@NotNull Pair<String, String> nameAndVersion, @NotNull List<String> installOptions, @Nullable String extras) {
        if (nameAndVersion == null) {
            PyRequirementParser.$$$reportNull$$$0(19);
        }
        if (installOptions == null) {
            PyRequirementParser.$$$reportNull$$$0(20);
        }
        String name = (String)nameAndVersion.getFirst();
        String version = (String)nameAndVersion.getSecond();
        if (version == null) {
            if (extras == null) {
                return new PyRequirementImpl(name, Collections.emptyList(), installOptions, "");
            }
            return new PyRequirementImpl(name, Collections.emptyList(), installOptions, extras);
        }
        List<PyRequirementVersionSpec> versionSpecs = Collections.singletonList(PyRequirementsKt.pyRequirementVersionSpec(PyRequirementRelation.EQ, version));
        if (extras == null) {
            return new PyRequirementImpl(name, versionSpecs, installOptions, "");
        }
        return new PyRequirementImpl(name, versionSpecs, installOptions, extras);
    }

    @NotNull
    private static PyRequirement createVcsRequirement(@NotNull Matcher matcher) {
        if (matcher == null) {
            PyRequirementParser.$$$reportNull$$$0(21);
        }
        String path = matcher.group(PATH_IN_VCS_GROUP);
        String egg = PyRequirementParser.getEgg(matcher);
        String project = PyRequirementParser.extractProject(PyRequirementParser.dropTrunk(PyRequirementParser.dropRevision(path)));
        Pair<String, String> nameAndVersion = PyRequirementParser.parseNameAndVersionFromVcsOrArchive(egg == null ? StringUtil.trimEnd((String)project, (String)".git") : egg);
        return PyRequirementParser.createVcsOrArchiveRequirement(nameAndVersion, PyRequirementParser.calculateVcsInstallOptions(matcher), PyRequirementParser.getVcsExtras(matcher));
    }

    @NotNull
    private static List<PyRequirementVersionSpec> parseVersionSpecs(@Nullable String versionSpecs) {
        if (versionSpecs == null) {
            List<PyRequirementVersionSpec> list = Collections.emptyList();
            if (list == null) {
                PyRequirementParser.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<PyRequirementVersionSpec> list = StreamSupport.stream(StringUtil.tokenize((String)versionSpecs, (String)",").spliterator(), false).map(String::trim).map(PyRequirementParser::parseVersionSpec).filter(req -> req != null).collect(Collectors.toList());
        if (list == null) {
            PyRequirementParser.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    private static List<String> calculateRequirementInstallOptions(@NotNull Matcher matcher) {
        if (matcher == null) {
            PyRequirementParser.$$$reportNull$$$0(24);
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(matcher.group(REQUIREMENT_GROUP));
        String requirementOptions = matcher.group(REQUIREMENT_OPTIONS_GROUP);
        if (requirementOptions != null) {
            Arrays.stream(requirementOptions.split(" ")).map(String::trim).filter(s -> !s.isEmpty()).forEach(result::add);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            PyRequirementParser.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> splitByLinesAndCollapse(@NotNull String text2) {
        if (text2 == null) {
            PyRequirementParser.$$$reportNull$$$0(26);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String line2 : StringUtil.splitByLines((String)text2)) {
            if (line2.endsWith("\\") && !line2.endsWith("\\\\")) {
                sb.append(line2, 0, line2.length() - 1);
                continue;
            }
            if (sb.length() == 0) {
                result.add(line2);
                continue;
            }
            sb.append(line2);
            result.add(sb.toString());
            sb.setLength(0);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            PyRequirementParser.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    private static List<PyRequirement> parseLine(@NotNull String line2, @Nullable VirtualFile containingFile, @NotNull Set<VirtualFile> visitedFiles) {
        if (line2 == null) {
            PyRequirementParser.$$$reportNull$$$0(28);
        }
        if (visitedFiles == null) {
            PyRequirementParser.$$$reportNull$$$0(29);
        }
        if (line2.startsWith("-r")) {
            return PyRequirementParser.parseRecursiveLine(line2, containingFile, visitedFiles, "-r".length());
        }
        if (line2.startsWith("--requirement ")) {
            return PyRequirementParser.parseRecursiveLine(line2, containingFile, visitedFiles, "--requirement ".length());
        }
        List<PyRequirement> list = Collections.singletonList(PyRequirementParser.fromLine(line2));
        if (list == null) {
            PyRequirementParser.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    private static String normalizeVcsOrArchiveNameParts(@NotNull List<String> nameParts) {
        if (nameParts == null) {
            PyRequirementParser.$$$reportNull$$$0(31);
        }
        return PyRequirementParser.normalizeName(StringUtil.join(nameParts, (String)"-"));
    }

    @Nullable
    private static String normalizeVcsOrArchiveVersionParts(@NotNull List<String> versionParts) {
        if (versionParts == null) {
            PyRequirementParser.$$$reportNull$$$0(32);
        }
        return versionParts.isEmpty() ? null : PyRequirementParser.normalizeVersion(StringUtil.join(versionParts, (String)"-"));
    }

    @NotNull
    private static List<String> calculateVcsInstallOptions(@NotNull Matcher matcher) {
        String editable;
        if (matcher == null) {
            PyRequirementParser.$$$reportNull$$$0(33);
        }
        ArrayList<String> result = new ArrayList<String>();
        String srcBefore = matcher.group(VCS_SRC_BEFORE_GROUP);
        if (srcBefore != null) {
            result.addAll(Arrays.asList(srcBefore.split("\\s+")));
        }
        if ((editable = matcher.group(VCS_EDITABLE_GROUP)) != null) {
            result.add(editable);
        }
        result.add(matcher.group(VCS_GROUP));
        String srcAfter = matcher.group(VCS_SRC_AFTER_GROUP);
        if (srcAfter != null) {
            result.addAll(Arrays.asList(srcAfter.split("\\s+")).subList(1, 3));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            PyRequirementParser.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @Nullable
    private static String getEgg(@NotNull Matcher matcher) {
        String beforeSubdir;
        if (matcher == null) {
            PyRequirementParser.$$$reportNull$$$0(35);
        }
        return (beforeSubdir = matcher.group(VCS_EGG_BEFORE_SUBDIR_GROUP)) == null ? matcher.group(VCS_EGG_AFTER_SUBDIR_GROUP) : beforeSubdir;
    }

    @NotNull
    private static String extractProject(@NotNull String path) {
        int end;
        int slashIndex;
        if (path == null) {
            PyRequirementParser.$$$reportNull$$$0(36);
        }
        if ((slashIndex = path.lastIndexOf("/", (end = path.endsWith("/") ? path.length() - 1 : path.length()) - 1)) != -1) {
            String string = path.substring(slashIndex + 1, end);
            if (string == null) {
                PyRequirementParser.$$$reportNull$$$0(37);
            }
            return string;
        }
        if (end != path.length()) {
            String string = path.substring(0, end);
            if (string == null) {
                PyRequirementParser.$$$reportNull$$$0(38);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            PyRequirementParser.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    private static String dropTrunk(@NotNull String path) {
        if (path == null) {
            PyRequirementParser.$$$reportNull$$$0(40);
        }
        String slashTrunk = "/trunk";
        if (path.endsWith("/trunk")) {
            String string = path.substring(0, path.length() - "/trunk".length());
            if (string == null) {
                PyRequirementParser.$$$reportNull$$$0(41);
            }
            return string;
        }
        String slashTrunkSlash = "/trunk/";
        if (path.endsWith("/trunk/")) {
            String string = path.substring(0, path.length() - "/trunk/".length());
            if (string == null) {
                PyRequirementParser.$$$reportNull$$$0(42);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            PyRequirementParser.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    private static String dropRevision(@NotNull String path) {
        int atIndex;
        if (path == null) {
            PyRequirementParser.$$$reportNull$$$0(44);
        }
        if ((atIndex = path.lastIndexOf("@")) != -1) {
            String string = path.substring(0, atIndex);
            if (string == null) {
                PyRequirementParser.$$$reportNull$$$0(45);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            PyRequirementParser.$$$reportNull$$$0(46);
        }
        return string;
    }

    @Nullable
    private static String getVcsExtras(@NotNull Matcher matcher) {
        String beforeSubdir;
        if (matcher == null) {
            PyRequirementParser.$$$reportNull$$$0(47);
        }
        return (beforeSubdir = matcher.group(VCS_EXTRAS_BEFORE_SUBDIR_GROUP)) == null ? matcher.group(VCS_EXTRAS_AFTER_SUBDIR_GROUP) : beforeSubdir;
    }

    @Nullable
    private static PyRequirementVersionSpec parseVersionSpec(@NotNull String versionSpec) {
        if (versionSpec == null) {
            PyRequirementParser.$$$reportNull$$$0(48);
        }
        PyRequirementRelation relation = null;
        if (versionSpec.startsWith("===")) {
            relation = PyRequirementRelation.STR_EQ;
        } else if (versionSpec.startsWith("==")) {
            relation = PyRequirementRelation.EQ;
        } else if (versionSpec.startsWith("<=")) {
            relation = PyRequirementRelation.LTE;
        } else if (versionSpec.startsWith(">=")) {
            relation = PyRequirementRelation.GTE;
        } else if (versionSpec.startsWith("<")) {
            relation = PyRequirementRelation.LT;
        } else if (versionSpec.startsWith(">")) {
            relation = PyRequirementRelation.GT;
        } else if (versionSpec.startsWith("~=")) {
            relation = PyRequirementRelation.COMPATIBLE;
        } else if (versionSpec.startsWith("!=")) {
            relation = PyRequirementRelation.NE;
        }
        if (relation != null) {
            int versionIndex = PyRequirementParser.findFirstNotWhiteSpaceAfter(versionSpec, relation.getPresentableText().length());
            return PyRequirementsKt.pyRequirementVersionSpec(relation, versionSpec.substring(versionIndex));
        }
        return null;
    }

    @NotNull
    private static List<PyRequirement> parseRecursiveLine(@NotNull String line2, @Nullable VirtualFile containingFile, @NotNull Set<VirtualFile> visitedFiles, int flagLength) {
        if (line2 == null) {
            PyRequirementParser.$$$reportNull$$$0(49);
        }
        if (visitedFiles == null) {
            PyRequirementParser.$$$reportNull$$$0(50);
        }
        if (containingFile == null) {
            List<PyRequirement> list = Collections.emptyList();
            if (list == null) {
                PyRequirementParser.$$$reportNull$$$0(51);
            }
            return list;
        }
        int pathIndex = PyRequirementParser.findFirstNotWhiteSpaceAfter(line2, flagLength);
        if (pathIndex == line2.length()) {
            List<PyRequirement> list = Collections.emptyList();
            if (list == null) {
                PyRequirementParser.$$$reportNull$$$0(52);
            }
            return list;
        }
        String path = FileUtil.toSystemIndependentName((String)line2.substring(pathIndex));
        VirtualFile file = PyRequirementParser.findRecursiveFile(containingFile, path);
        if (file != null && !visitedFiles.contains(file)) {
            return PyRequirementParser.fromText(PyRequirementParser.loadText(file), file, visitedFiles);
        }
        List<PyRequirement> list = Collections.emptyList();
        if (list == null) {
            PyRequirementParser.$$$reportNull$$$0(53);
        }
        return list;
    }

    @NotNull
    private static String normalizeName(@NotNull String s) {
        if (s == null) {
            PyRequirementParser.$$$reportNull$$$0(54);
        }
        String string = s.replace('_', '-');
        if (string == null) {
            PyRequirementParser.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    private static String normalizeVersion(@NotNull String s) {
        if (s == null) {
            PyRequirementParser.$$$reportNull$$$0(56);
        }
        String string = s.replace('_', '-').replaceAll("-?py[\\d\\.]+", "");
        if (string == null) {
            PyRequirementParser.$$$reportNull$$$0(57);
        }
        return string;
    }

    private static int findFirstNotWhiteSpaceAfter(@NotNull String line2, int beginIndex) {
        if (line2 == null) {
            PyRequirementParser.$$$reportNull$$$0(58);
        }
        for (int i = beginIndex; i < line2.length(); ++i) {
            if (StringUtil.isWhiteSpace((char)line2.charAt(i))) continue;
            return i;
        }
        return line2.length();
    }

    private static int findFirstNotWhiteSpaceBefore(@NotNull String line2, int beginIndex) {
        if (line2 == null) {
            PyRequirementParser.$$$reportNull$$$0(59);
        }
        for (int i = beginIndex; i >= 0; --i) {
            if (StringUtil.isWhiteSpace((char)line2.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static VirtualFile findRecursiveFile(@NotNull VirtualFile containingFile, @NotNull String path) {
        VirtualFile dir;
        if (containingFile == null) {
            PyRequirementParser.$$$reportNull$$$0(60);
        }
        if (path == null) {
            PyRequirementParser.$$$reportNull$$$0(61);
        }
        if ((dir = containingFile.getParent()) == null) {
            return null;
        }
        VirtualFile file = dir.findFileByRelativePath(path);
        if (file != null) {
            return file;
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 8: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: 
            case 29: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedFiles";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyRequirementParser";
                break;
            }
            case 14: 
            case 21: 
            case 24: 
            case 33: 
            case 35: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_GROUP;
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameAndVersion";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installOptions";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionParts";
                break;
            }
            case 36: 
            case 40: 
            case 44: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = PATH_IN_VCS_GROUP;
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionSpec";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyRequirementParser";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "dropComments";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNameAndVersionFromVcsOrArchive";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersionSpecs";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateRequirementInstallOptions";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesAndCollapse";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateVcsInstallOptions";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "extractProject";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "dropTrunk";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "dropRevision";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRecursiveLine";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeName";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromLine";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseGitArchiveUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseArchiveUrl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseVcsProjectUrl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseRequirement";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dropComments";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseNameAndVersionFromVcsOrArchive";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createVcsOrArchiveRequirement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createVcsRequirement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "calculateRequirementInstallOptions";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesAndCollapse";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVcsOrArchiveNameParts";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVcsOrArchiveVersionParts";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "calculateVcsInstallOptions";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getEgg";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "extractProject";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "dropTrunk";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "dropRevision";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getVcsExtras";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "parseVersionSpec";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "parseRecursiveLine";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "normalizeName";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVersion";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findFirstNotWhiteSpaceAfter";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "findFirstNotWhiteSpaceBefore";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "findRecursiveFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

