/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import org.jetbrains.annotations.NotNull;

public class AddEncodingQuickFix
implements LocalQuickFix {
    private final String myDefaultEncoding;
    private final int myEncodingFormatIndex;

    public AddEncodingQuickFix(String defaultEncoding, int encodingFormatIndex) {
        this.myDefaultEncoding = defaultEncoding;
        this.myEncodingFormatIndex = encodingFormatIndex;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.add.encoding", new Object[0]);
        if (string == null) {
            AddEncodingQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        PsiFile file;
        if (project == null) {
            AddEncodingQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            AddEncodingQuickFix.$$$reportNull$$$0(2);
        }
        if ((file = (element = descriptor2.getPsiElement()).getContainingFile()) == null) {
            return;
        }
        PsiElement firstLine = file.getFirstChild();
        if (firstLine instanceof PsiComment && firstLine.getText().startsWith("#!")) {
            firstLine = firstLine.getNextSibling();
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        String commentText = String.format(PyEncodingUtil.ENCODING_FORMAT_PATTERN[this.myEncodingFormatIndex], this.myDefaultEncoding);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PsiComment encodingComment = elementGenerator.createFromText(languageLevel, PsiComment.class, commentText);
        encodingComment = (PsiComment)file.addBefore((PsiElement)encodingComment, firstLine);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(element.getContainingFile().getVirtualFile());
        if (fileEditor instanceof TextEditor) {
            if (encodingComment.getNextSibling() == null || !encodingComment.getNextSibling().textContains('\n')) {
                file.addAfter((PsiElement)elementGenerator.createFromText(languageLevel, PsiWhiteSpace.class, "\n"), (PsiElement)encodingComment);
            }
            Editor editor2 = ((TextEditor)fileEditor).getEditor();
            Document document = editor2.getDocument();
            int insertedLineNumber = document.getLineNumber(encodingComment.getTextOffset());
            editor2.getCaretModel().moveToLogicalPosition(new LogicalPosition(insertedLineNumber + 1, 0));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddEncodingQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddEncodingQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

