/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.jetbrains.python.codeInsight.typing.PyTypedDictTypeProvider;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyTypedDictInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyTypedDictInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.community.impl"})
public final class PyTypedDictInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new Visitor(holder, session);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J#\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020+H\u0016\u00a8\u0006,"}, d2={"Lcom/jetbrains/python/inspections/PyTypedDictInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "checkValidTotality", "", "totalityValue", "Lcom/jetbrains/python/psi/PyExpression;", "checkValueIsAType", "expression", "strType", "", "inspectUpdateSequenceArgument", "sequenceElements", "", "typedDictType", "Lcom/jetbrains/python/psi/types/PyTypedDictType;", "([Lcom/jetbrains/python/psi/PyExpression;Lcom/jetbrains/python/psi/types/PyTypedDictType;)V", "matchTypedDictFieldTypeAndTotality", "", "expected", "Lcom/jetbrains/python/psi/types/PyTypedDictType$FieldTypeAndTotality;", "actual", "tryGetNameIdentifier", "Lcom/intellij/psi/PsiElement;", "element", "visitPyArgumentList", "node", "Lcom/jetbrains/python/psi/PyArgumentList;", "visitPyAssignmentStatement", "Lcom/jetbrains/python/psi/PyAssignmentStatement;", "visitPyCallExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "visitPyClass", "Lcom/jetbrains/python/psi/PyClass;", "visitPyDelStatement", "Lcom/jetbrains/python/psi/PyDelStatement;", "visitPySubscriptionExpression", "Lcom/jetbrains/python/psi/PySubscriptionExpression;", "visitPyTargetExpression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "intellij.python.community.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @Override
        public void visitPySubscriptionExpression(@NotNull PySubscriptionExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            PyType operandType = this.myTypeEvalContext.getType(node.getOperand());
            if (!(operandType instanceof PyTypedDictType)) {
                return;
            }
            PyExpression indexExpression = node.getIndexExpression();
            String indexExprValue = PyEvaluator.evaluate(indexExpression, String.class);
            if (indexExprValue == null) {
                PsiElement psiElement = (PsiElement)indexExpression;
                StringBuilder stringBuilder = new StringBuilder().append("TypedDict key must be a string literal; expected one of ").append('(');
                Set<String> set = ((PyTypedDictType)operandType).getFields().keySet();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"operandType.fields.keys");
                this.registerProblem(psiElement, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)visitPySubscriptionExpression.1.INSTANCE, (int)31, null)).append(')').toString());
                return;
            }
            Object[] objectArray = (Object[])((PyTypedDictType)operandType).getFields();
            boolean bl = false;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            if (!objectArray2.containsKey(indexExprValue)) {
                objectArray = StringCompanionObject.INSTANCE;
                String string = "TypedDict \"%s\" has no key '%s'";
                objectArray2 = new Object[]{((PyTypedDictType)operandType).getName(), indexExprValue};
                PsiElement psiElement = (PsiElement)indexExpression;
                Visitor visitor2 = this;
                bl2 = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                visitor2.registerProblem(psiElement, string3);
            }
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            PyExpression value = node.findAssignedValue();
            if (value instanceof PyCallExpression && ((PyCallExpression)value).getCallee() != null) {
                PyExpression typedDictName;
                PyExpression pyExpression = ((PyCallExpression)value).getCallee();
                if (pyExpression == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pyExpression, (String)"value.callee!!");
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyTypedDictTypeProvider.Companion.isTypedDict(pyExpression, typeEvalContext) && (typedDictName = ((PyCallExpression)value).getArgument(0, "name", PyExpression.class)) instanceof PyStringLiteralExpression && Intrinsics.areEqual((Object)node.getName(), (Object)((PyStringLiteralExpression)typedDictName).getStringValue()) ^ true) {
                    this.registerProblem((PsiElement)typedDictName, "First argument has to match the variable name");
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void visitPyArgumentList(@NotNull PyArgumentList node) {
            PyExpression callee;
            PyCallExpression callExpression;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (node.getParent() instanceof PyClass) {
                PsiElement psiElement = node.getParent();
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.psi.PyClass");
                }
                PyClass pyClass = (PyClass)psiElement;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyTypedDictTypeProvider.Companion.isTypingTypedDictInheritor(pyClass, typeEvalContext)) {
                    PyExpression[] arguments;
                    PyExpression[] pyExpressionArray = arguments = node.getArguments();
                    int n = pyExpressionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PyExpression argument = pyExpressionArray[n2];
                        PyType type = this.myTypeEvalContext.getType(argument);
                        if (!(argument instanceof PyKeywordArgument) && !(type instanceof PyTypedDictType)) {
                            PyExpression pyExpression = argument;
                            Intrinsics.checkExpressionValueIsNotNull((Object)pyExpression, (String)"argument");
                            TypeEvalContext typeEvalContext2 = this.myTypeEvalContext;
                            Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext2, (String)"myTypeEvalContext");
                            if (!PyTypedDictTypeProvider.Companion.isTypedDict(pyExpression, typeEvalContext2)) {
                                this.registerProblem((PsiElement)argument, "TypedDict cannot inherit from a non-TypedDict base class");
                            }
                        }
                        if (argument instanceof PyKeywordArgument && Intrinsics.areEqual((Object)((PyKeywordArgument)argument).getKeyword(), (Object)"total") && ((PyKeywordArgument)argument).getValueExpression() != null) {
                            PyExpression pyExpression = ((PyKeywordArgument)argument).getValueExpression();
                            if (pyExpression == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)pyExpression, (String)"argument.valueExpression!!");
                            this.checkValidTotality(pyExpression);
                        }
                        ++n2;
                    }
                    return;
                }
            }
            if (node.getCallExpression() == null) return;
            PyCallExpression pyCallExpression = callExpression = node.getCallExpression();
            if (pyCallExpression == null) {
                Intrinsics.throwNpe();
            }
            if ((callee = pyCallExpression.getCallee()) == null) return;
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (!PyTypedDictTypeProvider.Companion.isTypedDict(callee, typeEvalContext)) return;
            PyExpression fields = callExpression.getArgument(1, "fields", PyExpression.class);
            if (!(fields instanceof PyDictLiteralExpression)) {
                return;
            }
            PyKeyValueExpression[] pyKeyValueExpressionArray = ((PyDictLiteralExpression)fields).getElements();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyKeyValueExpressionArray, (String)"fields.elements");
            PyKeyValueExpression[] $this$forEach$iv = pyKeyValueExpressionArray;
            boolean $i$f$forEach = false;
            PyKeyValueExpression[] pyKeyValueExpressionArray2 = $this$forEach$iv;
            int n = pyKeyValueExpressionArray2.length;
            int n3 = 0;
            while (true) {
                PyKeyValueExpression element$iv;
                if (n3 >= n) {
                    PyExpression totalityArgument = callExpression.getArgument(2, "total", PyExpression.class);
                    if (totalityArgument == null) return;
                    this.checkValidTotality(totalityArgument);
                    return;
                }
                PyKeyValueExpression it = element$iv = pyKeyValueExpressionArray2[n3];
                boolean bl = false;
                if (!(it instanceof PyKeyValueExpression)) {
                    return;
                }
                PyExpression pyExpression = it.getValue();
                this.checkValueIsAType(it.getValue(), pyExpression != null ? pyExpression.getText() : null);
                ++n3;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyClass(@NotNull PyClass node) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (!PyTypedDictTypeProvider.Companion.isTypingTypedDictInheritor(node, typeEvalContext)) {
                return;
            }
            if (node.getMetaClassExpression() != null) {
                PyExpression pyExpression = node.getMetaClassExpression();
                if (pyExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.psi.PyExpression");
                }
                this.registerProblem(pyExpression.getParent(), "Specifying a metaclass is not allowed in TypedDict");
            }
            boolean bl = false;
            Map ancestorsFields = new LinkedHashMap();
            List list = node.getAncestorTypes(this.myTypeEvalContext);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"node.getAncestorTypes(myTypeEvalContext)");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PyTypedDictType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List typedDictAncestors = (List)destination$iv$iv;
            Iterable $this$forEach$iv = typedDictAncestors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyTypedDictType typedDict = (PyTypedDictType)element$iv;
                boolean bl2 = false;
                Map $this$forEach$iv2 = typedDict.getFields();
                boolean $i$f$forEach2 = false;
                Map map2 = $this$forEach$iv2;
                boolean bl3 = false;
                Iterator iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry field = element$iv2 = iterator.next();
                    boolean bl4 = false;
                    String key = (String)field.getKey();
                    PyTypedDictType.FieldTypeAndTotality value = (PyTypedDictType.FieldTypeAndTotality)field.getValue();
                    Map map3 = ancestorsFields;
                    boolean bl5 = false;
                    Map map4 = map3;
                    boolean bl6 = false;
                    if (map4.containsKey(key)) {
                        Object v = ancestorsFields.get(key);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!this.matchTypedDictFieldTypeAndTotality((PyTypedDictType.FieldTypeAndTotality)v, value)) {
                            this.registerProblem((PsiElement)node.getSuperClassExpressionList(), "Cannot overwrite TypedDict field '" + key + "' while merging");
                            continue;
                        }
                    }
                    ancestorsFields.put(key, value);
                }
            }
            PyStatementList pyStatementList = node.getStatementList();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyStatementList, (String)"node.statementList");
            Object[] objectArray = pyStatementList.getStatements();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"node.statementList.statements");
            PyStatement singleStatement = (PyStatement)ArraysKt.singleOrNull((Object[])objectArray);
            if (singleStatement != null && singleStatement instanceof PyExpressionStatement && ((PyExpressionStatement)singleStatement).getExpression() instanceof PyNoneLiteralExpression) {
                PyExpression pyExpression = ((PyExpressionStatement)singleStatement).getExpression();
                if (pyExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.psi.PyNoneLiteralExpression");
                }
                if (((PyNoneLiteralExpression)pyExpression).isEllipsis()) {
                    this.registerProblem(this.tryGetNameIdentifier((PsiElement)singleStatement), "Invalid statement in TypedDict definition; expected 'field_name: field_type'", ProblemHighlightType.WEAK_WARNING);
                    return;
                }
            }
            node.processClassLevelDeclarations(new PsiScopeProcessor(this, ancestorsFields){
                final /* synthetic */ Visitor this$0;
                final /* synthetic */ Map $ancestorsFields;

                public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState $noName_1) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                    if (!(element instanceof PyTargetExpression)) {
                        this.this$0.registerProblem(Visitor.access$tryGetNameIdentifier(this.this$0, element), "Invalid statement in TypedDict definition; expected 'field_name: field_type'", ProblemHighlightType.WEAK_WARNING);
                        return true;
                    }
                    if (((PyTargetExpression)element).hasAssignedValue()) {
                        this.this$0.registerProblem((PsiElement)((PyTargetExpression)element).findAssignedValue(), "Right hand side values are not supported in TypedDict");
                        return true;
                    }
                    Map map2 = this.$ancestorsFields;
                    String string = ((PyTargetExpression)element).getName();
                    boolean bl = false;
                    Map map3 = map2;
                    boolean bl2 = false;
                    if (map3.containsKey(string)) {
                        this.this$0.registerProblem(element, "Cannot overwrite TypedDict field");
                        return true;
                    }
                    PyAnnotation pyAnnotation = ((PyTargetExpression)element).getAnnotation();
                    Visitor.access$checkValueIsAType(this.this$0, pyAnnotation != null ? pyAnnotation.getValue() : null, ((PyTargetExpression)element).getAnnotationValue());
                    return true;
                }
                {
                    this.this$0 = visitor2;
                    this.$ancestorsFields = map2;
                }
            });
        }

        @Override
        public void visitPyDelStatement(@NotNull PyDelStatement node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            for (PyExpression target : node.getTargets()) {
                for (PyExpression expr : PyUtil.flattenedParensAndTuples(target)) {
                    String index;
                    PyType type;
                    if (!(expr instanceof PySubscriptionExpression) || !((type = this.myTypeEvalContext.getType(((PySubscriptionExpression)expr).getOperand())) instanceof PyTypedDictType) || (index = PyEvaluator.evaluate(((PySubscriptionExpression)expr).getIndexExpression(), String.class)) == null) continue;
                    Map map2 = ((PyTypedDictType)type).getFields();
                    boolean bl = false;
                    Map map3 = map2;
                    boolean bl2 = false;
                    if (!map3.containsKey(index)) continue;
                    PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = ((PyTypedDictType)type).getFields().get(index);
                    if (fieldTypeAndTotality == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!fieldTypeAndTotality.isRequired()) continue;
                    this.registerProblem((PsiElement)((PySubscriptionExpression)expr).getIndexExpression(), "Key '" + index + "' of TypedDict '" + ((PyTypedDictType)type).getName() + "' cannot be deleted");
                }
            }
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            String key;
            PyType nodeType;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            PyExpression callee = node.getCallee();
            if (!(callee instanceof PyReferenceExpression) || ((PyReferenceExpression)callee).getQualifier() == null) {
                return;
            }
            PyExpression pyExpression = ((PyReferenceExpression)callee).getQualifier();
            if (pyExpression == null) {
                Intrinsics.throwNpe();
            }
            if (!((nodeType = this.myTypeEvalContext.getType(pyExpression)) instanceof PyTypedDictType)) {
                return;
            }
            PyExpression[] arguments = node.getArguments();
            if (Intrinsics.areEqual((Object)"update", (Object)((PyReferenceExpression)callee).getName())) {
                PyExpression[] pyExpressionArray;
                if (arguments.length == 1 && arguments[0] instanceof PySequenceExpression) {
                    PyExpression pyExpression2 = arguments[0];
                    if (pyExpression2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.psi.PySequenceExpression");
                    }
                    pyExpressionArray = ((PySequenceExpression)pyExpression2).getElements();
                } else {
                    pyExpressionArray = arguments;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pyExpressionArray, (String)"if (arguments.size == 1 \u2026).elements else arguments");
                this.inspectUpdateSequenceArgument(pyExpressionArray, (PyTypedDictType)nodeType);
            }
            if (Intrinsics.areEqual((Object)"clear", (Object)((PyReferenceExpression)callee).getName()) || Intrinsics.areEqual((Object)"popitem", (Object)((PyReferenceExpression)callee).getName())) {
                boolean bl;
                block29: {
                    Map $this$any$iv = ((PyTypedDictType)nodeType).getFields();
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl = false;
                    } else {
                        Map map2 = $this$any$iv;
                        boolean bl2 = false;
                        Iterator iterator = map2.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry it = element$iv = iterator.next();
                            boolean bl3 = false;
                            if (!((PyTypedDictType.FieldTypeAndTotality)it.getValue()).isRequired()) continue;
                            bl = true;
                            break block29;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    ASTNode aSTNode = ((PyReferenceExpression)callee).getNameElement();
                    this.registerProblem((PsiElement)(aSTNode != null ? aSTNode.getPsi() : null), "This operation might break TypedDict consistency", Intrinsics.areEqual((Object)"clear", (Object)((PyReferenceExpression)callee).getName()) ? ProblemHighlightType.WARNING : ProblemHighlightType.WEAK_WARNING);
                }
            }
            if (Intrinsics.areEqual((Object)"pop", (Object)((PyReferenceExpression)callee).getName())) {
                Intrinsics.checkExpressionValueIsNotNull((Object)arguments, (String)"arguments");
                Object $i$f$any = arguments;
                boolean bl = false;
                PyExpression[] pyExpressionArray = $i$f$any;
                boolean bl4 = false;
                String string = key = !(pyExpressionArray.length == 0) ? PyEvaluator.evaluate(arguments[0], String.class) : null;
                if (key != null) {
                    $i$f$any = ((PyTypedDictType)nodeType).getFields();
                    bl = false;
                    pyExpressionArray = $i$f$any;
                    bl4 = false;
                    if (pyExpressionArray.containsKey(key)) {
                        PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = ((PyTypedDictType)nodeType).getFields().get(key);
                        if (fieldTypeAndTotality == null) {
                            Intrinsics.throwNpe();
                        }
                        if (fieldTypeAndTotality.isRequired()) {
                            ASTNode aSTNode = ((PyReferenceExpression)callee).getNameElement();
                            this.registerProblem((PsiElement)(aSTNode != null ? aSTNode.getPsi() : null), "Key '" + key + "' of TypedDict '" + ((PyTypedDictType)nodeType).getName() + "' cannot be deleted");
                        }
                    }
                }
            }
            if (Intrinsics.areEqual((Object)"setdefault", (Object)((PyReferenceExpression)callee).getName())) {
                Intrinsics.checkExpressionValueIsNotNull((Object)arguments, (String)"arguments");
                Object $i$f$any = arguments;
                boolean bl = false;
                Object object = $i$f$any;
                boolean bl5 = false;
                String string = key = !(((PyExpression[])object).length == 0) ? PyEvaluator.evaluate(arguments[0], String.class) : null;
                if (key != null) {
                    $i$f$any = ((PyTypedDictType)nodeType).getFields();
                    bl = false;
                    object = $i$f$any;
                    bl5 = false;
                    if (object.containsKey(key)) {
                        PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = ((PyTypedDictType)nodeType).getFields().get(key);
                        if (fieldTypeAndTotality == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!fieldTypeAndTotality.isRequired() && node.getArguments().length > 1) {
                            PyType valueType = this.myTypeEvalContext.getType(arguments[1]);
                            PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality2 = ((PyTypedDictType)nodeType).getFields().get(key);
                            if (fieldTypeAndTotality2 == null) {
                                Intrinsics.throwNpe();
                            }
                            if (!PyTypeChecker.match(fieldTypeAndTotality2.getType(), valueType, this.myTypeEvalContext)) {
                                PsiElement psiElement = (PsiElement)arguments[1];
                                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                                object = "Expected type '%s', got '%s' instead";
                                Object[] objectArray = new Object[2];
                                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality3 = ((PyTypedDictType)nodeType).getFields().get(key);
                                if (fieldTypeAndTotality3 == null) {
                                    Intrinsics.throwNpe();
                                }
                                objectArray[0] = PythonDocumentationProvider.getTypeName(fieldTypeAndTotality3.getType(), this.myTypeEvalContext);
                                objectArray[1] = PythonDocumentationProvider.getTypeName(valueType, this.myTypeEvalContext);
                                Object[] objectArray2 = objectArray;
                                PsiElement psiElement2 = psiElement;
                                Visitor visitor2 = this;
                                boolean bl6 = false;
                                String string2 = String.format((String)object, Arrays.copyOf(objectArray2, objectArray2.length));
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                                String string3 = string2;
                                visitor2.registerProblem(psiElement2, string3);
                            }
                        }
                    }
                }
            }
            if (PyTypingTypeProvider.resolveToQualifiedNames(callee, this.myTypeEvalContext).contains("typing.Mapping.get")) {
                PyExpression pyExpression3 = node.getArgument(0, "key", PyExpression.class);
                if (pyExpression3 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pyExpression3, (String)"node.getArgument(0, \"key\u2026on::class.java) ?: return");
                PyExpression keyArgument = pyExpression3;
                String key2 = PyEvaluator.evaluate(keyArgument, String.class);
                if (key2 == null) {
                    this.registerProblem((PsiElement)keyArgument, "Key should be string");
                    return;
                }
                if (!((PyTypedDictType)nodeType).getFields().containsKey(key2)) {
                    this.registerProblem((PsiElement)keyArgument, "TypedDict \"" + ((PyTypedDictType)nodeType).getName() + "\" has no key '" + key2 + "'\n");
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            List<Pair<PyExpression, PyExpression>> list = node.getTargetsToValuesMapping();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"node.targetsToValuesMapping");
            List<Pair<PyExpression, PyExpression>> targetsToValuesMapping = list;
            PyExpression[] pyExpressionArray = node.getTargets();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyExpressionArray, (String)"node.targets");
            PyExpression[] $this$forEach$iv = pyExpressionArray;
            boolean $i$f$forEach = false;
            PyExpression[] pyExpressionArray2 = $this$forEach$iv;
            int n = pyExpressionArray2.length;
            for (int i = 0; i < n; ++i) {
                void $this$mapTo$iv$iv;
                Pair it;
                Iterable $this$filterTo$iv$iv;
                String indexString;
                PyType targetType;
                PyExpression element$iv;
                PyExpression target = element$iv = pyExpressionArray2[i];
                boolean bl = false;
                if (!(target instanceof PySubscriptionExpression) || !((targetType = this.myTypeEvalContext.getType(((PySubscriptionExpression)target).getOperand())) instanceof PyTypedDictType) || (indexString = PyEvaluator.evaluate(((PySubscriptionExpression)target).getIndexExpression(), String.class)) == null) continue;
                PyType expected = ((PyTypedDictType)targetType).getElementType(indexString);
                Iterable $this$filter$iv = targetsToValuesMapping;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Pair)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((PyExpression)it.first), (Object)target)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    PyExpression pyExpression = (PyExpression)it.second;
                    collection.add(pyExpression);
                }
                List actualExpressions = (List)destination$iv$iv;
                Iterable $this$forEach$iv2 = actualExpressions;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String string;
                    PyExpression actual = (PyExpression)element$iv2;
                    boolean bl4 = false;
                    PyType actualType = this.myTypeEvalContext.getType(actual);
                    if (PyTypeChecker.match(expected, actualType, this.myTypeEvalContext)) continue;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "Expected type '%s', got '%s' instead";
                    Object[] objectArray = new Object[]{PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext), PythonDocumentationProvider.getTypeName(actualType, this.myTypeEvalContext)};
                    PsiElement psiElement = (PsiElement)actual;
                    Visitor visitor2 = this;
                    boolean bl5 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    visitor2.registerProblem(psiElement, string);
                }
            }
        }

        private final void checkValueIsAType(PyExpression expression, String strType) {
            if (!(expression instanceof PyReferenceExpression) && !(expression instanceof PySubscriptionExpression) || strType == null) {
                this.registerProblem((PsiElement)expression, "Value must be a type", ProblemHighlightType.WEAK_WARNING);
                return;
            }
            PyType type = (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType(strType, (PsiElement)expression, this.myTypeEvalContext));
            if (type == null) {
                boolean bl;
                block6: {
                    Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(expression, this.myTypeEvalContext);
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"PyTypingTypeProvider.res\u2026ssion, myTypeEvalContext)");
                    Iterable $this$any$iv = collection;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String qualifiedName = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)"typing.Any", (Object)qualifiedName)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    this.registerProblem((PsiElement)expression, "Value must be a type", ProblemHighlightType.WEAK_WARNING);
                }
            }
        }

        private final PsiElement tryGetNameIdentifier(PsiElement element) {
            PsiElement psiElement;
            if (element instanceof PsiNameIdentifierOwner) {
                psiElement = ((PsiNameIdentifierOwner)element).getNameIdentifier();
                if (psiElement == null) {
                    psiElement = element;
                }
            } else {
                psiElement = element;
            }
            return psiElement;
        }

        private final void checkValidTotality(PyExpression totalityValue) {
            LanguageLevel languageLevel = LanguageLevel.forElement(totalityValue.getOriginalElement());
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)languageLevel), (String)"LanguageLevel.forElement\u2026ityValue.originalElement)");
            if (languageLevel.isPy3K() && !(totalityValue instanceof PyBoolLiteralExpression) || !CollectionsKt.listOf((Object[])new String[]{"True", "False"}).contains(totalityValue.getText())) {
                this.registerProblem((PsiElement)totalityValue, "Value of 'total' must be True or False");
            }
        }

        private final boolean matchTypedDictFieldTypeAndTotality(PyTypedDictType.FieldTypeAndTotality expected, PyTypedDictType.FieldTypeAndTotality actual) {
            return expected.isRequired() == actual.isRequired() && PyTypeChecker.match(expected.getType(), actual.getType(), this.myTypeEvalContext);
        }

        private final void inspectUpdateSequenceArgument(PyExpression[] sequenceElements, PyTypedDictType typedDictType) {
            PyExpression[] $this$forEach$iv = sequenceElements;
            boolean $i$f$forEach = false;
            PyExpression[] pyExpressionArray = $this$forEach$iv;
            int n = pyExpressionArray.length;
            for (int i = 0; i < n; ++i) {
                String string;
                PyExpression element$iv;
                PyExpression it = element$iv = pyExpressionArray[i];
                boolean bl = false;
                PsiElement key = null;
                String keyAsString = null;
                PyExpression value = null;
                if (it instanceof PyKeyValueExpression && ((PyKeyValueExpression)it).getKey() instanceof PyStringLiteralExpression) {
                    key = (PsiElement)((PyKeyValueExpression)it).getKey();
                    PyExpression pyExpression = ((PyKeyValueExpression)it).getKey();
                    if (pyExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.psi.PyStringLiteralExpression");
                    }
                    keyAsString = ((PyStringLiteralExpression)pyExpression).getStringValue();
                    value = ((PyKeyValueExpression)it).getValue();
                } else if (it instanceof PyParenthesizedExpression) {
                    PyExpression expression = PyPsiUtils.flattenParens(it);
                    if (expression == null) continue;
                    if (expression instanceof PyTupleExpression && ((PyTupleExpression)expression).getElements().length == 2 && ((PyTupleExpression)expression).getElements()[0] instanceof PyStringLiteralExpression) {
                        key = (PsiElement)((PyTupleExpression)expression).getElements()[0];
                        PyExpression pyExpression = ((PyTupleExpression)expression).getElements()[0];
                        if (pyExpression == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.psi.PyStringLiteralExpression");
                        }
                        keyAsString = ((PyStringLiteralExpression)pyExpression).getStringValue();
                        value = ((PyTupleExpression)expression).getElements()[1];
                    }
                } else {
                    if (!(it instanceof PyKeywordArgument) || ((PyKeywordArgument)it).getValueExpression() == null) continue;
                    ASTNode aSTNode = ((PyKeywordArgument)it).getKeywordNode();
                    key = aSTNode != null ? aSTNode.getPsi() : null;
                    keyAsString = ((PyKeywordArgument)it).getKeyword();
                    value = ((PyKeywordArgument)it).getValueExpression();
                }
                LinkedHashMap<String, PyTypedDictType.FieldTypeAndTotality> fields = typedDictType.getFields();
                if (value == null) continue;
                if (keyAsString == null) {
                    this.registerProblem(key, "Cannot add a non-string key to TypedDict " + typedDictType.getName());
                    continue;
                }
                if (!fields.containsKey(keyAsString)) {
                    this.registerProblem(key, "TypedDict " + typedDictType.getName() + " cannot have key " + keyAsString);
                    continue;
                }
                PyType valueType = this.myTypeEvalContext.getType(value);
                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = fields.get(keyAsString);
                if (PyTypeChecker.match(fieldTypeAndTotality != null ? fieldTypeAndTotality.getType() : null, valueType, this.myTypeEvalContext)) continue;
                PsiElement psiElement = (PsiElement)value;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "Expected type '%s', got '%s' instead";
                Object[] objectArray = new Object[2];
                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality2 = fields.get(keyAsString);
                if (fieldTypeAndTotality2 == null) {
                    Intrinsics.throwNpe();
                }
                objectArray[0] = PythonDocumentationProvider.getTypeName(fieldTypeAndTotality2.getType(), this.myTypeEvalContext);
                objectArray[1] = PythonDocumentationProvider.getTypeName(valueType, this.myTypeEvalContext);
                Object[] objectArray2 = objectArray;
                PsiElement psiElement2 = psiElement;
                Visitor visitor2 = this;
                boolean bl2 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
                visitor2.registerProblem(psiElement2, string);
            }
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            super(holder, session);
        }

        public static final /* synthetic */ PsiElement access$tryGetNameIdentifier(Visitor $this, PsiElement element) {
            return $this.tryGetNameIdentifier(element);
        }

        public static final /* synthetic */ void access$checkValueIsAType(Visitor $this, PyExpression expression, String strType) {
            $this.checkValueIsAType(expression, strType);
        }
    }
}

