/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ConvertDocstringQuickFix;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySingleQuotedDocstringInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PySingleQuotedDocstringInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PySingleQuotedDocstringInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PySingleQuotedDocstringInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression string) {
            ProblemsHolder holder;
            String stringText = string.getText();
            int length = PyStringLiteralUtil.getPrefixLength(stringText);
            stringText = stringText.substring(length);
            PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)string, PyDocStringOwner.class);
            if (docStringOwner != null && docStringOwner.getDocStringExpression() == string && !stringText.startsWith("\"\"\"") && !stringText.endsWith("\"\"\"") && (holder = this.getHolder()) != null) {
                int quoteCount = 1;
                if (stringText.startsWith("'''") && stringText.endsWith("'''")) {
                    quoteCount = 3;
                }
                TextRange trStart = new TextRange(length, length + quoteCount);
                TextRange trEnd = new TextRange(stringText.length() + length - quoteCount, stringText.length() + length);
                if (string.getStringValue().isEmpty()) {
                    holder.registerProblem((PsiElement)string, PyBundle.message("INSP.message.single.quoted.docstring", new Object[0]), new LocalQuickFix[]{new ConvertDocstringQuickFix()});
                } else {
                    holder.registerProblem((PsiElement)string, trStart, PyBundle.message("INSP.message.single.quoted.docstring", new Object[0]), new LocalQuickFix[]{new ConvertDocstringQuickFix()});
                    holder.registerProblem((PsiElement)string, trEnd, PyBundle.message("INSP.message.single.quoted.docstring", new Object[0]), new LocalQuickFix[]{new ConvertDocstringQuickFix()});
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PySingleQuotedDocstringInspection$Visitor", "<init>"));
        }
    }
}

