/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyPsiShadowingBuiltinsInspection
extends PyInspection {
    public List<String> ignoredNames = new ArrayList<String>();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyPsiShadowingBuiltinsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyPsiShadowingBuiltinsInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session, this.ignoredNames);
    }

    @NotNull
    protected LocalQuickFix[] createQuickFixes(String name, PsiElement problemElement) {
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            PyPsiShadowingBuiltinsInspection.$$$reportNull$$$0(2);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyPsiShadowingBuiltinsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyPsiShadowingBuiltinsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Visitor
    extends PyInspectionVisitor {
        private final Set<String> myIgnoredNames;

        Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, Collection<String> ignoredNames) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (ignoredNames == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, session);
            this.myIgnoredNames = ImmutableSet.copyOf(ignoredNames);
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            this.processElement(node);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            this.processElement(node);
        }

        @Override
        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            this.processElement(node);
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (!node.isQualified()) {
                this.processElement(node);
            }
        }

        private void processElement(@NotNull PsiNameIdentifierOwner element) {
            PyBuiltinCache builtinCache;
            PsiElement builtin;
            ScopeOwner owner;
            if (element == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if ((owner = ScopeUtil.getScopeOwner((PsiElement)element)) instanceof PyClass) {
                return;
            }
            String name = element.getName();
            if (name != null && !this.myIgnoredNames.contains(name) && (builtin = (builtinCache = PyBuiltinCache.getInstance((PsiElement)element)).getByName(name)) != null && !PyUtil.inSameFile(builtin, (PsiElement)element)) {
                PsiElement identifier = element.getNameIdentifier();
                PsiElement problemElement = identifier != null ? identifier : element;
                this.registerProblem(problemElement, String.format("Shadows built-in name '%s'", name), ProblemHighlightType.WEAK_WARNING, null, PyPsiShadowingBuiltinsInspection.this.createQuickFixes(name, problemElement));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignoredNames";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyPsiShadowingBuiltinsInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyNamedParameter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

