/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyChangeSignatureQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMethodOverridingInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMethodOverridingInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyMethodOverridingInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyMethodOverridingInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyFunction(PyFunction function) {
            PyClass cls = function.getContainingClass();
            if (cls == null) {
                return;
            }
            if (PyUtil.isInitOrNewMethod(function) || PyKnownDecoratorUtil.hasUnknownOrChangingSignatureDecorator(function, this.myTypeEvalContext) || ContainerUtil.exists((Object[])PyInspectionExtension.EP_NAME.getExtensions(), e -> e.ignoreMethodParameters(function, this.myTypeEvalContext))) {
                return;
            }
            for (PsiElement psiElement : PySuperMethodsSearch.search(function, this.myTypeEvalContext)) {
                PyFunction baseMethod;
                if (!(psiElement instanceof PyFunction) || PyUtil.isSignatureCompatibleTo(function, baseMethod = (PyFunction)psiElement, this.myTypeEvalContext)) continue;
                PyClass baseClass = baseMethod.getContainingClass();
                String msg = PyBundle.message("INSP.signature.mismatch", cls.getName() + "." + function.getName() + "()", baseClass != null ? baseClass.getName() : "");
                this.registerProblem((PsiElement)function.getParameterList(), msg, new LocalQuickFix[]{PyChangeSignatureQuickFix.forMismatchingMethods(function, baseMethod)});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMethodOverridingInspection$Visitor", "<init>"));
        }
    }
}

