/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveDictKeyQuickFix;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDictDuplicateKeysInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyDictDuplicateKeysInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyDictDuplicateKeysInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyDictDuplicateKeysInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyDictLiteralExpression(@NotNull PyDictLiteralExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (node.isEmpty()) {
                return;
            }
            MultiMap keyValueAndKeys = new MultiMap();
            for (PyKeyValueExpression element : node.getElements()) {
                Pair<PsiElement, String> keyAndValue = this.getDictLiteralKey(element);
                if (keyAndValue == null) continue;
                keyValueAndKeys.putValue(keyAndValue.second, keyAndValue.first);
            }
            this.registerProblems((MultiMap<String, PsiElement>)keyValueAndKeys, new PyRemoveDictKeyQuickFix());
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (!Visitor.isDict(node)) {
                return;
            }
            MultiMap keyValueAndKeys = new MultiMap();
            for (PyExpression argument : node.getArguments()) {
                Pair<PsiElement, String> keyAndValue;
                if ((argument = PyPsiUtils.flattenParens(argument)) instanceof PySequenceExpression) {
                    for (PyExpression element : ((PySequenceExpression)argument).getElements()) {
                        Pair<PsiElement, String> keyAndValue2 = this.getDictCallKey(element);
                        if (keyAndValue2 == null) continue;
                        keyValueAndKeys.putValue(keyAndValue2.second, keyAndValue2.first);
                    }
                    continue;
                }
                if (!(argument instanceof PyKeywordArgument) || (keyAndValue = this.getDictCallKey(argument)) == null) continue;
                keyValueAndKeys.putValue(keyAndValue.second, keyAndValue.first);
            }
            this.registerProblems((MultiMap<String, PsiElement>)keyValueAndKeys, new LocalQuickFix[0]);
        }

        @Nullable
        private Pair<PsiElement, String> getDictLiteralKey(@NotNull PyKeyValueExpression argument) {
            PyExpression key;
            String keyValue;
            if (argument == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            return (keyValue = this.getKeyValue((PsiElement)(key = argument.getKey()))) != null ? Pair.createNonNull((Object)key, (Object)keyValue) : null;
        }

        @Nullable
        private String getKeyValue(@NotNull PsiElement node) {
            BigDecimal value;
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (node instanceof PyStringLiteralExpression) {
                return Visitor.wrapStringKey(((PyStringLiteralExpression)node).getStringValue());
            }
            if (node instanceof PyNumericLiteralExpression && (value = ((PyNumericLiteralExpression)node).getBigDecimalValue()) != null) {
                String keyValue = value.toPlainString();
                return !value.equals(BigDecimal.ZERO) && this.myTypeEvalContext.getType((PyNumericLiteralExpression)node) == PyBuiltinCache.getInstance(node).getComplexType() ? keyValue + "j" : keyValue;
            }
            return node instanceof PyLiteralExpression || node instanceof PyReferenceExpression ? node.getText() : null;
        }

        private void registerProblems(@NotNull MultiMap<String, PsiElement> keyValueAndKeys, LocalQuickFix ... quickFixes) {
            if (keyValueAndKeys == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (quickFixes == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            for (Map.Entry entry : keyValueAndKeys.entrySet()) {
                String keyValue = (String)entry.getKey();
                Collection keys = (Collection)entry.getValue();
                if (keys.size() <= 1) continue;
                for (PsiElement key : keys) {
                    this.registerProblem(key, "Dictionary contains duplicate keys '" + Visitor.unwrapStringKey(keyValue) + "'", quickFixes);
                }
            }
        }

        @Nullable
        private Pair<PsiElement, String> getDictCallKey(@Nullable PyExpression argument) {
            PyExpression key;
            String keyValue;
            PyExpression expression;
            if (argument instanceof PyParenthesizedExpression && (expression = PyPsiUtils.flattenParens(argument)) instanceof PyTupleExpression && (keyValue = this.getKeyValue((PsiElement)(key = ((PyTupleExpression)expression).getElements()[0]))) != null) {
                return Pair.createNonNull((Object)key, (Object)keyValue);
            }
            if (argument instanceof PyKeywordArgument) {
                ASTNode node = ((PyKeywordArgument)argument).getKeywordNode();
                String keyValue2 = ((PyKeywordArgument)argument).getKeyword();
                if (node != null && keyValue2 != null) {
                    return Pair.createNonNull((Object)node.getPsi(), (Object)Visitor.wrapStringKey(keyValue2));
                }
            }
            return null;
        }

        private static boolean isDict(@NotNull PyCallExpression expression) {
            PyExpression callee;
            if (expression == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            return (callee = expression.getCallee()) != null && "dict".equals(callee.getText());
        }

        @NotNull
        private static String wrapStringKey(@NotNull String key) {
            if (key == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            String string = "'" + key + "'";
            if (string == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        private static String unwrapStringKey(@NotNull String key) {
            if (key == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            String string = StringUtil.unquoteString((String)key, (char)'\'');
            if (string == null) {
                Visitor.$$$reportNull$$$0(11);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyValueAndKeys";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quickFixes";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyDictDuplicateKeysInspection$Visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyDictDuplicateKeysInspection$Visitor";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrapStringKey";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unwrapStringKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyDictLiteralExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDictLiteralKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getKeyValue";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "registerProblems";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isDict";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapStringKey";
                    break;
                }
                case 9: 
                case 11: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "unwrapStringKey";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

