/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyPreFormatProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiFile file;
        PsiElement psiElement;
        if (element == null) {
            PyPreFormatProcessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PyPreFormatProcessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = element.getPsi()) == null) {
            TextRange textRange = range;
            if (textRange == null) {
                PyPreFormatProcessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        if (!psiElement.getLanguage().is((Language)PythonLanguage.getInstance())) {
            TextRange textRange = range;
            if (textRange == null) {
                PyPreFormatProcessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        PyPsiUtils.assertValid(psiElement);
        PsiFile psiFile = file = psiElement.isValid() ? psiElement.getContainingFile() : null;
        if (file == null) {
            TextRange textRange = range;
            if (textRange == null) {
                PyPreFormatProcessor.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        TextRange textRange = new PyCommentFormatter(file).process(psiElement, range);
        if (textRange == null) {
            PyPreFormatProcessor.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    private static boolean isTrailingComment(@NotNull PsiComment comment) {
        PsiElement prevElement;
        if (comment == null) {
            PyPreFormatProcessor.$$$reportNull$$$0(6);
        }
        return (prevElement = comment.getPrevSibling()) != null && (!(prevElement instanceof PsiWhiteSpace) || !prevElement.textContains('\n'));
    }

    public boolean changesWhitespacesOnly() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PyPreFormatProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PyPreFormatProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTrailingComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PyCommentFormatter
    extends PyRecursiveElementVisitor {
        private final Project myProject;
        private final PyCodeStyleSettings myPyCodeStyleSettings;
        private final List<Couple<PsiComment>> myCommentReplacements;
        private TextRange myRange;
        private int myDelta;

        public PyCommentFormatter(@NotNull PsiFile file) {
            if (file == null) {
                PyCommentFormatter.$$$reportNull$$$0(0);
            }
            this.myCommentReplacements = new ArrayList<Couple<PsiComment>>();
            this.myDelta = 0;
            this.myProject = file.getProject();
            this.myPyCodeStyleSettings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PyCodeStyleSettings.class);
        }

        public TextRange process(PsiElement element, TextRange range) {
            if (!this.myPyCodeStyleSettings.SPACE_AFTER_NUMBER_SIGN) {
                return range;
            }
            this.myRange = range;
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myProject);
            Document document = manager.getDocument(element.getContainingFile());
            if (document != null) {
                element.accept((PsiElementVisitor)this);
                for (Couple<PsiComment> pair : this.myCommentReplacements) {
                    ((PsiComment)pair.getFirst()).replace((PsiElement)pair.getSecond());
                }
            }
            return TextRange.create((int)range.getStartOffset(), (int)(range.getEndOffset() + this.myDelta));
        }

        public void visitComment(@NotNull PsiComment comment) {
            if (comment == null) {
                PyCommentFormatter.$$$reportNull$$$0(1);
            }
            if (!this.myRange.contains(comment.getTextRange())) {
                return;
            }
            String origText = comment.getText();
            int commentStart = origText.indexOf(35);
            if (commentStart != -1 && commentStart + 1 < origText.length()) {
                String newText;
                char charAfterDash = origText.charAt(commentStart + 1);
                if (charAfterDash == '!' && comment.getTextRange().getStartOffset() == 0) {
                    return;
                }
                if (charAfterDash == '#' || charAfterDash == ':') {
                    return;
                }
                String commentTextWithoutDash = origText.substring(commentStart + 1);
                if (PyPreFormatProcessor.isTrailingComment(comment)) {
                    newText = "# " + StringUtil.trimLeading((String)commentTextWithoutDash);
                } else if (!StringUtil.isWhiteSpace((char)charAfterDash)) {
                    newText = "# " + commentTextWithoutDash;
                } else {
                    return;
                }
                if (!newText.equals(origText)) {
                    this.myDelta += newText.length() - origText.length();
                    PyElementGenerator elementGenerator = PyElementGenerator.getInstance(this.myProject);
                    PsiComment newComment = elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)comment), PsiComment.class, newText);
                    this.myCommentReplacements.add((Couple<PsiComment>)Couple.of((Object)comment, (Object)newComment));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/formatter/PyPreFormatProcessor$PyCommentFormatter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitComment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

