/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.python.debugger.PyDebugValueDescriptor;
import com.jetbrains.python.debugger.PyDebugValueGroupsKt;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFullValueEvaluator;
import com.jetbrains.python.debugger.PyLoadingValueEvaluator;
import com.jetbrains.python.debugger.PyNumericContainerValueEvaluator;
import com.jetbrains.python.debugger.PyOnDemandValueEvaluator;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PyTypeHandler;
import com.jetbrains.python.debugger.PyValueModifier;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.render.PyNodeRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugValue
extends XNamedValue {
    private static final Logger LOG = Logger.getInstance(PyDebugValue.class);
    private static final String DATA_FRAME = "DataFrame";
    private static final String SERIES = "Series";
    private static final Map<String, String> EVALUATOR_POSTFIXES = ImmutableMap.of((Object)"ndarray", (Object)"Array", (Object)"DataFrame", (Object)"DataFrame", (Object)"Series", (Object)"Series");
    private static final int MAX_ITEMS_TO_HANDLE = 100;
    public static final int MAX_VALUE = 256;
    public static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    public static final String RETURN_VALUES_PREFIX = "__pydevd_ret_val_dict";
    @Nullable
    private String myTempName;
    @Nullable
    private final String myType;
    @Nullable
    private final String myTypeQualifier;
    @Nullable
    private String myValue;
    private final boolean myContainer;
    @Nullable
    private final String myShape;
    private final boolean myIsReturnedVal;
    private final boolean myIsIPythonHidden;
    @Nullable
    private PyDebugValue myParent;
    @Nullable
    private String myId;
    private ValuesPolicy myLoadValuePolicy;
    @NotNull
    private PyFrameAccessor myFrameAccessor;
    @Nullable
    private volatile XValueNode myLastNode;
    private final boolean myErrorOnEval;
    private int myOffset;
    private int myCollectionLength;
    @NotNull
    private PyDebugValueDescriptor myDescriptor;
    private static final Map<String, ValuesPolicy> POLICY_DEFAULT_VALUES = ImmutableMap.of((Object)"__pydevd_value_async", (Object)((Object)ValuesPolicy.ASYNC), (Object)"__pydevd_value_on_demand", (Object)((Object)ValuesPolicy.ON_DEMAND));
    public static final Map<ValuesPolicy, String> POLICY_ENV_VARS = ImmutableMap.of((Object)((Object)ValuesPolicy.ASYNC), (Object)"PYDEVD_LOAD_VALUES_ASYNC", (Object)((Object)ValuesPolicy.ON_DEMAND), (Object)"PYDEVD_LOAD_VALUES_ON_DEMAND");
    private static final Pattern IS_TYPE_DECLARATION = Pattern.compile("<(?:class|type)\\s*'(?<TYPE>.*?)'>");

    public PyDebugValue(@NotNull String name, @Nullable String type, @Nullable String typeQualifier, @Nullable String value, boolean container, @Nullable String shape, boolean isReturnedVal, boolean isIPythonHidden, boolean errorOnEval, @NotNull PyFrameAccessor frameAccessor) {
        if (name == null) {
            PyDebugValue.$$$reportNull$$$0(0);
        }
        if (frameAccessor == null) {
            PyDebugValue.$$$reportNull$$$0(1);
        }
        this(name, type, typeQualifier, value, container, shape, isReturnedVal, isIPythonHidden, errorOnEval, null, frameAccessor);
    }

    public PyDebugValue(@NotNull String name, @Nullable String type, @Nullable String typeQualifier, @Nullable String value, boolean container, @Nullable String shape, boolean isReturnedVal, boolean isIPythonHidden, boolean errorOnEval, @Nullable PyDebugValue parent, @NotNull PyFrameAccessor frameAccessor) {
        if (name == null) {
            PyDebugValue.$$$reportNull$$$0(2);
        }
        if (frameAccessor == null) {
            PyDebugValue.$$$reportNull$$$0(3);
        }
        super(name);
        this.myTempName = null;
        this.myId = null;
        this.myLastNode = null;
        this.myCollectionLength = -1;
        this.myDescriptor = new PyDebugValueDescriptor();
        this.myType = type;
        this.myTypeQualifier = Strings.isNullOrEmpty((String)typeQualifier) ? null : typeQualifier;
        this.myValue = value;
        this.myContainer = container;
        this.myShape = shape;
        this.myIsReturnedVal = isReturnedVal;
        this.myIsIPythonHidden = isIPythonHidden;
        this.myErrorOnEval = errorOnEval;
        this.myParent = parent;
        this.myFrameAccessor = frameAccessor;
        this.myLoadValuePolicy = ValuesPolicy.SYNC;
        if (POLICY_DEFAULT_VALUES.containsKey(this.myValue)) {
            this.myLoadValuePolicy = POLICY_DEFAULT_VALUES.get(this.myValue);
            this.setValue(" ");
        }
    }

    public PyDebugValue(@NotNull PyDebugValue value, @NotNull String newName) {
        if (value == null) {
            PyDebugValue.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            PyDebugValue.$$$reportNull$$$0(5);
        }
        this(newName, value.getType(), value.getTypeQualifier(), value.getValue(), value.isContainer(), value.getShape(), value.isReturnedVal(), value.isIPythonHidden(), value.isErrorOnEval(), value.getParent(), value.getFrameAccessor());
        this.myOffset = value.getOffset();
        this.setLoadValuePolicy(value.getLoadValuePolicy());
        this.setTempName(value.getTempName());
    }

    public PyDebugValue(@NotNull PyDebugValue value) {
        if (value == null) {
            PyDebugValue.$$$reportNull$$$0(6);
        }
        this(value, value.getName());
    }

    @Nullable
    public String getTempName() {
        return this.myTempName != null ? this.myTempName : this.myName;
    }

    public void setTempName(@Nullable String tempName) {
        this.myTempName = tempName;
    }

    @Nullable
    public String getType() {
        return this.myType;
    }

    public void setValue(@Nullable String newValue) {
        this.myValue = newValue;
    }

    @Nullable
    public String getValue() {
        return this.myValue;
    }

    public boolean isContainer() {
        return this.myContainer;
    }

    @Nullable
    public String getShape() {
        return this.myShape;
    }

    public boolean isReturnedVal() {
        return this.myIsReturnedVal;
    }

    public boolean isIPythonHidden() {
        return this.myIsIPythonHidden;
    }

    public boolean isErrorOnEval() {
        return this.myErrorOnEval;
    }

    @Nullable
    public PyDebugValue getParent() {
        return this.myParent;
    }

    public void setParent(@Nullable PyDebugValue parent) {
        this.myParent = parent;
    }

    @Nullable
    public PyDebugValue getTopParent() {
        return this.myParent == null ? this : this.myParent.getTopParent();
    }

    public ValuesPolicy getLoadValuePolicy() {
        return this.myLoadValuePolicy;
    }

    public void setLoadValuePolicy(ValuesPolicy loadValueAsync) {
        this.myLoadValuePolicy = loadValueAsync;
    }

    @Nullable
    public XValueNode getLastNode() {
        return this.myLastNode;
    }

    @NotNull
    public String getEvaluationExpression() {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildExpression(stringBuilder);
        return this.wrapWithPrefix(stringBuilder.toString());
    }

    void buildExpression(@NotNull StringBuilder result) {
        if (result == null) {
            PyDebugValue.$$$reportNull$$$0(7);
        }
        if (this.myParent == null) {
            result.append(this.getTempName());
        } else {
            this.myParent.buildExpression(result);
            if (("dict".equals(this.myParent.getType()) || "list".equals(this.myParent.getType()) || "tuple".equals(this.myParent.getType())) && !PyDebugValue.isLen(this.myName)) {
                result.append('[').append(PyDebugValue.removeLeadingZeros(PyDebugValue.removeId(this.myName))).append(']');
            } else if (!"set".equals(this.myParent.getType()) || PyDebugValue.isLen(this.myName)) {
                if (PyDebugValue.isLen(this.myName)) {
                    result.append('.').append(this.myName).append("()");
                } else if (!"ndarray".equals(this.myParent.getType()) && !"matrix".equals(this.myParent.getType()) || !this.myName.equals("array")) {
                    if ("array".equals(this.myParent.getName()) && this.myParent.myParent != null && "ndarray".equals(this.myParent.myParent.getType())) {
                        result.append("[").append(PyDebugValue.removeLeadingZeros(this.myName)).append("]");
                    } else {
                        result.append('.').append(this.myName);
                    }
                }
            }
        }
    }

    @NotNull
    public String getFullName() {
        return this.wrapWithPrefix(this.getName());
    }

    @NotNull
    public String getVisibleName() {
        return PyDebugValue.removeId(this.myName);
    }

    @NotNull
    private static String removeId(@NotNull String name) {
        int lastInd;
        if (name == null) {
            PyDebugValue.$$$reportNull$$$0(8);
        }
        if (name.endsWith(")") && (lastInd = name.lastIndexOf(40)) != -1) {
            name = name.substring(0, lastInd).trim();
        }
        String string = name;
        if (string == null) {
            PyDebugValue.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String removeLeadingZeros(@NotNull String name) {
        if (name == null) {
            PyDebugValue.$$$reportNull$$$0(10);
        }
        while (name.length() > 1 && name.startsWith("0")) {
            name = name.substring(1);
        }
        String string = name;
        if (string == null) {
            PyDebugValue.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static boolean isLen(@NotNull String name) {
        if (name == null) {
            PyDebugValue.$$$reportNull$$$0(12);
        }
        return "__len__".equals(name);
    }

    @NotNull
    private String wrapWithPrefix(@NotNull String name) {
        if (name == null) {
            PyDebugValue.$$$reportNull$$$0(13);
        }
        if (this.isReturnedVal()) {
            String string = "__pydevd_ret_val_dict[\"" + name + "\"]";
            if (string == null) {
                PyDebugValue.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            PyDebugValue.$$$reportNull$$$0(15);
        }
        return string;
    }

    private String getTypeString() {
        if (this.myShape != null) {
            return this.myType + ": " + this.myShape;
        }
        return this.myType;
    }

    private void setElementPresentation(@NotNull XValueNode node, @NotNull String value) {
        if (node == null) {
            PyDebugValue.$$$reportNull$$$0(16);
        }
        if (value == null) {
            PyDebugValue.$$$reportNull$$$0(17);
        }
        if (this.myParent != null && "set".equals(this.myParent.getType())) {
            node.setPresentation(this.getValueIcon(), (XValuePresentation)new XRegularValuePresentation(value, this.getTypeString()){

                @NotNull
                public String getSeparator() {
                    return PyDebugValue.this.myName.equals("__len__") ? " = " : "";
                }

                public boolean isShowName() {
                    return PyDebugValue.this.myName.equals("__len__");
                }
            }, this.myContainer);
        } else {
            node.setPresentation(this.getValueIcon(), this.getTypeString(), value, this.myContainer);
        }
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            PyDebugValue.$$$reportNull$$$0(18);
        }
        if (place == null) {
            PyDebugValue.$$$reportNull$$$0(19);
        }
        String value = PyTypeHandler.format(this);
        this.setFullValueEvaluator(node, value);
        if (value.length() >= 256) {
            value = value.substring(0, 256);
        }
        value = this.applyRendererIfApplicable(value);
        this.setElementPresentation(node, value);
    }

    public void updateNodeValueAfterLoading(@NotNull XValueNode node, final @NotNull String value, final @NotNull String linkText, final @Nullable String errorMessage) {
        if (node == null) {
            PyDebugValue.$$$reportNull$$$0(20);
        }
        if (value == null) {
            PyDebugValue.$$$reportNull$$$0(21);
        }
        if (linkText == null) {
            PyDebugValue.$$$reportNull$$$0(22);
        }
        if (errorMessage != null) {
            node.setPresentation(this.getValueIcon(), (XValuePresentation)new XRegularValuePresentation(value, this.myType){

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    if (renderer == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    renderer.renderError(errorMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/python/debugger/PyDebugValue$2", "renderValue"));
                }
            }, this.myContainer);
        } else {
            this.setElementPresentation(node, value);
        }
        if (this.isNumericContainer()) {
            return;
        }
        if (value.length() >= 256) {
            node.setFullValueEvaluator((XFullValueEvaluator)new PyFullValueEvaluator(this.myFrameAccessor, this.getEvaluationExpression()));
        } else {
            node.setFullValueEvaluator(new XFullValueEvaluator(){

                public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                    if (callback == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    callback.evaluated(value);
                }

                public String getLinkText() {
                    return linkText;
                }

                public boolean isShowValuePopup() {
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/python/debugger/PyDebugValue$3", "startEvaluation"));
                }
            });
        }
    }

    @NotNull
    public PyDebugCallback<String> createDebugValueCallback() {
        return new PyDebugCallback<String>(){

            @Override
            public void ok(String value) {
                PyDebugValue.this.myLoadValuePolicy = ValuesPolicy.SYNC;
                PyDebugValue.this.myValue = value;
                XValueNode node = PyDebugValue.this.myLastNode;
                if (node != null && !node.isObsolete()) {
                    PyDebugValue.this.updateNodeValueAfterLoading(node, value, "", null);
                }
            }

            @Override
            public void error(PyDebuggerException exception) {
                LOG.error(exception.getMessage());
            }
        };
    }

    public boolean isNumericContainer() {
        return EVALUATOR_POSTFIXES.get(this.myType) != null;
    }

    @NotNull
    public static List<PyFrameAccessor.PyAsyncValue<String>> getAsyncValuesFromChildren(@NotNull XValueChildrenList childrenList) {
        if (childrenList == null) {
            PyDebugValue.$$$reportNull$$$0(23);
        }
        ArrayList<PyFrameAccessor.PyAsyncValue<String>> variables = new ArrayList<PyFrameAccessor.PyAsyncValue<String>>();
        for (int i = 0; i < childrenList.size(); ++i) {
            PyDebugValue debugValue;
            XValue value = childrenList.getValue(i);
            if (!(value instanceof PyDebugValue) || (debugValue = (PyDebugValue)value).getLoadValuePolicy() != ValuesPolicy.ASYNC) continue;
            variables.add(new PyFrameAccessor.PyAsyncValue<String>(debugValue, debugValue.createDebugValueCallback()));
        }
        ArrayList<PyFrameAccessor.PyAsyncValue<String>> arrayList = variables;
        if (arrayList == null) {
            PyDebugValue.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    public static void getAsyncValues(@NotNull PyFrameAccessor frameAccessor, @NotNull XValueChildrenList childrenList) {
        if (frameAccessor == null) {
            PyDebugValue.$$$reportNull$$$0(25);
        }
        if (childrenList == null) {
            PyDebugValue.$$$reportNull$$$0(26);
        }
        List<PyFrameAccessor.PyAsyncValue<String>> variables = PyDebugValue.getAsyncValuesFromChildren(childrenList);
        int chunkSize = Math.max(1, variables.size() / AVAILABLE_PROCESSORS);
        int left = 0;
        int right = Math.min(chunkSize, variables.size());
        while (left < variables.size()) {
            frameAccessor.loadAsyncVariablesValues(variables.subList(left, right));
            left = right;
            right = Math.min(right + chunkSize, variables.size());
        }
    }

    private void setFullValueEvaluator(@NotNull XValueNode node, @NotNull String value) {
        if (node == null) {
            PyDebugValue.$$$reportNull$$$0(27);
        }
        if (value == null) {
            PyDebugValue.$$$reportNull$$$0(28);
        }
        String treeName = this.getEvaluationExpression();
        String postfix = EVALUATOR_POSTFIXES.get(this.myType);
        this.myLastNode = node;
        if (postfix == null) {
            if (value.length() >= 256) {
                node.setFullValueEvaluator((XFullValueEvaluator)new PyFullValueEvaluator(this.myFrameAccessor, treeName));
            }
            if (this.myLoadValuePolicy == ValuesPolicy.ASYNC) {
                node.setFullValueEvaluator((XFullValueEvaluator)new PyLoadingValueEvaluator("... Loading Value", this.myFrameAccessor, treeName));
            } else if (this.myLoadValuePolicy == ValuesPolicy.ON_DEMAND) {
                node.setFullValueEvaluator((XFullValueEvaluator)new PyOnDemandValueEvaluator("Show Value", this.myFrameAccessor, this, node));
            }
            return;
        }
        String linkText = "...View as " + postfix;
        node.setFullValueEvaluator((XFullValueEvaluator)new PyNumericContainerValueEvaluator(linkText, this.myFrameAccessor, treeName));
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            PyDebugValue.$$$reportNull$$$0(29);
        }
        if (node.isObsolete()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                XValueChildrenList values = this.myFrameAccessor.loadVariable(this);
                this.restoreChildrenRenderers(values);
                if (!node.isObsolete()) {
                    this.updateLengthIfIsCollection(values);
                    if (this.isLargeCollection()) {
                        values = this.processLargeCollection(values);
                    }
                    if (this.myFrameAccessor.isSimplifiedView()) {
                        PyDebugValueGroupsKt.extractChildrenToGroup("Protected Attributes", AllIcons.Nodes.C_protected, node, values, (Function1<? super String, Boolean>)((Function1)name -> name.startsWith("_")), PyDebugValueGroupsKt.getPROTECTED_ATTRS_EXCLUDED());
                    } else {
                        node.addChildren(values, true);
                    }
                    if (this.isLargeCollection()) {
                        this.updateOffset(node, values);
                    }
                    PyDebugValue.getAsyncValues(this.myFrameAccessor, values);
                }
            }
            catch (PyDebuggerException e) {
                if (!node.isObsolete()) {
                    node.setErrorMessage("Unable to display children:" + e.getMessage());
                }
                LOG.warn((Throwable)e);
            }
        });
    }

    @NotNull
    public XValueModifier getModifier() {
        return new PyValueModifier(this.myFrameAccessor, this);
    }

    private Icon getValueIcon() {
        if (!this.myContainer) {
            return AllIcons.Debugger.Db_primitive;
        }
        if ("list".equals(this.myType) || "tuple".equals(this.myType)) {
            return AllIcons.Debugger.Db_array;
        }
        return AllIcons.Debugger.Value;
    }

    @Nullable
    public XReferrersProvider getReferrersProvider() {
        if (this.myFrameAccessor.getReferrersLoader() != null) {
            return new XReferrersProvider(){

                public XValue getReferringObjectsValue() {
                    return new PyReferringObjectsValue(PyDebugValue.this);
                }
            };
        }
        return null;
    }

    @NotNull
    public PyFrameAccessor getFrameAccessor() {
        PyFrameAccessor pyFrameAccessor = this.myFrameAccessor;
        if (pyFrameAccessor == null) {
            PyDebugValue.$$$reportNull$$$0(30);
        }
        return pyFrameAccessor;
    }

    public void setFrameAccessor(@NotNull PyFrameAccessor frameAccessor) {
        if (frameAccessor == null) {
            PyDebugValue.$$$reportNull$$$0(31);
        }
        this.myFrameAccessor = frameAccessor;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    public void setId(@Nullable String id) {
        this.myId = id;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            PyDebugValue.$$$reportNull$$$0(32);
        }
        if (this.myParent == null) {
            navigatable.setSourcePosition(this.myFrameAccessor.getSourcePositionForName(this.myName, null));
        } else {
            navigatable.setSourcePosition(this.myFrameAccessor.getSourcePositionForName(this.myName, this.myParent.getDeclaringType()));
        }
    }

    public boolean canNavigateToTypeSource() {
        return true;
    }

    public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            PyDebugValue.$$$reportNull$$$0(33);
        }
        String lookupType = this.getDeclaringType();
        navigatable.setSourcePosition(this.myFrameAccessor.getSourcePositionForType(lookupType));
    }

    @Nullable
    protected final String getDeclaringType() {
        Matcher matcher;
        String lookupType = this.getQualifiedType();
        if (!Strings.isNullOrEmpty((String)this.myValue) && (matcher = IS_TYPE_DECLARATION.matcher(this.myValue)).matches()) {
            lookupType = matcher.group("TYPE");
        }
        return lookupType;
    }

    @Nullable
    public String getQualifiedType() {
        if (Strings.isNullOrEmpty((String)this.myType)) {
            return null;
        }
        return this.myTypeQualifier == null ? this.myType : this.myTypeQualifier + "." + this.myType;
    }

    @Nullable
    public String getTypeQualifier() {
        return this.myTypeQualifier;
    }

    public boolean isTemporary() {
        return this.myTempName != null;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public void setOffset(int offset) {
        this.myOffset = offset;
    }

    private boolean isLargeCollection() {
        return this.myCollectionLength > 100;
    }

    private void updateLengthIfIsCollection(XValueChildrenList values) {
        if (this.myCollectionLength > 0 && values.size() == 0) {
            return;
        }
        int lastIndex = values.size() - 1;
        if (values.size() > 0 && PyDebugValue.isLen(values.getName(lastIndex))) {
            PyDebugValue len = (PyDebugValue)values.getValue(lastIndex);
            try {
                if (this.myCollectionLength == -1 && len.getValue() != null) {
                    this.myCollectionLength = Integer.parseInt(len.getValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private XValueChildrenList processLargeCollection(XValueChildrenList values) {
        if (values.size() > 0 && this.isLargeCollection() && this.myOffset + Math.min(100, values.size()) < this.myCollectionLength) {
            XValueChildrenList newValues = new XValueChildrenList();
            for (int i = 0; i < values.size() - 1; ++i) {
                newValues.add(values.getName(i), values.getValue(i));
            }
            return newValues;
        }
        return values;
    }

    private void updateOffset(XCompositeNode node, XValueChildrenList values) {
        if (this.myContainer && this.isLargeCollection()) {
            if (this.myOffset + Math.min(values.size(), 100) >= this.myCollectionLength) {
                this.myOffset = this.myCollectionLength;
            } else {
                node.tooManyChildren(this.myCollectionLength - Math.min(values.size(), 100) - this.myOffset);
                this.myOffset += Math.min(values.size(), 100);
            }
        }
    }

    @NotNull
    public PyDebugValueDescriptor getDescriptor() {
        PyDebugValueDescriptor pyDebugValueDescriptor = this.myDescriptor;
        if (pyDebugValueDescriptor == null) {
            PyDebugValue.$$$reportNull$$$0(34);
        }
        return pyDebugValueDescriptor;
    }

    public void setDescriptor(@NotNull PyDebugValueDescriptor descriptor2) {
        if (descriptor2 == null) {
            PyDebugValue.$$$reportNull$$$0(35);
        }
        this.myDescriptor = descriptor2;
    }

    private void restoreChildrenRenderers(XValueChildrenList values) {
        PyDebugValueDescriptor descriptor2 = this.getDescriptor();
        HashMap childrenDescriptors = descriptor2.getChildrenDescriptors();
        if (childrenDescriptors == null) {
            childrenDescriptors = Maps.newHashMap();
            descriptor2.setChildrenDescriptors(childrenDescriptors);
        }
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            if (!(values.getValue(i) instanceof PyDebugValue)) continue;
            PyDebugValue value = (PyDebugValue)values.getValue(i);
            descriptor2 = childrenDescriptors.getOrDefault(value.getName(), null);
            if (descriptor2 == null) {
                descriptor2 = new PyDebugValueDescriptor();
                childrenDescriptors.put(value.getName(), descriptor2);
            }
            value.setDescriptor(descriptor2);
        }
    }

    private String applyRendererIfApplicable(String value) {
        PyNodeRenderer renderer = this.getDescriptor().getRenderer();
        String type = this.getType();
        if (renderer == null || type == null) {
            return value;
        }
        if (renderer.isApplicable(type)) {
            return renderer.render(value);
        }
        this.getDescriptor().setRenderer(null);
        return value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 24: 
            case 30: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 24: 
            case 30: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAccessor";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 24: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyDebugValue";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenList";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyDebugValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLeadingZeros";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithPrefix";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncValuesFromChildren";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameAccessor";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeId";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 24: 
            case 30: 
            case 34: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeLeadingZeros";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isLen";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithPrefix";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setElementPresentation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeValueAfterLoading";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncValuesFromChildren";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncValues";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setFullValueEvaluator";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setFrameAccessor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePosition";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "computeTypeSourcePosition";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 24: 
            case 30: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ValuesPolicy {
        SYNC,
        ASYNC,
        ON_DEMAND;

    }
}

