/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugSessionFactory;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PydevDebugConsoleExecuteActionHandler;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.DebugAwareConfiguration;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugRunner
extends GenericProgramRunner {
    @NonNls
    public static final String PY_DEBUG_RUNNER = "PyDebugRunner";
    @NonNls
    public static final String DEBUGGER_MAIN = "pydev/pydevd.py";
    @NonNls
    public static final String CLIENT_PARAM = "--client";
    @NonNls
    public static final String PORT_PARAM = "--port";
    @NonNls
    public static final String FILE_PARAM = "--file";
    @NonNls
    public static final String MODULE_PARAM = "--module";
    @NonNls
    public static final String MULTIPROCESS_PARAM = "--multiprocess";
    @NonNls
    public static final String IDE_PROJECT_ROOTS = "IDE_PROJECT_ROOTS";
    @NonNls
    public static final String LIBRARY_ROOTS = "LIBRARY_ROOTS";
    @NonNls
    public static final String PYTHON_ASYNCIO_DEBUG = "PYTHONASYNCIODEBUG";
    @NonNls
    public static final String GEVENT_SUPPORT = "GEVENT_SUPPORT";
    @NonNls
    public static final String PYDEVD_FILTERS = "PYDEVD_FILTERS";
    @NonNls
    public static final String PYDEVD_FILTER_LIBRARIES = "PYDEVD_FILTER_LIBRARIES";
    @NonNls
    public static final String PYDEVD_USE_CYTHON = "PYDEVD_USE_CYTHON";
    @NonNls
    public static final String CYTHON_EXTENSIONS_DIR = new File(PathManager.getSystemPath(), "cythonExtensions").toString();

    @NotNull
    public String getRunnerId() {
        return PY_DEBUG_RUNNER;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PyDebugRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            PyDebugRunner.$$$reportNull$$$0(1);
        }
        if (!"Debug".equals(executorId)) {
            return false;
        }
        if (profile instanceof WrappingRunConfiguration) {
            return PyDebugRunner.isDebuggable((RunProfile)((WrappingRunConfiguration)profile).getPeer());
        }
        return PyDebugRunner.isDebuggable(profile);
    }

    private static boolean isDebuggable(@NotNull RunProfile profile) {
        if (profile == null) {
            PyDebugRunner.$$$reportNull$$$0(2);
        }
        if (profile instanceof DebugAwareConfiguration) {
            return ((DebugAwareConfiguration)profile).canRunUnderDebug();
        }
        return profile instanceof AbstractPythonRunConfiguration;
    }

    protected XDebugSession createSession(@NotNull RunProfileState state2, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state2 == null) {
            PyDebugRunner.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(4);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final PythonCommandLineState pyState = (PythonCommandLineState)state2;
        Sdk sdk = pyState.getSdk();
        PyDebugSessionFactory sessionCreator = PyDebugSessionFactory.findExtension(sdk);
        if (sessionCreator != null) {
            return sessionCreator.createSession(pyState, environment);
        }
        final ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
        int serverLocalPort = serverSocket.getLocalPort();
        RunProfile profile = environment.getRunProfile();
        final ExecutionResult result = pyState.execute(environment.getExecutor(), this.createCommandLinePatchers(environment.getProject(), pyState, profile, serverLocalPort));
        return XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                PyDebugProcess pyDebugProcess = PyDebugRunner.this.createDebugProcess(session, serverSocket, result, pyState);
                PyDebugRunner.createConsoleCommunicationAndSetupActions(environment.getProject(), result, pyDebugProcess, session);
                PyDebugProcess pyDebugProcess2 = pyDebugProcess;
                if (pyDebugProcess2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pyDebugProcess2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    protected PyDebugProcess createDebugProcess(@NotNull XDebugSession session, ServerSocket serverSocket, ExecutionResult result, PythonCommandLineState pyState) {
        if (session == null) {
            PyDebugRunner.$$$reportNull$$$0(5);
        }
        return new PyDebugProcess(session, serverSocket, result.getExecutionConsole(), result.getProcessHandler(), pyState.isMultiprocessDebug());
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state2, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state2 == null) {
            PyDebugRunner.$$$reportNull$$$0(6);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(7);
        }
        XDebugSession session = this.createSession(state2, environment);
        this.initSession(session, state2, environment.getExecutor());
        return session.getRunContentDescriptor();
    }

    protected void initSession(XDebugSession session, RunProfileState state2, Executor executor) {
    }

    public static int findIndex(List<String> paramList, String paramName) {
        for (int i = 0; i < paramList.size(); ++i) {
            if (!paramName.equals(paramList.get(i))) continue;
            return i + 1;
        }
        return -1;
    }

    public static void createConsoleCommunicationAndSetupActions(@NotNull Project project, @NotNull ExecutionResult result, @NotNull PyDebugProcess debugProcess, @NotNull XDebugSession session) {
        ExecutionConsole console;
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(8);
        }
        if (result == null) {
            PyDebugRunner.$$$reportNull$$$0(9);
        }
        if (debugProcess == null) {
            PyDebugRunner.$$$reportNull$$$0(10);
        }
        if (session == null) {
            PyDebugRunner.$$$reportNull$$$0(11);
        }
        if ((console = result.getExecutionConsole()) instanceof PythonDebugLanguageConsoleView) {
            ProcessHandler processHandler = result.getProcessHandler();
            PyDebugRunner.initDebugConsoleView(project, debugProcess, (PythonDebugLanguageConsoleView)console, processHandler, session);
        }
    }

    public static PythonDebugConsoleCommunication initDebugConsoleView(Project project, PyDebugProcess debugProcess, PythonDebugLanguageConsoleView console, ProcessHandler processHandler, final XDebugSession session) {
        PythonConsoleView pythonConsoleView = console.getPydevConsoleView();
        PythonDebugConsoleCommunication debugConsoleCommunication = new PythonDebugConsoleCommunication(project, debugProcess, pythonConsoleView);
        pythonConsoleView.setConsoleCommunication(debugConsoleCommunication);
        PydevDebugConsoleExecuteActionHandler consoleExecuteActionHandler = new PydevDebugConsoleExecuteActionHandler((LanguageConsoleView)pythonConsoleView, processHandler, debugConsoleCommunication);
        pythonConsoleView.setExecutionHandler(consoleExecuteActionHandler);
        debugProcess.getSession().addSessionListener((XDebugSessionListener)consoleExecuteActionHandler);
        new LanguageConsoleBuilder((LanguageConsoleView)pythonConsoleView).processHandler(processHandler).initActions((BaseConsoleExecuteActionHandler)consoleExecuteActionHandler, "py");
        debugConsoleCommunication.addCommunicationListener(new ConsoleCommunicationListener(){

            @Override
            public void commandExecuted(boolean more) {
                session.rebuildViews();
            }

            @Override
            public void inputRequested() {
            }
        });
        return debugConsoleCommunication;
    }

    @Nullable
    public static CommandLinePatcher createRunConfigPatcher(RunProfileState state2, RunProfile profile) {
        AbstractPythonRunConfiguration runConfigPatcher = null;
        if (state2 instanceof PythonCommandLineState && profile instanceof AbstractPythonRunConfiguration) {
            runConfigPatcher = (AbstractPythonRunConfiguration)profile;
        }
        return runConfigPatcher;
    }

    public CommandLinePatcher[] createCommandLinePatchers(Project project, PythonCommandLineState state2, RunProfile profile, int serverLocalPort) {
        return new CommandLinePatcher[]{this.createDebugServerPatcher(project, state2, serverLocalPort, profile), PyDebugRunner.createRunConfigPatcher((RunProfileState)state2, profile)};
    }

    public static boolean patchExeParams(ParametersList parametersList) {
        int moduleParamsIndex = parametersList.getParamsGroups().indexOf(parametersList.getParamsGroup("Module"));
        ParamsGroup oldModuleParams = parametersList.removeParamsGroup(moduleParamsIndex);
        if (oldModuleParams == null) {
            return false;
        }
        boolean isModule = false;
        ParamsGroup newModuleParams = new ParamsGroup("Module");
        for (String param : oldModuleParams.getParameters()) {
            if (!param.equals("-m")) {
                newModuleParams.addParameter(param);
                continue;
            }
            isModule = true;
        }
        parametersList.addParamsGroupAt(moduleParamsIndex, newModuleParams);
        return isModule;
    }

    private CommandLinePatcher createDebugServerPatcher(final Project project, final PythonCommandLineState pyState, final int serverLocalPort, final RunProfile profile) {
        return new CommandLinePatcher(){

            @Override
            public void patchCommandLine(GeneralCommandLine commandLine) {
                ParametersList parametersList = commandLine.getParametersList();
                @NotNull ParamsGroup debugParams = parametersList.getParamsGroup("Debugger");
                assert (debugParams != null);
                boolean isModule = PyDebugRunner.patchExeParams(parametersList);
                PyDebugRunner.this.fillDebugParameters(project, debugParams, serverLocalPort, pyState, commandLine, profile, isModule);
                @NotNull ParamsGroup exeParams = parametersList.getParamsGroup("Exe Options");
                PythonSdkFlavor flavor = pyState.getSdkFlavor();
                if (flavor != null) {
                    assert (exeParams != null);
                    for (String option : flavor.getExtraDebugOptions()) {
                        exeParams.addParameter(option);
                    }
                }
            }
        };
    }

    private void fillDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams, int serverLocalPort, @NotNull PythonCommandLineState pyState, @NotNull GeneralCommandLine cmd, @Nullable RunProfile runProfile, boolean isModule) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(12);
        }
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(13);
        }
        if (pyState == null) {
            PyDebugRunner.$$$reportNull$$$0(14);
        }
        if (cmd == null) {
            PyDebugRunner.$$$reportNull$$$0(15);
        }
        PythonHelper.DEBUGGER.addToGroup(debugParams, cmd);
        if (isModule) {
            debugParams.addParameter(MODULE_PARAM);
        }
        this.configureDebugParameters(project, debugParams, pyState, cmd);
        PyDebugRunner.configureDebugEnvironment(project, cmd.getEnvironment(), runProfile);
        PyDebugRunner.configureDebugConnectionParameters(debugParams, serverLocalPort);
    }

    public static void configureDebugEnvironment(@NotNull Project project, Map<String, String> environment, @Nullable RunProfile runProfile) {
        AbstractPythonRunConfiguration runConfiguration;
        PyDebuggerSettings debuggerSettings;
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(16);
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSupportGeventDebugging()) {
            environment.put(GEVENT_SUPPORT, "True");
        }
        if ((debuggerSettings = PyDebuggerSettings.getInstance()).isSteppingFiltersEnabled()) {
            environment.put(PYDEVD_FILTERS, debuggerSettings.getSteppingFiltersForProject(project));
        }
        if (debuggerSettings.isLibrariesFilterEnabled()) {
            environment.put(PYDEVD_FILTER_LIBRARIES, "True");
        }
        if (debuggerSettings.getValuesPolicy() != PyDebugValue.ValuesPolicy.SYNC) {
            environment.put(PyDebugValue.POLICY_ENV_VARS.get((Object)debuggerSettings.getValuesPolicy()), "True");
        }
        PydevConsoleRunnerFactory.putIPythonEnvFlag(project, environment);
        PythonEnvUtil.addToPythonPath(environment, CYTHON_EXTENSIONS_DIR);
        PyDebugRunner.addProjectRootsToEnv(project, environment);
        AbstractPythonRunConfiguration abstractPythonRunConfiguration = runConfiguration = runProfile instanceof AbstractPythonRunConfiguration ? (AbstractPythonRunConfiguration)runProfile : null;
        if (runConfiguration != null) {
            LanguageLevel langLevel;
            PythonSdkFlavor flavor;
            Sdk sdk = runConfiguration.getSdk();
            if (sdk != null && (flavor = PythonSdkFlavor.getFlavor(sdk)) != null && ((langLevel = flavor.getLanguageLevel(sdk)) == LanguageLevel.PYTHON34 || langLevel == LanguageLevel.PYTHON35)) {
                environment.put(PYDEVD_USE_CYTHON, "NO");
            }
            PyDebugRunner.addSdkRootsToEnv(environment, runConfiguration);
            PythonEnvUtil.addToPythonPath(environment, runConfiguration.getWorkingDirectorySafe());
        }
    }

    protected void configureDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams, @NotNull PythonCommandLineState pyState, @NotNull GeneralCommandLine cmd) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(17);
        }
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(18);
        }
        if (pyState == null) {
            PyDebugRunner.$$$reportNull$$$0(19);
        }
        if (cmd == null) {
            PyDebugRunner.$$$reportNull$$$0(20);
        }
        if (pyState.isMultiprocessDebug()) {
            debugParams.addParameter("--multiproc");
        }
        PyDebugRunner.configureCommonDebugParameters(project, debugParams);
    }

    public static void configureCommonDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(21);
        }
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(22);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            debugParams.addParameter("--DEBUG");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSaveCallSignatures()) {
            debugParams.addParameter("--save-signatures");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSupportQtDebugging()) {
            String pyQtBackend = StringUtil.toLowerCase((String)PyDebuggerOptionsProvider.getInstance(project).getPyQtBackend());
            debugParams.addParameter(String.format("--qt-support=%s", pyQtBackend));
        }
    }

    public static void disableBuiltinBreakpoint(@Nullable Sdk sdk, Map<String, String> env) {
        PythonSdkFlavor flavor;
        if (sdk != null && (flavor = PythonSdkFlavor.getFlavor(sdk)) != null && flavor.getLanguageLevel(sdk) == LanguageLevel.PYTHON37) {
            env.put("PYTHONBREAKPOINT", "0");
        }
    }

    private static void configureDebugConnectionParameters(@NotNull ParamsGroup debugParams, int serverLocalPort) {
        String[] debuggerArgs;
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(23);
        }
        for (String s : debuggerArgs = new String[]{CLIENT_PARAM, "127.0.0.1", PORT_PARAM, String.valueOf(serverLocalPort), FILE_PARAM}) {
            debugParams.addParameter(s);
        }
    }

    private static void addProjectRootsToEnv(@NotNull Project project, @NotNull Map<String, String> environment) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(24);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(25);
        }
        ArrayList roots = Lists.newArrayList();
        for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            roots.add(contentRoot.getPath());
        }
        environment.put(IDE_PROJECT_ROOTS, StringUtil.join((Collection)roots, (String)File.pathSeparator));
    }

    private static void addSdkRootsToEnv(@NotNull Map<String, String> environment, @NotNull AbstractPythonRunConfiguration runConfiguration) {
        Sdk sdk;
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(26);
        }
        if (runConfiguration == null) {
            PyDebugRunner.$$$reportNull$$$0(27);
        }
        if ((sdk = runConfiguration.getSdk()) != null) {
            ArrayList roots = Lists.newArrayList();
            for (VirtualFile contentRoot : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                roots.add(contentRoot.getPath());
            }
            environment.put(LIBRARY_ROOTS, StringUtil.join((Collection)roots, (String)File.pathSeparator));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 13: 
            case 18: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugParams";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyState";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDebuggable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createSession";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createDebugProcess";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createConsoleCommunicationAndSetupActions";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "fillDebugParameters";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "configureDebugEnvironment";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "configureDebugParameters";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "configureCommonDebugParameters";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "configureDebugConnectionParameters";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "addProjectRootsToEnv";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "addSdkRootsToEnv";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

