/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.testIntegration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testIntegration.TestCreator;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.testIntegration.CreateTestAction;
import com.jetbrains.python.codeInsight.testIntegration.PyTestCreationModel;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyTestCreator
implements TestCreator {
    private static final Logger LOG = Logger.getInstance(PyTestCreator.class);

    public boolean isAvailable(Project project, Editor editor2, PsiFile file) {
        CreateTestAction action = new CreateTestAction();
        PsiElement element = file.findElementAt(editor2.getCaretModel().getOffset());
        if (element != null) {
            return action.isAvailable(project, editor2, element);
        }
        return false;
    }

    public void createTest(Project project, Editor editor2, PsiFile file) {
        try {
            CreateTestAction action = new CreateTestAction();
            PsiElement element = file.findElementAt(editor2.getCaretModel().getOffset());
            if (element != null && action.isAvailable(project, editor2, element)) {
                action.invoke(project, editor2, file.getContainingFile());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.warn((Throwable)e);
        }
    }

    static PsiFile generateTestAndNavigate(@NotNull PsiElement anchor, @NotNull PyTestCreationModel creationModel) {
        if (anchor == null) {
            PyTestCreator.$$$reportNull$$$0(0);
        }
        if (creationModel == null) {
            PyTestCreator.$$$reportNull$$$0(1);
        }
        Project project = anchor.getProject();
        return (PsiFile)PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> (PsiFile)ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                PyElement testClass = PyTestCreator.generateTest(anchor, creationModel);
                testClass.navigate(false);
                return testClass.getContainingFile();
            }
            catch (IncorrectOperationException e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }));
    }

    @NotNull
    static PyElement generateTest(@NotNull PsiElement anchor, @NotNull PyTestCreationModel model) {
        if (anchor == null) {
            PyTestCreator.$$$reportNull$$$0(2);
        }
        if (model == null) {
            PyTestCreator.$$$reportNull$$$0(3);
        }
        Project project = anchor.getProject();
        IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
        String fileName = model.getFileName();
        if (!fileName.endsWith(".py")) {
            fileName = fileName + "." + PythonFileType.INSTANCE.getDefaultExtension();
        }
        PyFile psiFile = PyRefactoringUtil.getOrCreateFile(model.getTargetDir() + "/" + fileName, project);
        String className = model.getClassName();
        List<String> methods = model.getMethods();
        boolean classBased = !StringUtil.isEmptyOrSpaces((String)className);
        LanguageLevel level = LanguageLevel.forElement((PsiElement)psiFile);
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        PyElement result = psiFile;
        if (classBased) {
            boolean unitTestClassRequired = PythonUnitTestUtil.isTestCaseClassRequired(anchor);
            StringBuilder fileText = new StringBuilder();
            fileText.append("class ").append(className);
            if (unitTestClassRequired) {
                fileText.append("(TestCase)");
            } else if (LanguageLevel.forElement(anchor).isPython2()) {
                fileText.append("(object)");
            }
            fileText.append(":\n\t");
            if (methods.isEmpty()) {
                fileText.append("pass\n");
            }
            for (String method : methods) {
                fileText.append("def ").append(method).append("(self):\n\t");
                if (unitTestClassRequired) {
                    fileText.append("self.fail()");
                } else {
                    fileText.append("assert False");
                }
                fileText.append("\n\n\t");
            }
            if (unitTestClassRequired) {
                AddImportHelper.addOrUpdateFromImportStatement(psiFile, "unittest", "TestCase", null, AddImportHelper.ImportPriority.BUILTIN, null);
            }
            result = (PyElement)psiFile.addAfter((PsiElement)generator.createFromText(level, PyClass.class, fileText.toString()), psiFile.getLastChild());
        } else {
            for (String method : methods) {
                PyFunction fun = generator.createFromText(level, PyFunction.class, String.format("def %s():\n\tassert False\n\n", method));
                psiFile.addAfter(fun, psiFile.getLastChild());
            }
        }
        PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting(psiFile.getViewProvider());
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
        PyFile pyFile = result;
        if (pyFile == null) {
            PyTestCreator.$$$reportNull$$$0(4);
        }
        return pyFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creationModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/testIntegration/PyTestCreator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/testIntegration/PyTestCreator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateTestAndNavigate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateTest";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

