/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stdlib;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStdlibTypeProvider
extends PyTypeProviderBase {
    @NotNull
    private static final Set<String> OPEN_FUNCTIONS = ImmutableSet.of((Object)"os.fdopen", (Object)"posix.fdopen");

    @Nullable
    public static PyStdlibTypeProvider getInstance() {
        for (PyTypeProvider typeProvider : PyTypeProvider.EP_NAME.getExtensionList()) {
            if (!(typeProvider instanceof PyStdlibTypeProvider)) continue;
            return (PyStdlibTypeProvider)typeProvider;
        }
        return null;
    }

    @Override
    public Ref<PyType> getReferenceType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        PyType type;
        if (referenceTarget == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(1);
        }
        if ((type = PyStdlibTypeProvider.getBaseStringType(referenceTarget)) != null) {
            return Ref.create((Object)type);
        }
        type = PyStdlibTypeProvider.getEnumType(referenceTarget, context, anchor);
        if (type != null) {
            return Ref.create((Object)type);
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        if (referenceExpression == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(3);
        }
        if (!referenceExpression.isQualified()) {
            String name = referenceExpression.getReferencedName();
            if ("None".equals(name)) {
                return PyNoneType.INSTANCE;
            }
            if ("False".equals(name) || "True".equals(name)) {
                return PyBuiltinCache.getInstance((PsiElement)referenceExpression).getBoolType();
            }
        }
        return null;
    }

    @Nullable
    private static PyType getBaseStringType(@NotNull PsiElement referenceTarget) {
        if (referenceTarget == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(4);
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(referenceTarget);
        if (referenceTarget instanceof PyElement && builtinCache.isBuiltin(referenceTarget) && "basestring".equals(((PyElement)referenceTarget).getName())) {
            return builtinCache.getStrOrUnicodeType(true);
        }
        return null;
    }

    @Nullable
    private static PyType getEnumType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        PyTargetExpression target;
        ScopeOwner owner;
        if (referenceTarget == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(6);
        }
        if (referenceTarget instanceof PyTargetExpression && (owner = ScopeUtil.getScopeOwner(target = (PyTargetExpression)referenceTarget)) instanceof PyClass) {
            PyClass cls = (PyClass)owner;
            List types = cls.getAncestorTypes(context);
            for (PyClassLikeType type : types) {
                PyType classType;
                if (type == null || !"enum.Enum".equals(type.getClassQName()) || !((classType = context.getType(cls)) instanceof PyClassType)) continue;
                return ((PyClassType)classType).toInstance();
            }
        }
        if (referenceTarget instanceof PyQualifiedNameOwner) {
            PyQualifiedNameOwner qualifiedNameOwner = (PyQualifiedNameOwner)referenceTarget;
            String name = qualifiedNameOwner.getQualifiedName();
            if ("enum.Enum.name".equals(name)) {
                return PyBuiltinCache.getInstance(referenceTarget).getStrType();
            }
            if ("enum.Enum.value".equals(name) && anchor instanceof PyReferenceExpression && context.maySwitchToAST(anchor)) {
                PyExpression value;
                PyTargetExpression qualifierTarget;
                PyReferenceExpression qualifierExpr;
                PsiElement resolvedQualifier;
                PyReferenceExpression anchorExpr = (PyReferenceExpression)anchor;
                PyExpression qualifier = anchorExpr.getQualifier();
                if (qualifier instanceof PyReferenceExpression && (resolvedQualifier = (qualifierExpr = (PyReferenceExpression)qualifier).getReference().resolve()) instanceof PyTargetExpression && context.maySwitchToAST(qualifierTarget = (PyTargetExpression)resolvedQualifier) && (value = qualifierTarget.findAssignedValue()) != null) {
                    return context.getType(value);
                }
            } else if ("enum.EnumMeta.__members__".equals(name)) {
                return PyTypeParser.getTypeByName(referenceTarget, "dict[str, unknown]", context);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        String qname;
        if (function == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(7);
        }
        if (callSite == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(9);
        }
        if ((qname = function.getQualifiedName()) != null) {
            if (OPEN_FUNCTIONS.contains(qname) && callSite instanceof PyCallExpression) {
                return PyTypingTypeProvider.getOpenFunctionCallType(function, (PyCallExpression)callSite, LanguageLevel.forElement((PsiElement)callSite), context);
            }
            if ("tuple.__new__".equals(qname) && callSite instanceof PyCallExpression) {
                return PyStdlibTypeProvider.getTupleInitializationType((PyCallExpression)callSite, context);
            }
            if ("tuple.__add__".equals(qname) && callSite instanceof PyBinaryExpression) {
                return PyStdlibTypeProvider.getTupleConcatenationResultType((PyBinaryExpression)callSite, context);
            }
            if ("tuple.__mul__".equals(qname) && callSite instanceof PyBinaryExpression) {
                return PyStdlibTypeProvider.getTupleMultiplicationResultType((PyBinaryExpression)callSite, context);
            }
            if ("object.__new__".equals(qname) && callSite instanceof PyCallExpression) {
                PyExpression firstArgument = ((PyCallExpression)callSite).getArgument(0, PyExpression.class);
                PyClassLikeType classLikeType = PyUtil.as(firstArgument != null ? context.getType(firstArgument) : null, PyClassLikeType.class);
                return classLikeType != null ? Ref.create(classLikeType.toInstance()) : null;
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTupleMultiplicationResultType(@NotNull PyBinaryExpression multiplication, @NotNull TypeEvalContext context) {
        PsiElement target;
        PyTupleType leftTupleType;
        if (multiplication == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(11);
        }
        if ((leftTupleType = PyUtil.as(context.getType(multiplication.getLeftExpression()), PyTupleType.class)) == null) {
            return null;
        }
        PyExpression rightExpression = multiplication.getRightExpression();
        if (rightExpression instanceof PyReferenceExpression && (target = ((PyReferenceExpression)rightExpression).getReference().resolve()) instanceof PyTargetExpression) {
            rightExpression = ((PyTargetExpression)target).findAssignedValue();
        }
        if (rightExpression instanceof PyNumericLiteralExpression && ((PyNumericLiteralExpression)rightExpression).isIntegerLiteral()) {
            if (leftTupleType.isHomogeneous()) {
                return Ref.create((Object)leftTupleType);
            }
            int multiplier = ((PyNumericLiteralExpression)rightExpression).getBigIntegerValue().intValue();
            int originalSize = leftTupleType.getElementCount();
            if (originalSize * multiplier <= 20) {
                PyType[] elementTypes = new PyType[leftTupleType.getElementCount() * multiplier];
                for (int i = 0; i < multiplier; ++i) {
                    for (int j = 0; j < originalSize; ++j) {
                        elementTypes[i * originalSize + j] = leftTupleType.getElementType(j);
                    }
                }
                return Ref.create((Object)PyTupleType.create((PsiElement)multiplication, Arrays.asList(elementTypes)));
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTupleConcatenationResultType(@NotNull PyBinaryExpression addition, @NotNull TypeEvalContext context) {
        if (addition == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(12);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(13);
        }
        if (addition.getRightExpression() != null) {
            PyTupleType leftTupleType = PyUtil.as(context.getType(addition.getLeftExpression()), PyTupleType.class);
            PyTupleType rightTupleType = PyUtil.as(context.getType(addition.getRightExpression()), PyTupleType.class);
            if (leftTupleType != null && rightTupleType != null) {
                if (leftTupleType.isHomogeneous() || rightTupleType.isHomogeneous()) {
                    return null;
                }
                List newElementTypes = ContainerUtil.concat(leftTupleType.getElementTypes(), rightTupleType.getElementTypes());
                return Ref.create((Object)PyTupleType.create((PsiElement)addition, newElementTypes));
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTupleInitializationType(@NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        PyExpression[] arguments;
        if (call == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(14);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(15);
        }
        if ((arguments = call.getArguments()).length != 1) {
            return null;
        }
        PyExpression argument = arguments[0];
        PyType argumentType = context.getType(argument);
        if (argumentType instanceof PyTupleType) {
            return Ref.create((Object)argumentType);
        }
        if (argumentType instanceof PyCollectionType) {
            PyType iteratedItemType = ((PyCollectionType)argumentType).getIteratedItemType();
            return Ref.create((Object)PyTupleType.createHomogeneous((PsiElement)call, iteratedItemType));
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getContextManagerVariableType(@NotNull PyClass contextManager, @NotNull PyExpression withExpression, @NotNull TypeEvalContext context) {
        PyExpression closee;
        if (contextManager == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(16);
        }
        if (withExpression == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(18);
        }
        if ("contextlib.closing".equals(contextManager.getQualifiedName()) && withExpression instanceof PyCallExpression && (closee = ((PyCallExpression)withExpression).getArgument(0, PyExpression.class)) != null) {
            return context.getType(closee);
        }
        String name = contextManager.getName();
        if ("FileIO".equals(name) || "TextIOWrapper".equals(name) || "IOBase".equals(name) || "_IOBase".equals(name)) {
            return context.getType(withExpression);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiplication";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addition";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextManager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withExpression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceExpressionType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseStringType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getTupleMultiplicationResultType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getTupleConcatenationResultType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getTupleInitializationType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextManagerVariableType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

