/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.extensions.PsiFileSystemItemExtKt;
import com.jetbrains.python.codeInsight.intentions.PyConvertImportIntentionAction;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/codeInsight/intentions/PyRelativeToAbsoluteImportIntention;", "Lcom/jetbrains/python/codeInsight/intentions/PyConvertImportIntentionAction;", "()V", "doInvoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "intellij.python.community.impl"})
public final class PyRelativeToAbsoluteImportIntention
extends PyConvertImportIntentionAction {
    @Override
    public void doInvoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PyFromImportStatement pyFromImportStatement = this.findStatement(file, editor2);
        if (pyFromImportStatement == null) {
            return;
        }
        PyFromImportStatement statement = pyFromImportStatement;
        PsiFileSystemItem psiFileSystemItem = statement.resolveImportSource();
        if (psiFileSystemItem == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFileSystemItem, (String)"statement.resolveImportSource() ?: return");
        PsiFileSystemItem source = psiFileSystemItem;
        QualifiedName qName = PsiFileSystemItemExtKt.getQName(source);
        this.replaceImportStatement(statement, file, String.valueOf(qName));
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyFromImportStatement pyFromImportStatement = this.findStatement(file, editor2);
        if (pyFromImportStatement == null) {
            return false;
        }
        PyFromImportStatement statement = pyFromImportStatement;
        return statement.getRelativeLevel() > 0;
    }

    public PyRelativeToAbsoluteImportIntention() {
        super("INTN.convert.relative.to.absolute");
    }
}

