/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyGenerateDocstringIntention
extends PyBaseIntentionAction {
    private String myText;

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.doc.string.stub", new Object[0]);
        if (string == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PyFile) || file instanceof PyDocstringFile) {
            return false;
        }
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file, editor2.getCaretModel().getOffset());
        if (elementAt == null) {
            return false;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class);
        PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyStatementList.class, (boolean)false, (Class[])new Class[]{PyFunction.class});
        if (function == null || statementList != null) {
            return false;
        }
        if (!elementAt.equals(function.getNameNode())) {
            return false;
        }
        return this.isAvailableForFunction(function);
    }

    private boolean isAvailableForFunction(PyFunction function) {
        if (function.getDocStringValue() != null) {
            if (PyDocstringGenerator.forDocStringOwner(function).withInferredParameters(false).hasParametersToAdd()) {
                this.myText = PyBundle.message("INTN.add.parameters.to.docstring", new Object[0]);
                return true;
            }
            return false;
        }
        this.myText = PyBundle.message("INTN.doc.string.stub", new Object[0]);
        return true;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PsiElement elementAt;
        PyFunction function;
        if (project == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(3);
        }
        if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(elementAt = PyUtil.findNonWhitespaceAtOffset(file, editor2.getCaretModel().getOffset())), PyFunction.class)) == null) {
            return;
        }
        PyGenerateDocstringIntention.generateDocstring(function, editor2);
    }

    public static void generateDocstring(@NotNull PyDocStringOwner docStringOwner, @Nullable Editor editor2) {
        if (docStringOwner == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(4);
        }
        if (!PyGenerateDocstringIntention.ensureNotPlainDocstringFormat((PsiElement)docStringOwner)) {
            return;
        }
        PyDocstringGenerator docstringGenerator = PyDocstringGenerator.forDocStringOwner(docStringOwner).withInferredParameters(false).addFirstEmptyLine();
        PyStringLiteralExpression updated = docstringGenerator.buildAndInsert().getDocStringExpression();
        if (updated != null && editor2 != null) {
            int offset = updated.getTextOffset();
            editor2.getCaretModel().moveToOffset(offset);
            editor2.getCaretModel().moveCaretRelatively(0, 1, false, false, false);
        }
    }

    public static boolean ensureNotPlainDocstringFormat(@NotNull PsiElement anchor) {
        Module module;
        if (anchor == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(5);
        }
        if ((module = DocStringUtil.getModuleForElement(anchor)) == null) {
            return false;
        }
        return PyGenerateDocstringIntention.ensureNotPlainDocstringFormatForFile(anchor.getContainingFile(), module);
    }

    private static boolean ensureNotPlainDocstringFormatForFile(@NotNull PsiFile file, @NotNull Module module) {
        PyDocumentationSettings settings;
        if (file == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(6);
        }
        if (module == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(7);
        }
        if ((settings = PyDocumentationSettings.getInstance(module)).isPlain(file)) {
            List<String> values = DocStringFormat.ALL_NAMES_BUT_PLAIN;
            int i = MessagesService.getInstance().showChooseDialog(null, null, "Docstring format:", "Select Docstring Type", ArrayUtilRt.toStringArray(values), values.get(0), null);
            if (i < 0) {
                return false;
            }
            settings.setFormat(DocStringFormat.fromNameOrPlain(values.get(i)));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyGenerateDocstringIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docStringOwner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyGenerateDocstringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDocstring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureNotPlainDocstringFormat";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ensureNotPlainDocstringFormatForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

