/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class PyDictConstructorToLiteralFormIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.dict.constructor.to.dict.literal", new Object[0]);
        if (string == null) {
            PyDictConstructorToLiteralFormIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.dict.constructor.to.dict.literal", new Object[0]);
        if (string == null) {
            PyDictConstructorToLiteralFormIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        TypeEvalContext context;
        PyType type;
        if (project == null) {
            PyDictConstructorToLiteralFormIntention.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyCallExpression expression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyCallExpression.class);
        if (expression != null && expression.isCalleeText("dict") && (type = (context = TypeEvalContext.codeAnalysis(file.getProject(), file)).getType(expression)) != null && type.isBuiltin()) {
            PyExpression[] argumentList;
            for (PyExpression argument : argumentList = expression.getArguments()) {
                if (argument instanceof PyKeywordArgument) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PyDictConstructorToLiteralFormIntention.$$$reportNull$$$0(3);
        }
        PyCallExpression expression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyCallExpression.class);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (expression != null) {
            PyDictConstructorToLiteralFormIntention.replaceDictConstructor(expression, elementGenerator);
        }
    }

    private static void replaceDictConstructor(PyCallExpression expression, PyElementGenerator elementGenerator) {
        PyExpression[] argumentList = expression.getArguments();
        StringBuilder stringBuilder = new StringBuilder();
        int size = argumentList.length;
        for (int i = 0; i != size; ++i) {
            PyExpression argument = argumentList[i];
            if (!(argument instanceof PyKeywordArgument)) continue;
            stringBuilder.append("'");
            stringBuilder.append(((PyKeywordArgument)argument).getKeyword());
            stringBuilder.append("' : ");
            stringBuilder.append(((PyKeywordArgument)argument).getValueExpression().getText());
            if (i == size - 1) continue;
            stringBuilder.append(",");
        }
        PyDictLiteralExpression dict = (PyDictLiteralExpression)elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)expression), PyExpressionStatement.class, "{" + stringBuilder.toString() + "}").getExpression();
        expression.replace((PsiElement)dict);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyDictConstructorToLiteralFormIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyDictConstructorToLiteralFormIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

