/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.commandLine.psi;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.commandInterface.command.Argument;
import com.jetbrains.commandInterface.command.Command;
import com.jetbrains.commandInterface.command.Option;
import com.jetbrains.commandInterface.commandLine.ValidationResult;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineArgument;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineFile;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineOption;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ValidationResultImpl
extends CommandLineVisitor
implements ValidationResult {
    @NotNull
    private final Map<String, Option> myOptions;
    @NotNull
    private final Map<String, Option> myUnusedOptions;
    @NotNull
    private final Command myCommand;
    private int myCurrentPositionArgument;
    @Nullable
    private Pair<Option, Integer> myCurrentOptionAndArgsLeft;
    @NotNull
    private final Collection<PsiElement> myBadValues;
    @NotNull
    private final Collection<CommandLineArgument> myExcessArguments;
    @NotNull
    private final Map<CommandLineArgument, Option> myOptionArguments;
    @NotNull
    private final Map<CommandLineArgument, Argument> myArguments;

    private ValidationResultImpl(@NotNull Command command) {
        if (command == null) {
            ValidationResultImpl.$$$reportNull$$$0(0);
        }
        this.myOptions = new HashMap<String, Option>();
        this.myUnusedOptions = new HashMap<String, Option>();
        this.myBadValues = new ArrayList<PsiElement>();
        this.myExcessArguments = new ArrayList<CommandLineArgument>();
        this.myOptionArguments = new HashMap<CommandLineArgument, Option>();
        this.myArguments = new HashMap<CommandLineArgument, Argument>();
        for (Option option : command.getOptions()) {
            for (String optionName : option.getAllNames()) {
                this.myOptions.put(optionName, option);
            }
        }
        this.myUnusedOptions.putAll(this.myOptions);
        this.myCommand = command;
    }

    @Override
    public boolean isBadValue(@NotNull PsiElement element) {
        if (element == null) {
            ValidationResultImpl.$$$reportNull$$$0(1);
        }
        return this.myBadValues.contains(element);
    }

    @Override
    public boolean isExcessArgument(@NotNull CommandLineArgument argument) {
        if (argument == null) {
            ValidationResultImpl.$$$reportNull$$$0(2);
        }
        return this.myExcessArguments.contains(argument);
    }

    @Override
    @NotNull
    public Collection<Option> getUnusedOptions() {
        Collection<Option> collection = this.myUnusedOptions.values();
        if (collection == null) {
            ValidationResultImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @Nullable
    public Option getOptionForOptionArgument(@NotNull CommandLineArgument argument) {
        if (argument == null) {
            ValidationResultImpl.$$$reportNull$$$0(4);
        }
        return this.myOptionArguments.get(argument);
    }

    @Override
    @Nullable
    public Argument getArgument(@NotNull CommandLineArgument commandLineArgument) {
        if (commandLineArgument == null) {
            ValidationResultImpl.$$$reportNull$$$0(5);
        }
        return this.myArguments.get(commandLineArgument);
    }

    @Override
    @Nullable
    public Option getOption(@NotNull CommandLineOption option) {
        if (option == null) {
            ValidationResultImpl.$$$reportNull$$$0(6);
        }
        return this.myOptions.get(option.getOptionName());
    }

    @Nullable
    static ValidationResult create(CommandLineFile file) {
        Command command = file.findRealCommand();
        if (command == null) {
            return null;
        }
        ValidationResultImpl validationLayout = new ValidationResultImpl(command);
        file.acceptChildren(validationLayout);
        return validationLayout;
    }

    @Override
    public void visitArgument(@NotNull CommandLineArgument o) {
        if (o == null) {
            ValidationResultImpl.$$$reportNull$$$0(7);
        }
        super.visitArgument(o);
        if (this.myCurrentOptionAndArgsLeft != null) {
            this.processOptionArgument(o);
            return;
        }
        this.processPositionalArgument(o);
    }

    private void processPositionalArgument(@NotNull CommandLineArgument o) {
        Pair<Boolean, Argument> argumentPair;
        if (o == null) {
            ValidationResultImpl.$$$reportNull$$$0(8);
        }
        if ((argumentPair = this.myCommand.getArgumentsInfo().getArgument(this.myCurrentPositionArgument++)) == null) {
            this.myExcessArguments.add(o);
        } else {
            this.processArgument(o, (Argument)argumentPair.second);
        }
    }

    private void processOptionArgument(@NotNull CommandLineArgument o) {
        if (o == null) {
            ValidationResultImpl.$$$reportNull$$$0(9);
        }
        assert (this.myCurrentOptionAndArgsLeft != null) : "Method can't be called if no current option exist";
        if ((Integer)this.myCurrentOptionAndArgsLeft.second > 0) {
            this.myCurrentOptionAndArgsLeft = Pair.create((Object)this.myCurrentOptionAndArgsLeft.first, (Object)((Integer)this.myCurrentOptionAndArgsLeft.second - 1));
            Pair<Integer, Argument> argumentAndQuantity = ((Option)this.myCurrentOptionAndArgsLeft.first).getArgumentAndQuantity();
            assert (argumentAndQuantity != null) : "Option has arguments left but no argument info";
            Argument argumentInfo = (Argument)argumentAndQuantity.getSecond();
            this.processArgument(o, argumentInfo);
            this.myOptionArguments.put(o, (Option)this.myCurrentOptionAndArgsLeft.first);
        } else if ((Integer)this.myCurrentOptionAndArgsLeft.second == 0) {
            this.myCurrentOptionAndArgsLeft = null;
            this.myExcessArguments.add(o);
        }
    }

    private void processArgument(@NotNull CommandLineArgument o, Argument argumentInfo) {
        if (o == null) {
            ValidationResultImpl.$$$reportNull$$$0(10);
        }
        this.myArguments.put(o, argumentInfo);
        if (!argumentInfo.isValid(o.getText())) {
            this.myBadValues.add(o);
        }
    }

    public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
        if (space == null) {
            ValidationResultImpl.$$$reportNull$$$0(11);
        }
        super.visitWhiteSpace(space);
        if (this.myCurrentOptionAndArgsLeft != null && (Integer)this.myCurrentOptionAndArgsLeft.second == 0) {
            this.myCurrentOptionAndArgsLeft = null;
        }
    }

    @Override
    public void visitOption(@NotNull CommandLineOption o) {
        if (o == null) {
            ValidationResultImpl.$$$reportNull$$$0(12);
        }
        super.visitOption(o);
        if (this.myUnusedOptions.containsKey(o.getOptionName())) {
            Option option = this.myUnusedOptions.remove(o.getOptionName());
            for (String optionName : option.getAllNames()) {
                this.myUnusedOptions.remove(optionName);
            }
            Pair<Integer, Argument> argumentAndQuantity = option.getArgumentAndQuantity();
            this.myCurrentOptionAndArgsLeft = argumentAndQuantity != null ? Pair.create((Object)option, (Object)argumentAndQuantity.first) : new Pair((Object)option, (Object)0);
        } else {
            this.myBadValues.add(o);
        }
    }

    @Override
    @Nullable
    public Pair<Boolean, Argument> getNextArg() {
        Pair<Integer, Argument> argumentAndQuantity;
        if (this.myCurrentOptionAndArgsLeft != null && (Integer)this.myCurrentOptionAndArgsLeft.second > 0 && (argumentAndQuantity = ((Option)this.myCurrentOptionAndArgsLeft.first).getArgumentAndQuantity()) != null) {
            return Pair.create((Object)true, (Object)argumentAndQuantity.second);
        }
        return this.myCommand.getArgumentsInfo().getArgument(this.myCurrentPositionArgument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/commandInterface/commandLine/psi/ValidationResultImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArgument";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "space";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/commandInterface/commandLine/psi/ValidationResultImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isBadValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isExcessArgument";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOptionForOptionArgument";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getArgument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitArgument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processPositionalArgument";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processOptionArgument";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processArgument";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitWhiteSpace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

