/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.javafx;

import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.ui.javafx.JavaFxHtmlPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.intellij.plugins.markdown.ui.preview.javafx.ImageRefreshFix;
import org.intellij.plugins.markdown.ui.preview.javafx.SafeOpener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownJavaFxHtmlPanel
extends JavaFxHtmlPanel
implements MarkdownHtmlPanel {
    private static final NotNullLazyValue<String> MY_SCRIPTING_LINES = new NotNullLazyValue<String>(){

        @NotNull
        protected String compute() {
            String string = MarkdownHtmlPanel.SCRIPTS.stream().map(s -> "<script src=\"" + PreviewStaticServer.getScriptUrl(s) + "\"></script>").reduce((s, s2) -> s + "\n" + s2).orElseGet(String::new);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/javafx/MarkdownJavaFxHtmlPanel$1", "compute"));
        }
    };
    private String @NotNull [] myCssUris = ArrayUtilRt.EMPTY_STRING_ARRAY;
    @NotNull
    private String myCSP = "";
    @NotNull
    private String myLastRawHtml = "";
    @NotNull
    private final ScrollPreservingListener myScrollPreservingListener = new ScrollPreservingListener();
    @NotNull
    private final BridgeSettingListener myBridgeSettingListener = new BridgeSettingListener();

    public MarkdownJavaFxHtmlPanel() {
        this.runInPlatformWhenAvailable(() -> {
            if (this.myWebView != null) {
                MarkdownJavaFxHtmlPanel.updateFontSmoothingType(this.myWebView, MarkdownApplicationSettings.getInstance().getMarkdownPreviewSettings().isUseGrayscaleRendering());
            }
        });
        this.subscribeForGrayscaleSetting();
    }

    protected void registerListeners(@NotNull WebEngine engine) {
        if (engine == null) {
            MarkdownJavaFxHtmlPanel.$$$reportNull$$$0(0);
        }
        engine.getLoadWorker().stateProperty().addListener((ChangeListener)this.myBridgeSettingListener);
        engine.getLoadWorker().stateProperty().addListener((ChangeListener)this.myScrollPreservingListener);
    }

    private void subscribeForGrayscaleSetting() {
        MessageBusConnection settingsConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        MarkdownApplicationSettings.SettingsChangedListener settingsChangedListener = new MarkdownApplicationSettings.SettingsChangedListener(){

            @Override
            public void beforeSettingsChanged(@NotNull MarkdownApplicationSettings settings) {
                if (settings == null) {
                    2.$$$reportNull$$$0(0);
                }
                MarkdownJavaFxHtmlPanel.this.runInPlatformWhenAvailable(() -> {
                    if (MarkdownJavaFxHtmlPanel.this.myWebView != null) {
                        MarkdownJavaFxHtmlPanel.updateFontSmoothingType(MarkdownJavaFxHtmlPanel.this.myWebView, settings.getMarkdownPreviewSettings().isUseGrayscaleRendering());
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/intellij/plugins/markdown/ui/preview/javafx/MarkdownJavaFxHtmlPanel$2", "beforeSettingsChanged"));
            }
        };
        settingsConnection.subscribe(MarkdownApplicationSettings.SettingsChangedListener.TOPIC, (Object)settingsChangedListener);
    }

    private static void updateFontSmoothingType(@NotNull WebView view, boolean isGrayscale) {
        if (view == null) {
            MarkdownJavaFxHtmlPanel.$$$reportNull$$$0(1);
        }
        FontSmoothingType typeToSet = isGrayscale ? FontSmoothingType.GRAY : FontSmoothingType.LCD;
        view.fontSmoothingTypeProperty().setValue((Object)typeToSet);
    }

    @Override
    public void setHtml(@NotNull String html) {
        if (html == null) {
            MarkdownJavaFxHtmlPanel.$$$reportNull$$$0(2);
        }
        this.myLastRawHtml = html;
        super.setHtml(html);
    }

    @NotNull
    protected String prepareHtml(@NotNull String html) {
        if (html == null) {
            MarkdownJavaFxHtmlPanel.$$$reportNull$$$0(3);
        }
        String string = ImageRefreshFix.setStamps(html.replace("<head>", "<head><meta http-equiv=\"Content-Security-Policy\" content=\"" + this.myCSP + "\"/>" + MarkdownHtmlPanel.getCssLines(null, this.myCssUris) + "\n" + MarkdownJavaFxHtmlPanel.getScriptingLines()));
        if (string == null) {
            MarkdownJavaFxHtmlPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void setCSS(@Nullable String inlineCss, String ... fileUris) {
        if (fileUris == null) {
            MarkdownJavaFxHtmlPanel.$$$reportNull$$$0(5);
        }
        PreviewStaticServer.getInstance().setInlineStyle(inlineCss);
        this.myCssUris = inlineCss == null ? fileUris : ArrayUtil.mergeArrays((String[])fileUris, (String[])new String[]{PreviewStaticServer.getStyleUrl("inline.css")});
        this.myCSP = PreviewStaticServer.createCSP(ContainerUtil.map((Collection)SCRIPTS, s -> PreviewStaticServer.getScriptUrl(s)), ContainerUtil.concat((List)ContainerUtil.map((Collection)STYLES, s -> PreviewStaticServer.getStyleUrl(s)), (List)ContainerUtil.filter((Object[])fileUris, s -> s.startsWith("http://") || s.startsWith("https://"))));
        this.setHtml(this.myLastRawHtml);
    }

    @Override
    public void scrollToMarkdownSrcOffset(int offset) {
        this.runInPlatformWhenAvailable(() -> {
            this.getWebViewGuaranteed().getEngine().executeScript("if ('__IntelliJTools' in window) __IntelliJTools.scrollToOffset(" + offset + ", '" + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "');");
            Object result = this.getWebViewGuaranteed().getEngine().executeScript("document.documentElement.scrollTop || (document.body && document.body.scrollTop)");
            if (result instanceof Number) {
                this.myScrollPreservingListener.myScrollY = ((Number)result).intValue();
            }
        });
    }

    public void dispose() {
        this.runInPlatformWhenAvailable(() -> {
            this.getWebViewGuaranteed().getEngine().getLoadWorker().stateProperty().removeListener((ChangeListener)this.myScrollPreservingListener);
            this.getWebViewGuaranteed().getEngine().getLoadWorker().stateProperty().removeListener((ChangeListener)this.myBridgeSettingListener);
        });
    }

    @NotNull
    private static String getScriptingLines() {
        String string = (String)MY_SCRIPTING_LINES.getValue();
        if (string == null) {
            MarkdownJavaFxHtmlPanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/javafx/MarkdownJavaFxHtmlPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUris";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/javafx/MarkdownJavaFxHtmlPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHtml";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptingLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerListeners";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateFontSmoothingType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setHtml";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareHtml";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCSS";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ScrollPreservingListener
    implements ChangeListener<Worker.State> {
        volatile int myScrollY = 0;

        private ScrollPreservingListener() {
        }

        public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
            if (newValue == Worker.State.RUNNING) {
                Object result = MarkdownJavaFxHtmlPanel.this.getWebViewGuaranteed().getEngine().executeScript("document.documentElement.scrollTop || document.body.scrollTop");
                if (result instanceof Number) {
                    this.myScrollY = ((Number)result).intValue();
                }
            } else if (newValue == Worker.State.SUCCEEDED) {
                MarkdownJavaFxHtmlPanel.this.getWebViewGuaranteed().getEngine().executeScript("document.documentElement.scrollTop = ({} || document.body).scrollTop = " + this.myScrollY);
            }
        }
    }

    private class BridgeSettingListener
    implements ChangeListener<Worker.State> {
        private BridgeSettingListener() {
        }

        public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
            JSObject win = (JSObject)MarkdownJavaFxHtmlPanel.this.getWebViewGuaranteed().getEngine().executeScript("window");
            win.setMember("JavaPanelBridge", JavaPanelBridge.INSTANCE);
        }
    }

    public static class JavaPanelBridge {
        static final JavaPanelBridge INSTANCE = new JavaPanelBridge();
        private static final NotificationGroup MARKDOWN_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)MarkdownBundle.message("markdown.navigate.to.header.group", new Object[0]), (String)"Messages");

        public void openInExternalBrowser(@NotNull String link) {
            if (link == null) {
                JavaPanelBridge.$$$reportNull$$$0(0);
            }
            SafeOpener.openLink(link);
        }

        public void log(@Nullable String text) {
            Logger.getInstance(JavaPanelBridge.class).warn(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "org/intellij/plugins/markdown/ui/preview/javafx/MarkdownJavaFxHtmlPanel$JavaPanelBridge", "openInExternalBrowser"));
        }
    }
}

