/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.markdown.injection.LanguageGuesser;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceContentImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFenceInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            CodeFenceInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CodeFenceInjector.$$$reportNull$$$0(1);
        }
        if (!(context instanceof MarkdownCodeFenceImpl)) {
            return;
        }
        if (PsiTreeUtil.findChildOfType((PsiElement)context, MarkdownCodeFenceContentImpl.class) == null) {
            return;
        }
        Language language = this.findLangForInjection((MarkdownCodeFenceImpl)context);
        if (language == null || LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            return;
        }
        registrar.startInjecting(language);
        for (PsiElement child = context.getFirstChild().getNextSibling().getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child.getNode().getElementType() == MarkdownTokenTypes.EOL) {
                registrar.addPlace(null, null, (PsiLanguageInjectionHost)((MarkdownCodeFenceImpl)context), TextRange.from((int)child.getStartOffsetInParent(), (int)1));
                continue;
            }
            if (!(child instanceof MarkdownCodeFenceContentImpl)) continue;
            PsiElement nextSibling = child.getNextSibling();
            boolean includeNewLine = nextSibling != null && nextSibling.getNode().getElementType() == MarkdownTokenTypes.EOL;
            registrar.addPlace(null, null, (PsiLanguageInjectionHost)((MarkdownCodeFenceImpl)context), TextRange.from((int)child.getStartOffsetInParent(), (int)(includeNewLine ? child.getTextLength() + 1 : child.getTextLength())));
            if (!includeNewLine) continue;
            child = nextSibling;
        }
        registrar.doneInjecting();
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<MarkdownCodeFenceImpl>> list = Collections.singletonList(MarkdownCodeFenceImpl.class);
        if (list == null) {
            CodeFenceInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    protected Language findLangForInjection(@NotNull MarkdownCodeFenceImpl element) {
        String fenceLanguage;
        if (element == null) {
            CodeFenceInjector.$$$reportNull$$$0(3);
        }
        if ((fenceLanguage = element.getFenceLanguage()) == null) {
            return null;
        }
        return CodeFenceInjector.guessLanguageByFenceLang(fenceLanguage);
    }

    @Nullable
    private static Language guessLanguageByFenceLang(@NotNull String langName) {
        if (langName == null) {
            CodeFenceInjector.$$$reportNull$$$0(4);
        }
        if (MarkdownApplicationSettings.getInstance().isDisableInjections()) {
            return null;
        }
        return LanguageGuesser.INSTANCE.guessLanguage(langName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/injection/CodeFenceInjector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/injection/CodeFenceInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findLangForInjection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "guessLanguageByFenceLang";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

