/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import javax.annotation.Nonnull;
import org.fest.swing.core.MouseButton;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public final class MouseClickInfo {
    private final MouseButton button;
    private int times;

    @Nonnull
    public static MouseClickInfo leftButton() {
        return MouseClickInfo.button(MouseButton.LEFT_BUTTON);
    }

    @Nonnull
    public static MouseClickInfo middleButton() {
        return MouseClickInfo.button(MouseButton.MIDDLE_BUTTON);
    }

    @Nonnull
    public static MouseClickInfo rightButton() {
        return MouseClickInfo.button(MouseButton.RIGHT_BUTTON);
    }

    @Nonnull
    public static MouseClickInfo button(@Nonnull MouseButton button) {
        return new MouseClickInfo(button, 1);
    }

    private MouseClickInfo(@Nonnull MouseButton button, int times) {
        this.button = (MouseButton)((Object)Preconditions.checkNotNull((Object)((Object)button)));
        this.times = times;
    }

    @Nonnull
    public MouseButton button() {
        return this.button;
    }

    public int times() {
        return this.times;
    }

    public MouseClickInfo times(int newTimes) {
        this.times = newTimes;
        return this;
    }

    @Nonnull
    public String toString() {
        return Strings.concat((Object[])new Object[]{String.format("%s[button=%s, times=%d]", this.getClass().getName(), this.button.toString(), this.times)});
    }
}

