/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.eventLog.validator.persistence.BaseEventLogWhitelistPersistence;
import com.intellij.internal.statistic.service.fus.EventLogWhitelistParseException;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogTestWhitelistPersistence
extends BaseEventLogWhitelistPersistence {
    private static final Logger LOG = Logger.getInstance(EventLogTestWhitelistPersistence.class);
    private static final String TEST_RULE = "{util#fus_test_mode}";
    public static final String TEST_WHITE_LIST_DATA_FILE = "test-white-list.json";
    @NotNull
    private final String myRecorderId;

    public EventLogTestWhitelistPersistence(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(0);
        }
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public String getCachedWhitelist() {
        try {
            File file = this.getWhitelistFile();
            if (file.exists()) {
                return FileUtil.loadFile((File)file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    public void cleanup() {
        try {
            FileUtil.delete((File)this.getWhitelistFile());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void addGroupWithCustomRules(@NotNull String recorderId, @NotNull String groupId, @NotNull String rules) throws IOException {
        if (recorderId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(1);
        }
        if (groupId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(2);
        }
        if (rules == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(3);
        }
        FUStatisticsWhiteListGroupsService.WLGroup newGroup = EventLogTestWhitelistPersistence.createGroupWithCustomRules(groupId, rules);
        EventLogTestWhitelistPersistence.addNewGroup(recorderId, newGroup);
    }

    @NotNull
    public static FUStatisticsWhiteListGroupsService.WLGroup createGroupWithCustomRules(@NotNull String groupId, @NotNull String rules) {
        if (groupId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(4);
        }
        if (rules == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(5);
        }
        String content = "{\"id\":\"" + groupId + "\",\"versions\":[ {\"from\" : \"1\"}],\"rules\":" + rules + "}";
        FUStatisticsWhiteListGroupsService.WLGroup wLGroup = (FUStatisticsWhiteListGroupsService.WLGroup)new GsonBuilder().create().fromJson(content, FUStatisticsWhiteListGroupsService.WLGroup.class);
        if (wLGroup == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(6);
        }
        return wLGroup;
    }

    public static void addTestGroup(@NotNull String recorderId, @NotNull String groupId) throws IOException {
        if (recorderId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(7);
        }
        if (groupId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(8);
        }
        FUStatisticsWhiteListGroupsService.WLGroup group = EventLogTestWhitelistPersistence.createTestGroup(groupId, Collections.emptySet());
        EventLogTestWhitelistPersistence.addNewGroup(recorderId, group);
    }

    private static void addNewGroup(@NotNull String recorderId, @NotNull FUStatisticsWhiteListGroupsService.WLGroup group) throws IOException {
        if (recorderId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(9);
        }
        if (group == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(10);
        }
        EventLogTestWhitelistPersistence persistence = new EventLogTestWhitelistPersistence(recorderId);
        FUStatisticsWhiteListGroupsService.WLGroups whitelist = EventLogTestWhitelistPersistence.loadTestWhitelist(persistence);
        EventLogTestWhitelistPersistence.saveNewGroup(group, whitelist, persistence.getWhitelistFile());
    }

    public static void saveNewGroup(@NotNull FUStatisticsWhiteListGroupsService.WLGroup group, @NotNull FUStatisticsWhiteListGroupsService.WLGroups whitelist, @NotNull File file) throws IOException {
        if (group == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(11);
        }
        if (whitelist == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(12);
        }
        if (file == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(13);
        }
        whitelist.groups.stream().filter(g -> StringUtil.equals((CharSequence)g.id, (CharSequence)group.id)).findFirst().ifPresent(whitelist.groups::remove);
        whitelist.groups.add(group);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileUtil.writeToFile((File)file, (String)gson.toJson((Object)whitelist));
    }

    @NotNull
    public static FUStatisticsWhiteListGroupsService.WLGroups loadTestWhitelist(@NotNull BaseEventLogWhitelistPersistence persistence) {
        String existing;
        if (persistence == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(14);
        }
        if (StringUtil.isNotEmpty((String)(existing = persistence.getCachedWhitelist()))) {
            FUStatisticsWhiteListGroupsService.WLGroups wLGroups;
            try {
                wLGroups = FUStatisticsWhiteListGroupsService.parseWhiteListContent((String)existing);
            }
            catch (EventLogWhitelistParseException e) {
                LOG.warn("Failed parsing test whitelist", (Throwable)e);
            }
            if (wLGroups == null) {
                EventLogTestWhitelistPersistence.$$$reportNull$$$0(15);
            }
            return wLGroups;
        }
        return new FUStatisticsWhiteListGroupsService.WLGroups();
    }

    @NotNull
    public static FUStatisticsWhiteListGroupsService.WLGroup createTestGroup(@NotNull String groupId, @NotNull Set<String> eventData) {
        if (groupId == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(16);
        }
        if (eventData == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(17);
        }
        FUStatisticsWhiteListGroupsService.WLGroup group = new FUStatisticsWhiteListGroupsService.WLGroup();
        group.id = groupId;
        if (group.versions != null) {
            group.versions.add(new FUStatisticsWhiteListGroupsService.WLVersion("1", null));
        }
        FUStatisticsWhiteListGroupsService.WLRule rule = new FUStatisticsWhiteListGroupsService.WLRule();
        rule.event_id = ContainerUtil.newHashSet((Object[])new String[]{TEST_RULE});
        HashMap<String, HashSet> dataRules = new HashMap<String, HashSet>();
        for (String datum : eventData) {
            dataRules.put(datum, ContainerUtil.newHashSet((Object[])new String[]{TEST_RULE}));
        }
        rule.event_data = dataRules;
        group.rules = rule;
        FUStatisticsWhiteListGroupsService.WLGroup wLGroup = group;
        if (wLGroup == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(18);
        }
        return wLGroup;
    }

    @NotNull
    public File getWhitelistFile() throws IOException {
        File file = EventLogTestWhitelistPersistence.getDefaultWhitelistFile(this.myRecorderId, TEST_WHITE_LIST_DATA_FILE);
        if (file == null) {
            EventLogTestWhitelistPersistence.$$$reportNull$$$0(19);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/persistence/EventLogTestWhitelistPersistence";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whitelist";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/persistence/EventLogTestWhitelistPersistence";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupWithCustomRules";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTestWhitelist";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestGroup";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitelistFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addGroupWithCustomRules";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGroupWithCustomRules";
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTestGroup";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addNewGroup";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveNewGroup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadTestWhitelist";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createTestGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

