/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.MathUtil;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\f\u0010\u001c\u001a\u00020\u000b*\u00020\u0007H\u0002J\f\u0010\u001d\u001a\u00020\u0007*\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u0007*\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SALT_PREFERENCE_KEY", "", "anonymizedCache", "Ljava/util/HashMap;", "bucket", "", "getBucket", "()I", "build", "getBuild", "()Ljava/lang/String;", "build$delegate", "Lkotlin/Lazy;", "deviceId", "getDeviceId", "salt", "", "sessionId", "getSessionId", "anonymize", "data", "getOrGenerateSalt", "asBucket", "asBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "shortedUUID", "intellij.platform.statistics"})
public final class EventLogConfiguration {
    private static final Logger LOG;
    private static final String SALT_PREFERENCE_KEY = "feature_usage_event_log_salt";
    @NotNull
    private static final String sessionId;
    @NotNull
    private static final String deviceId;
    private static final int bucket;
    @NotNull
    private static final Lazy build$delegate;
    private static final byte[] salt;
    private static final HashMap<String, String> anonymizedCache;
    public static final EventLogConfiguration INSTANCE;

    @NotNull
    public final String getSessionId() {
        return sessionId;
    }

    @NotNull
    public final String getDeviceId() {
        return deviceId;
    }

    public final int getBucket() {
        return bucket;
    }

    @NotNull
    public final String getBuild() {
        Lazy lazy = build$delegate;
        EventLogConfiguration eventLogConfiguration = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String anonymize(@NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        if (anonymizedCache.containsKey(data)) {
            String string = anonymizedCache.get(data);
            if (string == null) {
                string = "";
            }
            return string;
        }
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putBytes(salt);
        hasher.putString((CharSequence)data, Charsets.UTF_8);
        String string = hasher.hash().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hasher.hash().toString()");
        String result = string;
        ((Map)anonymizedCache).put(data, result);
        return result;
    }

    private final String shortedUUID(@NotNull String $this$shortedUUID) {
        int start = StringsKt.lastIndexOf$default((CharSequence)$this$shortedUUID, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (start > 0 && start + 1 < $this$shortedUUID.length()) {
            String string = $this$shortedUUID;
            int n = start + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return $this$shortedUUID;
    }

    private final String asBuildNumber(@NotNull BuildNumber $this$asBuildNumber) {
        String string = $this$asBuildNumber.asStringWithoutProductCodeAndSnapshot();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.asStringWithoutProductCodeAndSnapshot()");
        String str = string;
        return StringsKt.endsWith$default((String)str, (String)".", (boolean)false, (int)2, null) ? str + "0" : str;
    }

    private final int asBucket(@NotNull String $this$asBucket) {
        return MathUtil.nonNegativeAbs((int)$this$asBucket.hashCode()) % 256;
    }

    private final byte[] getOrGenerateSalt() {
        String string;
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfoEx, (String)"ApplicationInfoImpl.getShadowInstance()");
        String companyName = applicationInfoEx.getShortCompanyName();
        if (StringUtil.isEmptyOrSpaces((String)companyName)) {
            string = "jetbrains";
        } else {
            String string2 = companyName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"companyName");
            String string3 = string2;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase(locale2);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        }
        String name = string;
        Preferences prefs = Preferences.userRoot().node(name);
        byte[] salt = prefs.getByteArray(SALT_PREFERENCE_KEY, null);
        if (salt == null) {
            salt = new byte[32];
            new SecureRandom().nextBytes(salt);
            prefs.putByteArray(SALT_PREFERENCE_KEY, salt);
            LOG.info("Generating salt for the device");
        }
        return salt;
    }

    private EventLogConfiguration() {
    }

    static {
        EventLogConfiguration eventLogConfiguration;
        INSTANCE = eventLogConfiguration = new EventLogConfiguration();
        Logger logger2 = Logger.getInstance(EventLogConfiguration.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(Event\u2026onfiguration::class.java)");
        LOG = logger2;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        sessionId = eventLogConfiguration.shortedUUID(string);
        String string2 = DeviceIdManager.getOrGenerateId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DeviceIdManager.getOrGenerateId()");
        deviceId = string2;
        bucket = eventLogConfiguration.asBucket(deviceId);
        build$delegate = LazyKt.lazy((Function0)build.2.INSTANCE);
        salt = eventLogConfiguration.getOrGenerateSalt();
        anonymizedCache = new HashMap();
    }

    public static final /* synthetic */ String access$asBuildNumber(EventLogConfiguration $this, BuildNumber $this$access_u24asBuildNumber) {
        return $this.asBuildNumber($this$access_u24asBuildNumber);
    }
}

