/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

public final class DeviceIdManager {
    private static final Logger LOG = Logger.getInstance(DeviceIdManager.class);
    private static final String DEVICE_ID_SHARED_FILE = "PermanentDeviceId";
    private static final String DEVICE_ID_PREFERENCE_KEY = "device_id";

    public static String getOrGenerateId() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        Preferences prefs = DeviceIdManager.getPreferences(appInfo);
        String deviceId = prefs.get(DEVICE_ID_PREFERENCE_KEY, null);
        if (StringUtil.isEmptyOrSpaces((String)deviceId)) {
            deviceId = DeviceIdManager.generateId(Calendar.getInstance(Locale.ENGLISH), DeviceIdManager.getOSChar());
            prefs.put(DEVICE_ID_PREFERENCE_KEY, deviceId);
            LOG.info("Generating new Device ID");
        }
        if (appInfo.isVendorJetBrains() && SystemInfo.isWindows) {
            deviceId = DeviceIdManager.syncWithSharedFile(DEVICE_ID_SHARED_FILE, deviceId, prefs, DEVICE_ID_PREFERENCE_KEY);
        }
        return deviceId;
    }

    @NotNull
    public static String syncWithSharedFile(@NotNull String fileName, @NotNull String installationId, @NotNull Preferences prefs, @NotNull String prefsKey) {
        File dir;
        String appdata;
        if (fileName == null) {
            DeviceIdManager.$$$reportNull$$$0(0);
        }
        if (installationId == null) {
            DeviceIdManager.$$$reportNull$$$0(1);
        }
        if (prefs == null) {
            DeviceIdManager.$$$reportNull$$$0(2);
        }
        if (prefsKey == null) {
            DeviceIdManager.$$$reportNull$$$0(3);
        }
        if ((appdata = System.getenv("APPDATA")) != null && ((dir = new File(appdata, "JetBrains")).exists() || dir.mkdirs())) {
            File permanentIdFile = new File(dir, fileName);
            try {
                String fromFile = "";
                if (permanentIdFile.exists()) {
                    fromFile = DeviceIdManager.loadFromFile(permanentIdFile).trim();
                }
                if (!fromFile.isEmpty()) {
                    if (!fromFile.equals(installationId)) {
                        installationId = fromFile;
                        prefs.put(prefsKey, installationId);
                    }
                } else {
                    DeviceIdManager.writeToFile(permanentIdFile, installationId);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = installationId;
        if (string == null) {
            DeviceIdManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String loadFromFile(@NotNull File file) throws IOException {
        String string;
        if (file == null) {
            DeviceIdManager.$$$reportNull$$$0(5);
        }
        try (FileInputStream is = new FileInputStream(file);){
            byte[] bytes = FileUtilRt.loadBytes((InputStream)is);
            int offset = CharsetToolkit.hasUTF8Bom((byte[])bytes) ? CharsetToolkit.UTF8_BOM.length : 0;
            String string2 = new String(bytes, offset, bytes.length - offset, StandardCharsets.UTF_8);
            string = string2;
        }
        if (string == null) {
            DeviceIdManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void writeToFile(@NotNull File file, @NotNull String text) throws IOException {
        if (file == null) {
            DeviceIdManager.$$$reportNull$$$0(7);
        }
        if (text == null) {
            DeviceIdManager.$$$reportNull$$$0(8);
        }
        try (DataOutputStream stream = new DataOutputStream(new FileOutputStream(file));){
            stream.write(text.getBytes(StandardCharsets.UTF_8));
        }
    }

    @NotNull
    private static Preferences getPreferences(@NotNull ApplicationInfoEx appInfo) {
        String companyName;
        if (appInfo == null) {
            DeviceIdManager.$$$reportNull$$$0(9);
        }
        String name = StringUtil.isEmptyOrSpaces((String)(companyName = appInfo.getShortCompanyName())) ? "jetbrains" : companyName.toLowerCase(Locale.US);
        Preferences preferences = Preferences.userRoot().node(name);
        if (preferences == null) {
            DeviceIdManager.$$$reportNull$$$0(10);
        }
        return preferences;
    }

    public static String generateId(@NotNull Calendar calendar, char OSChar) {
        int year;
        if (calendar == null) {
            DeviceIdManager.$$$reportNull$$$0(11);
        }
        if ((year = calendar.get(1)) < 2000) {
            year = 2000;
        }
        if (year > 2099) {
            year = 2099;
        }
        calendar.set(1, year);
        return new SimpleDateFormat("ddMMyy", Locale.ENGLISH).format(calendar.getTime()) + OSChar + UUID.randomUUID().toString();
    }

    private static char getOSChar() {
        if (SystemInfo.isWindows) {
            return '1';
        }
        if (SystemInfo.isMac) {
            return '2';
        }
        if (SystemInfo.isLinux) {
            return '3';
        }
        return '0';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installationId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefsKey";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/DeviceIdManager";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calendar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/DeviceIdManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "syncWithSharedFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "syncWithSharedFile";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPreferences";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

