/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public class TextMateSelectorCachingWeigher
implements TextMateSelectorWeigher {
    private static final Logger LOG = Logger.getInstance(TextMateSelectorCachingWeigher.class);
    @NotNull
    private final TextMateSelectorWeigher myOriginalWeigher;
    @NotNull
    private final LoadingCache<Pair<CharSequence, CharSequence>, TextMateWeigh> myCache;

    public TextMateSelectorCachingWeigher(@NotNull TextMateSelectorWeigher originalWeigher) {
        if (originalWeigher == null) {
            TextMateSelectorCachingWeigher.$$$reportNull$$$0(0);
        }
        this.myOriginalWeigher = originalWeigher;
        this.myCache = CacheBuilder.newBuilder().maximumSize(200L).expireAfterWrite(1L, TimeUnit.MINUTES).build(CacheLoader.from(pair -> pair != null ? this.myOriginalWeigher.weigh((CharSequence)pair.first, (CharSequence)pair.second) : TextMateWeigh.ZERO));
    }

    @Override
    public TextMateWeigh weigh(@NotNull CharSequence scopeSelector, @NotNull CharSequence scope) {
        if (scopeSelector == null) {
            TextMateSelectorCachingWeigher.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            TextMateSelectorCachingWeigher.$$$reportNull$$$0(2);
        }
        try {
            return (TextMateWeigh)this.myCache.get((Object)Pair.create((Object)scopeSelector, (Object)scope));
        }
        catch (ExecutionException e) {
            LOG.error("Can't perform lazy weigh for textmate selectors", (Throwable)e);
            return this.myOriginalWeigher.weigh(scopeSelector, scope);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalWeigher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeSelector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorCachingWeigher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "weigh";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

