/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.CaptureMatchData;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorCachingWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigherImpl;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexFacade;
import org.jetbrains.plugins.textmate.regex.StringWithId;

public final class SyntaxMatchUtils {
    private static final LoadingCache<MatchKey, TextMateLexerState> CACHE = CacheBuilder.newBuilder().maximumSize(32768L).softValues().build(CacheLoader.from(key -> SyntaxMatchUtils.matchFirstUncached(Objects.requireNonNull(key).descriptor, key.string, key.byteOffset, ((MatchKey)key).priority, key.currentScope)));
    private static final Joiner MY_OPEN_TAGS_JOINER = Joiner.on((String)" ").skipNulls();
    private static final Map<List<CharSequence>, String> MY_SCOPES_INTERNER = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
    private static final TextMateSelectorWeigher mySelectorWeigher = new TextMateSelectorCachingWeigher(new TextMateSelectorWeigherImpl());

    @NotNull
    public static TextMateLexerState matchFirst(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull StringWithId string, int byteOffset, @NotNull TextMateWeigh.Priority priority, @NotNull String currentScope) {
        TextMateLexerState textMateLexerState;
        if (syntaxNodeDescriptor == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(0);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(1);
        }
        if (priority == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(2);
        }
        if (currentScope == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(3);
        }
        try {
            textMateLexerState = (TextMateLexerState)CACHE.get((Object)new MatchKey(syntaxNodeDescriptor, string, byteOffset, priority, currentScope));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof ProcessCanceledException)) continue;
                throw (ProcessCanceledException)cause;
            }
            throw new RuntimeException(e);
        }
        if (textMateLexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(4);
        }
        return textMateLexerState;
    }

    @NotNull
    private static TextMateLexerState matchFirstUncached(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull StringWithId string, int byteOffset, @NotNull TextMateWeigh.Priority priority, @NotNull String currentScope) {
        if (syntaxNodeDescriptor == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(5);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(6);
        }
        if (priority == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(7);
        }
        if (currentScope == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(8);
        }
        TextMateLexerState resultState = TextMateLexerState.notMatched(syntaxNodeDescriptor);
        List<SyntaxNodeDescriptor> children = syntaxNodeDescriptor.getChildren();
        for (SyntaxNodeDescriptor child : children) {
            resultState = SyntaxMatchUtils.moreImportantState(resultState, SyntaxMatchUtils.matchFirstChild(child, string, byteOffset, priority, currentScope));
            if (!resultState.matchData.matched() || resultState.matchData.byteOffset().getStartOffset() != byteOffset) continue;
            break;
        }
        return SyntaxMatchUtils.moreImportantState(resultState, SyntaxMatchUtils.matchInjections(syntaxNodeDescriptor, string, byteOffset, currentScope));
    }

    @NotNull
    private static TextMateLexerState matchInjections(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull StringWithId string, int byteOffset, @NotNull String currentScope) {
        if (syntaxNodeDescriptor == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(9);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(10);
        }
        if (currentScope == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(11);
        }
        TextMateLexerState resultState = TextMateLexerState.notMatched(syntaxNodeDescriptor);
        List<InjectionNodeDescriptor> injections = syntaxNodeDescriptor.getInjections();
        for (InjectionNodeDescriptor injection : injections) {
            TextMateWeigh selectorWeigh = mySelectorWeigher.weigh(injection.getSelector(), currentScope);
            if (selectorWeigh.weigh <= 0) continue;
            TextMateLexerState injectionState = SyntaxMatchUtils.matchFirstUncached(injection.getSyntaxNodeDescriptor(), string, byteOffset, selectorWeigh.priority, currentScope);
            resultState = SyntaxMatchUtils.moreImportantState(resultState, injectionState);
        }
        TextMateLexerState textMateLexerState = resultState;
        if (textMateLexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(12);
        }
        return textMateLexerState;
    }

    @NotNull
    private static TextMateLexerState moreImportantState(@NotNull TextMateLexerState oldState, @NotNull TextMateLexerState newState) {
        int oldScore;
        if (oldState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(13);
        }
        if (newState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(14);
        }
        if (!newState.matchData.matched()) {
            TextMateLexerState textMateLexerState = oldState;
            if (textMateLexerState == null) {
                SyntaxMatchUtils.$$$reportNull$$$0(15);
            }
            return textMateLexerState;
        }
        if (!oldState.matchData.matched()) {
            TextMateLexerState textMateLexerState = newState;
            if (textMateLexerState == null) {
                SyntaxMatchUtils.$$$reportNull$$$0(16);
            }
            return textMateLexerState;
        }
        int newScore = newState.matchData.byteOffset().getStartOffset();
        if ((newScore < (oldScore = oldState.matchData.byteOffset().getStartOffset()) || newScore == oldScore && newState.priorityMatch.compareTo(oldState.priorityMatch) > 0) && (!newState.matchData.byteOffset().isEmpty() || oldState.matchData.byteOffset().isEmpty() || SyntaxMatchUtils.hasBeginKey(newState))) {
            TextMateLexerState textMateLexerState = newState;
            if (textMateLexerState == null) {
                SyntaxMatchUtils.$$$reportNull$$$0(17);
            }
            return textMateLexerState;
        }
        TextMateLexerState textMateLexerState = oldState;
        if (textMateLexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(18);
        }
        return textMateLexerState;
    }

    private static boolean hasBeginKey(@NotNull TextMateLexerState lexerState) {
        if (lexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(19);
        }
        return lexerState.syntaxRule.getStringAttribute(Constants.StringKey.BEGIN) != null;
    }

    private static TextMateLexerState matchFirstChild(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull StringWithId string, int byteOffset, @NotNull TextMateWeigh.Priority priority, @NotNull String currentScope) {
        CharSequence match;
        if (syntaxNodeDescriptor == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(20);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(21);
        }
        if (priority == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(22);
        }
        if (currentScope == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(23);
        }
        if ((match = syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.MATCH)) != null) {
            return new TextMateLexerState(syntaxNodeDescriptor, RegexFacade.regex(match.toString()).match(string, byteOffset), priority, string);
        }
        CharSequence begin = syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.BEGIN);
        if (begin != null) {
            return new TextMateLexerState(syntaxNodeDescriptor, RegexFacade.regex(begin.toString()).match(string, byteOffset), priority, string);
        }
        if (syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.END) != null) {
            return TextMateLexerState.notMatched(syntaxNodeDescriptor);
        }
        return SyntaxMatchUtils.matchFirstUncached(syntaxNodeDescriptor, string, byteOffset, priority, currentScope);
    }

    public static List<CaptureMatchData> matchCaptures(@NotNull TIntObjectHashMap<CharSequence> captures, @NotNull MatchData matchData, @NotNull StringWithId string) {
        if (captures == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(24);
        }
        if (matchData == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(25);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(26);
        }
        ArrayList<CaptureMatchData> result = new ArrayList<CaptureMatchData>();
        for (int index : captures.keys()) {
            TextRange offset;
            CharSequence captureName = (CharSequence)captures.get(index);
            TextRange textRange = offset = index < matchData.count() ? matchData.charOffset(string.bytes, index) : TextRange.EMPTY_RANGE;
            if (captureName.length() <= 0 || offset.isEmpty()) continue;
            result.add(new CaptureMatchData(offset, index, captureName));
        }
        return result;
    }

    public static MatchData matchStringRegex(@NotNull Constants.StringKey keyName, @NotNull StringWithId string, int byteOffset, @NotNull TextMateLexerState lexerState) {
        CharSequence stringRegex;
        if (keyName == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(27);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(28);
        }
        if (lexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(29);
        }
        return (stringRegex = lexerState.syntaxRule.getStringAttribute(keyName)) != null ? RegexFacade.regex(SyntaxMatchUtils.replaceGroupsWithMatchData(stringRegex, lexerState.string, lexerState.matchData)).match(string, byteOffset) : MatchData.NOT_MATCHED;
    }

    public static String replaceGroupsWithMatchData(@NotNull CharSequence patternString, @Nullable StringWithId string, @NotNull MatchData matchData) {
        if (patternString == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(30);
        }
        if (matchData == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(31);
        }
        if (string == null || !matchData.matched()) {
            return patternString.toString();
        }
        StringBuilder result = new StringBuilder();
        int charIndex = 0;
        int length = patternString.length();
        while (charIndex < length) {
            char c = patternString.charAt(charIndex);
            if (c == '\\') {
                int digit;
                int digitIndex;
                boolean hasGroupIndex = false;
                int groupIndex = 0;
                for (digitIndex = charIndex + 1; digitIndex < length && (digit = Character.digit(patternString.charAt(digitIndex), 10)) != -1; ++digitIndex) {
                    hasGroupIndex = true;
                    groupIndex = groupIndex * 10 + digit;
                }
                if (hasGroupIndex && matchData.count() > groupIndex) {
                    TextRange range = matchData.byteOffset(groupIndex);
                    StringUtil.escapeToRegexp((CharSequence)new String(string.bytes, range.getStartOffset(), range.getLength(), StandardCharsets.UTF_8), (StringBuilder)result);
                    charIndex = digitIndex;
                    continue;
                }
            }
            result.append(c);
            ++charIndex;
        }
        return result.toString();
    }

    @NotNull
    public static String selectorsToScope(@NotNull List<CharSequence> selectors) {
        if (selectors == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(32);
        }
        String string = MY_SCOPES_INTERNER.computeIfAbsent(new ArrayList<CharSequence>(selectors), arg_0 -> ((Joiner)MY_OPEN_TAGS_JOINER).join(arg_0));
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxNodeDescriptor";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 21: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 2: 
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentScope";
                break;
            }
            case 4: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldState";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexerState";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captures";
                break;
            }
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchData";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternString";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "matchFirst";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "matchInjections";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "moreImportantState";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "selectorsToScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchFirst";
                break;
            }
            case 4: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 33: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchFirstUncached";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchInjections";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moreImportantState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasBeginKey";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "matchFirstChild";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "matchCaptures";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "matchStringRegex";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "replaceGroupsWithMatchData";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "selectorsToScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MatchKey {
        final SyntaxNodeDescriptor descriptor;
        final StringWithId string;
        final int byteOffset;
        private final TextMateWeigh.Priority priority;
        final String currentScope;

        private MatchKey(SyntaxNodeDescriptor descriptor, StringWithId string, int byteOffset, TextMateWeigh.Priority priority, String currentScope) {
            this.descriptor = descriptor;
            this.string = string;
            this.byteOffset = byteOffset;
            this.priority = priority;
            this.currentScope = currentScope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchKey key = (MatchKey)o;
            return this.byteOffset == key.byteOffset && this.descriptor.equals(key.descriptor) && Objects.equals(this.string, key.string) && this.priority == key.priority && this.currentScope.equals(key.currentScope);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.descriptor, this.string, this.byteOffset, this.priority, this.currentScope});
        }
    }
}

