/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.lang.JavaVersion;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;

public abstract class JdkVersionDetector {
    public static JdkVersionDetector getInstance() {
        return JpsServiceManager.getInstance().getService(JdkVersionDetector.class);
    }

    @Nullable
    public abstract JdkVersionInfo detectJdkVersionInfo(@NotNull String var1);

    @Nullable
    public abstract JdkVersionInfo detectJdkVersionInfo(@NotNull String var1, @NotNull ExecutorService var2);

    @NotNull
    public static String formatVersionString(@NotNull JavaVersion version) {
        if (version == null) {
            JdkVersionDetector.$$$reportNull$$$0(0);
        }
        String string = "java version \"" + version + '\"';
        if (string == null) {
            JdkVersionDetector.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isVersionString(@NotNull String string) {
        if (string == null) {
            JdkVersionDetector.$$$reportNull$$$0(2);
        }
        return string.length() >= 16 && string.startsWith("java version \"") && StringUtil.endsWithChar((CharSequence)string, (char)'\"');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/JdkVersionDetector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/JdkVersionDetector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatVersionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatVersionString";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isVersionString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class JdkVersionInfo {
        public final JavaVersion version;
        public final Bitness bitness;

        public JdkVersionInfo(@NotNull JavaVersion version, @NotNull Bitness bitness) {
            if (version == null) {
                JdkVersionInfo.$$$reportNull$$$0(0);
            }
            if (bitness == null) {
                JdkVersionInfo.$$$reportNull$$$0(1);
            }
            this.version = version;
            this.bitness = bitness;
        }

        public String toString() {
            return this.version + " " + this.bitness;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bitness";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/model/java/JdkVersionDetector$JdkVersionInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

