/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.TouchScrollUtil;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.Timer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class MouseWheelSmoothScroll {
    private final InertialAnimator horizontal;
    private final InertialAnimator vertical;
    private final FlingManager horizontalFling;
    private final FlingManager verticalFling;
    @NotNull
    private final Supplier<Boolean> myScrollEnabled;

    public static MouseWheelSmoothScroll create() {
        return MouseWheelSmoothScroll.create(() -> true);
    }

    public static MouseWheelSmoothScroll create(@NotNull Supplier<Boolean> isScrollEnabled) {
        if (isScrollEnabled == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(0);
        }
        return new MouseWheelSmoothScroll(isScrollEnabled);
    }

    private MouseWheelSmoothScroll(@NotNull Supplier<Boolean> isEnabledChecker) {
        if (isEnabledChecker == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(1);
        }
        this.horizontal = new InertialAnimator();
        this.vertical = new InertialAnimator();
        this.horizontalFling = new FlingManager();
        this.verticalFling = new FlingManager();
        this.myScrollEnabled = Objects.requireNonNull(isEnabledChecker);
    }

    public void processMouseWheelEvent(@NotNull MouseWheelEvent e, @Nullable Consumer<MouseWheelEvent> alternative) {
        int delta;
        JScrollBar bar;
        if (e == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(2);
        }
        JScrollBar jScrollBar = bar = this.myScrollEnabled.get() == false ? null : MouseWheelSmoothScroll.getEventScrollBar(e);
        if (bar == null) {
            if (alternative != null) {
                alternative.accept(e);
            }
            return;
        }
        InertialAnimator animator = MouseWheelSmoothScroll.isHorizontalScroll(e) ? this.horizontal : this.vertical;
        int value = bar.getValue();
        if (TouchScrollUtil.isTouchScroll(e)) {
            delta = MouseWheelSmoothScroll.getRoundedAtLeastToOne(TouchScrollUtil.getDelta(e));
        } else {
            delta = (int)MouseWheelSmoothScroll.getDelta(bar, e, animator.myTargetValue);
            if (delta == 0) {
                return;
            }
        }
        int targetValue = value + delta;
        if (TouchScrollUtil.isBegin(e)) {
            this.verticalFling.registerBegin();
            this.horizontalFling.registerBegin();
        } else if (TouchScrollUtil.isUpdate(e)) {
            bar.setValue(targetValue);
            FlingManager fling = MouseWheelSmoothScroll.isHorizontalScroll(e) ? this.horizontalFling : this.verticalFling;
            fling.registerUpdate(delta);
        } else if (TouchScrollUtil.isEnd(e)) {
            this.verticalFling.start(MouseWheelSmoothScroll.getEventVerticalScrollBar(e), this.vertical);
            this.horizontalFling.start(MouseWheelSmoothScroll.getEventHorizontalScrollBar(e), this.horizontal);
        } else {
            animator.start(value, targetValue, bar::setValue, MouseWheelSmoothScroll.shouldStop(bar), DefaultAnimationSettings.SCROLL);
        }
        e.consume();
    }

    @Nullable
    public static JScrollBar getEventScrollBar(@NotNull MouseWheelEvent e) {
        if (e == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(3);
        }
        return MouseWheelSmoothScroll.isHorizontalScroll(e) ? MouseWheelSmoothScroll.getEventHorizontalScrollBar(e) : MouseWheelSmoothScroll.getEventVerticalScrollBar(e);
    }

    @Nullable
    public static JScrollBar getEventHorizontalScrollBar(@NotNull MouseWheelEvent e) {
        JScrollPane scroller;
        if (e == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(4);
        }
        return (scroller = (JScrollPane)e.getComponent()) == null ? null : scroller.getHorizontalScrollBar();
    }

    @Nullable
    public static JScrollBar getEventVerticalScrollBar(@NotNull MouseWheelEvent e) {
        JScrollPane scroller;
        if (e == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(5);
        }
        return (scroller = (JScrollPane)e.getComponent()) == null ? null : scroller.getVerticalScrollBar();
    }

    private static Predicate<Integer> shouldStop(JScrollBar bar) {
        return v -> v - bar.getValue() != 0 || !bar.isShowing();
    }

    public static boolean isHorizontalScroll(@NotNull MouseWheelEvent e) {
        if (e == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(6);
        }
        return e.isShiftDown();
    }

    private static double getDelta(@NotNull JScrollBar bar, @NotNull MouseWheelEvent event, double animationTargetValue) {
        JViewport viewport;
        double rotation;
        int direction;
        if (bar == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(7);
        }
        if (event == null) {
            MouseWheelSmoothScroll.$$$reportNull$$$0(8);
        }
        int n = direction = (rotation = event.getPreciseWheelRotation()) < 0.0 ? -1 : 1;
        if (event.getScrollType() == 1) {
            return direction * bar.getBlockIncrement(direction);
        }
        if (event.getSource() instanceof JScrollPane && (viewport = ((JScrollPane)event.getSource()).getViewport()).getView() instanceof Scrollable) {
            int orientation = bar.getOrientation();
            boolean isVertical = orientation == 1;
            Scrollable scrollable = (Scrollable)((Object)viewport.getView());
            int scroll = Math.abs(event.getUnitsToScroll());
            Rectangle rect = viewport.getViewRect();
            int delta = 0;
            if (!Double.isNaN(animationTargetValue)) {
                if (isVertical) {
                    rect.y = (int)animationTargetValue;
                } else {
                    rect.x = (int)animationTargetValue;
                }
            }
            for (int i = 0; i < scroll; ++i) {
                int increment = Math.max(scrollable.getScrollableUnitIncrement(rect, orientation, direction), 0) * direction;
                if (isVertical) {
                    rect.y += increment;
                } else {
                    rect.x += increment;
                }
                delta += increment;
            }
            return delta;
        }
        int increment = bar.getUnitIncrement(direction);
        int delta = increment * event.getUnitsToScroll();
        return delta == 0 ? rotation : (double)delta;
    }

    private static int getRoundedAtLeastToOne(double value) {
        if (value == 0.0) {
            return 0;
        }
        if (Math.abs(value) < 1.0) {
            return value > 0.0 ? 1 : -1;
        }
        return (int)Math.round(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isScrollEnabled";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isEnabledChecker";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bar";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/MouseWheelSmoothScroll";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processMouseWheelEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventScrollBar";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventHorizontalScrollBar";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventVerticalScrollBar";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isHorizontalScroll";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getDelta";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CubicBezierEasing
    implements Easing {
        private final double[] xs;
        private final double[] ys;

        private CubicBezierEasing(double c1x, double c1y, double c2x, double c2y, int size) {
            this.xs = new double[size];
            this.ys = new double[size];
            this.update(c1x, c1y, c2x, c2y);
        }

        public void update(double c1x, double c1y, double c2x, double c2y) {
            for (int i = 0; i < this.xs.length; ++i) {
                this.xs[i] = CubicBezierEasing.bezier((double)i * 1.0 / (double)this.xs.length, c1x, c2x);
                this.ys[i] = CubicBezierEasing.bezier((double)i * 1.0 / (double)this.xs.length, c1y, c2y);
            }
        }

        public int getSize() {
            assert (this.xs.length == this.ys.length);
            return this.xs.length;
        }

        @Override
        public double calc(double t, double b, double c, double d) {
            double x = t / d;
            int res = Arrays.binarySearch(this.xs, x);
            if (res < 0) {
                res = -res - 1;
            }
            return c * this.ys[Math.min(res, this.ys.length - 1)] + b;
        }

        private static double bezier(double t, double u1, double u2) {
            double v = 1.0 - t;
            return 3.0 * u1 * v * v * t + 3.0 * u2 * v * t * t + t * t * t;
        }
    }

    private static interface Easing {
        public double calc(double var1, double var3, double var5, double var7);
    }

    private static enum DefaultAnimationSettings implements AnimationSettings
    {
        SCROLL{
            private CubicBezierEasing ourEasing;
            private int curvePoints;

            @Override
            public double getDuration() {
                return UISettings.getShadowInstance().getAnimatedScrollingDuration();
            }

            @Override
            @NotNull
            public Easing getEasing() {
                int points = UISettings.getShadowInstance().getAnimatedScrollingCurvePoints();
                if (points != this.curvePoints || this.ourEasing == null) {
                    double x1 = (double)(points >> 24 & 0xFF) / 200.0;
                    double y1 = (double)(points >> 16 & 0xFF) / 200.0;
                    double x2 = (double)(points >> 8 & 0xFF) / 200.0;
                    double y2 = (double)(points & 0xFF) / 200.0;
                    if (this.ourEasing == null) {
                        this.ourEasing = new CubicBezierEasing(x1, y1, x2, y2, 2000);
                    } else {
                        this.ourEasing.update(x1, y1, x2, y2);
                    }
                    this.curvePoints = points;
                }
                CubicBezierEasing cubicBezierEasing = this.ourEasing;
                if (cubicBezierEasing == null) {
                    1.$$$reportNull$$$0(0);
                }
                return cubicBezierEasing;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MouseWheelSmoothScroll$DefaultAnimationSettings$1", "getEasing"));
            }
        }
        ,
        TOUCH{
            private Easing cubicEaseOut;

            @Override
            public double getDuration() {
                return Math.max(Math.abs(Registry.doubleValue((String)"idea.inertial.smooth.scrolling.touch.duration")), 0.0);
            }

            @Override
            @NotNull
            public Easing getEasing() {
                if (this.cubicEaseOut == null) {
                    this.cubicEaseOut = new CubicBezierEasing(0.215, 0.61, 0.355, 1.0, 2000);
                }
                Easing easing = this.cubicEaseOut;
                if (easing == null) {
                    2.$$$reportNull$$$0(0);
                }
                return easing;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MouseWheelSmoothScroll$DefaultAnimationSettings$2", "getEasing"));
            }
        };

    }

    private static interface AnimationSettings {
        public double getDuration();

        @NotNull
        public Easing getEasing();
    }

    private static class FlingManager {
        private long beginTime = 0L;
        private int lastDelta = 0;

        private FlingManager() {
        }

        public void registerBegin() {
            this.beginTime = System.currentTimeMillis();
            this.lastDelta = 0;
        }

        public void registerUpdate(int delta) {
            this.beginTime = 0L;
            this.lastDelta = delta;
        }

        private static int getPixelThreshold() {
            return Registry.intValue((String)"idea.inertial.touch.fling.pixelThreshold");
        }

        private static int getFlingMultiplier() {
            return Registry.intValue((String)"idea.inertial.touch.fling.multiplier");
        }

        private static int getFlingInterruptLag() {
            return Registry.intValue((String)"idea.inertial.touch.fling.interruptLag");
        }

        public boolean shouldStart() {
            return Math.abs(this.lastDelta) >= FlingManager.getPixelThreshold();
        }

        private Predicate<Integer> shouldStop(JScrollBar bar) {
            return MouseWheelSmoothScroll.shouldStop(bar).or(v -> this.beginTime != 0L && System.currentTimeMillis() - this.beginTime > (long)FlingManager.getFlingInterruptLag());
        }

        public void start(JScrollBar bar, InertialAnimator animator) {
            if (bar != null && this.shouldStart()) {
                int initValue = bar.getValue();
                int targetValue = initValue + this.lastDelta * FlingManager.getFlingMultiplier();
                animator.start(initValue, targetValue, bar::setValue, this.shouldStop(bar), DefaultAnimationSettings.TOUCH);
            }
        }
    }

    private static class InertialAnimator
    implements ActionListener {
        private static final int REFRESH_TIME = 6;
        private double myInitValue = Double.NaN;
        private double myCurrentValue = Double.NaN;
        private double myTargetValue = Double.NaN;
        private long myStartEventTime = -1L;
        private long myLastEventTime = -1L;
        private long myDuration = -1L;
        private AnimationSettings mySettings;
        private final Consumer<Integer> BLACK_HOLE = x -> {};
        @NotNull
        private Consumer<Integer> myConsumer = this.BLACK_HOLE;
        private final Predicate<Integer> FALSE_PREDICATE = value -> false;
        @NotNull
        private Predicate<Integer> myShouldStop = this.FALSE_PREDICATE;
        private final Timer myTimer = TimerUtil.createNamedTimer((String)"Inertial Animation Timer", (int)6, (ActionListener)this);

        private InertialAnimator() {
            this.myTimer.setInitialDelay(0);
        }

        public final void start(int initValue, int targetValue, @NotNull Consumer<Integer> consumer, @Nullable Predicate<Integer> shouldStop, @NotNull AnimationSettings settings) {
            boolean isSameDirection;
            if (consumer == null) {
                InertialAnimator.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                InertialAnimator.$$$reportNull$$$0(1);
            }
            this.mySettings = settings;
            double duration = this.mySettings.getDuration();
            if (duration == 0.0) {
                consumer.accept(targetValue);
                this.stop();
                return;
            }
            boolean bl = isSameDirection = (this.myTargetValue - this.myInitValue) * (double)(targetValue - initValue) > 0.0;
            if (isSameDirection && this.myTimer.isRunning()) {
                this.myTargetValue += (double)(targetValue - initValue);
                this.myDuration = (long)duration + Math.max(this.myLastEventTime - this.myStartEventTime, 0L);
                this.myInitValue = this.myCurrentValue;
                this.myStartEventTime = this.myLastEventTime;
            } else {
                this.myTargetValue = targetValue;
                this.myDuration = (long)duration;
                this.myInitValue = initValue;
                this.myStartEventTime = System.currentTimeMillis();
            }
            this.myConsumer = Objects.requireNonNull(consumer);
            this.myShouldStop = shouldStop == null ? this.FALSE_PREDICATE : shouldStop;
            this.myCurrentValue = initValue;
            this.myTimer.start();
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            if (this.myShouldStop.test((int)Math.round(this.myCurrentValue))) {
                this.stop();
                return;
            }
            this.myLastEventTime = System.currentTimeMillis();
            long currentEventTime = Math.min(this.myLastEventTime, this.myStartEventTime + this.myDuration);
            this.myCurrentValue = this.mySettings.getEasing().calc(currentEventTime - this.myStartEventTime, this.myInitValue, this.myTargetValue - this.myInitValue, this.myDuration);
            this.myConsumer.accept((int)Math.round(this.myCurrentValue));
            if (this.myLastEventTime >= this.myStartEventTime + this.myDuration) {
                this.stop();
            }
        }

        public final void stop() {
            this.myTimer.stop();
            this.myStartEventTime = -1L;
            this.myLastEventTime = -1L;
            this.myDuration = -1L;
            this.myTargetValue = Double.NaN;
            this.myCurrentValue = Double.NaN;
            this.myInitValue = Double.NaN;
            this.myConsumer = this.BLACK_HOLE;
            this.myShouldStop = this.FALSE_PREDICATE;
            this.mySettings = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/ui/MouseWheelSmoothScroll$InertialAnimator";
            objectArray[2] = "start";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

