/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilenameIndex {
    @ApiStatus.Internal
    @NonNls
    public static final ID<String, Void> NAME = ID.create("FilenameIndex");

    public static String @NotNull [] getAllFilenames(@Nullable Project project) {
        THashSet names = new THashSet();
        FilenameIndex.processAllFileNames((Processor<? super String>)((Processor)arg_0 -> FilenameIndex.lambda$getAllFilenames$0((Set)names, arg_0)), project == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope(project), null);
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)names);
        if (stringArray == null) {
            FilenameIndex.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    public static void processAllFileNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(2);
        }
        FileBasedIndex.getInstance().processAllKeys(NAME, processor, scope, filter);
    }

    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(4);
        }
        return FilenameIndex.getVirtualFilesByName(name, scope, null);
    }

    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(6);
        }
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(project, name, scope);
        }
        return FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, null);
    }

    public static PsiFile @NotNull [] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(7);
        }
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(9);
        }
        return (PsiFile[])FilenameIndex.getFilesByName(project, name, scope, false);
    }

    public static boolean processFilesByName(@NotNull String name, boolean directories, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(12);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(13);
        }
        return FilenameIndex.processFilesByName(name, directories, true, processor, scope, project, idFilter);
    }

    public static boolean processFilesByName(@NotNull String name, boolean directories, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        Collection<VirtualFile> files;
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(16);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(17);
        }
        if ((files = caseSensitively ? FilenameIndex.getVirtualFilesByName(name, scope, idFilter) : FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, idFilter)).isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance(project);
        int processedFiles = 0;
        for (VirtualFile file : files) {
            PsiDirectory dir;
            if (!file.isValid()) continue;
            if (!directories && !file.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile == null) continue;
                if (!processor.process((Object)psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!directories || !file.isDirectory() || (dir = psiManager.findDirectory(file)) == null) continue;
            if (!processor.process((Object)dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNameIgnoringCase(@NotNull String name, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(19);
        }
        THashSet keys = new THashSet();
        FilenameIndex.processAllFileNames((Processor<? super String>)((Processor)arg_0 -> FilenameIndex.lambda$getVirtualFilesByNameIgnoringCase$1(name, (Set)keys, arg_0)), scope, idFilter);
        THashSet files = new THashSet();
        for (String each : keys) {
            files.addAll(FilenameIndex.getVirtualFilesByName(each, scope, idFilter));
        }
        THashSet tHashSet = files;
        if (tHashSet == null) {
            FilenameIndex.$$$reportNull$$$0(20);
        }
        return tHashSet;
    }

    public static PsiFileSystemItem @NotNull [] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope, boolean directories) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(21);
        }
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(23);
        }
        SmartList result = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor(result);
        FilenameIndex.processFilesByName(name, directories, processor, scope, project, null);
        if (directories) {
            PsiFileSystemItem[] psiFileSystemItemArray = (PsiFileSystemItem[])result.toArray((Object[])new PsiFileSystemItem[0]);
            if (psiFileSystemItemArray == null) {
                FilenameIndex.$$$reportNull$$$0(24);
            }
            return psiFileSystemItemArray;
        }
        PsiFileSystemItem[] psiFileSystemItemArray = (PsiFileSystemItem[])result.toArray((Object[])PsiFile.EMPTY_ARRAY);
        if (psiFileSystemItemArray == null) {
            FilenameIndex.$$$reportNull$$$0(25);
        }
        return psiFileSystemItemArray;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(26);
        }
        if (ext == null) {
            FilenameIndex.$$$reportNull$$$0(27);
        }
        return FilenameIndex.getAllFilesByExt(project, ext, GlobalSearchScope.allScope(project));
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        int len;
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(28);
        }
        if (ext == null) {
            FilenameIndex.$$$reportNull$$$0(29);
        }
        if (searchScope == null) {
            FilenameIndex.$$$reportNull$$$0(30);
        }
        if ((len = ext.length()) == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                FilenameIndex.$$$reportNull$$$0(31);
            }
            return list;
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String name : FilenameIndex.getAllFilenames(project)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(ext)) continue;
            files.addAll(FilenameIndex.getVirtualFilesByName(project, name, searchScope));
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            FilenameIndex.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<VirtualFile> getVirtualFilesByName(@NotNull String name, @NotNull GlobalSearchScope scope, IdFilter filter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(33);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(34);
        }
        THashSet files = new THashSet();
        FileBasedIndex.getInstance().processValues(NAME, name, null, (arg_0, arg_1) -> FilenameIndex.lambda$getVirtualFilesByName$2((Set)files, arg_0, arg_1), scope, filter);
        THashSet tHashSet = files;
        if (tHashSet == null) {
            FilenameIndex.$$$reportNull$$$0(35);
        }
        return tHashSet;
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByName$2(Set files, VirtualFile file, Void value) {
        files.add(file);
        return true;
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByNameIgnoringCase$1(String name, Set keys, String value) {
        if (name.equalsIgnoreCase(value)) {
            keys.add(value);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getAllFilenames$0(Set names, String s) {
        names.add(s);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/FilenameIndex";
                break;
            }
            case 1: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 23: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 13: 
            case 17: 
            case 21: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilenames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/FilenameIndex";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesByNameIgnoringCase";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilesByExt";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processAllFileNames";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesByName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processFilesByName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesByNameIgnoringCase";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAllFilesByExt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

