/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LegacyCodeStyleSettingsManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectCodeStyleConfiguration", storages={@Storage(value="codeStyles", stateSplitter=StateSplitter.class)})
public class ProjectCodeStyleSettingsManager
extends CodeStyleSettingsManager {
    private static final Logger LOG = Logger.getInstance(ProjectCodeStyleSettingsManager.class);
    private static final String MAIN_PROJECT_CODE_STYLE_NAME = "Project";
    private static final String PROJECT_CODE_STYLE_CONFIG_FILE_NAME = "codeStyleConfig";
    private final Project myProject;
    private boolean myIsLoaded;
    private final Map<String, CodeStyleSettings> mySettingsMap = new HashMap<String, CodeStyleSettings>();
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Code style settings migration", NotificationDisplayType.STICKY_BALLOON, true);

    public ProjectCodeStyleSettingsManager(Project project) {
        this.myProject = project;
        this.setMainProjectCodeStyle(null);
        this.registerExtensionPointListeners((Disposable)project);
    }

    @Override
    public void initializeComponent() {
        this.initProjectSettings(this.myProject);
        this.getCurrentSettings();
    }

    private void initProjectSettings(@NotNull Project project) {
        if (project == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        if (!this.myIsLoaded) {
            LegacyCodeStyleSettingsManager legacySettingsManager = ServiceManager.getService(project, LegacyCodeStyleSettingsManager.class);
            if (legacySettingsManager != null && legacySettingsManager.getState() != null) {
                this.loadState(legacySettingsManager.getState());
                if (!(project.isDefault() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment())) {
                    ProjectCodeStyleSettingsManager.saveProjectAndNotify(project);
                }
                LOG.info("Imported old project code style settings.");
            } else {
                this.initDefaults();
                LOG.info("Initialized from default code style settings.");
            }
        }
    }

    private static void saveProjectAndNotify(@NotNull Project project) {
        if (project == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            project.save();
            CodeStyleMigrationNotification notification = new CodeStyleMigrationNotification(project.getName());
            notification.notify(project);
        }, project.getDisposed());
    }

    @Override
    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        this.PER_PROJECT_SETTINGS = settings;
        this.mySettingsMap.put(MAIN_PROJECT_CODE_STYLE_NAME, settings != null ? settings : new CodeStyleSettings());
    }

    @Override
    @NotNull
    public CodeStyleSettings getMainProjectCodeStyle() {
        CodeStyleSettings codeStyleSettings = this.mySettingsMap.get(MAIN_PROJECT_CODE_STYLE_NAME);
        if (codeStyleSettings == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        return codeStyleSettings;
    }

    private void initDefaults() {
        CodeStyleSettingsManager appCodeStyleSettingsManager = CodeStyleSettingsManager.getInstance();
        if (appCodeStyleSettingsManager != null) {
            CodeStyleSettings defaultProjectSettings = appCodeStyleSettingsManager.getMainProjectCodeStyle();
            this.setMainProjectCodeStyle(defaultProjectSettings != null ? defaultProjectSettings.clone() : null);
            this.USE_PER_PROJECT_SETTINGS = appCodeStyleSettingsManager.USE_PER_PROJECT_SETTINGS;
            this.PREFERRED_PROJECT_CODE_STYLE = appCodeStyleSettingsManager.PREFERRED_PROJECT_CODE_STYLE;
        }
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(3);
        }
        LOG.info("Loading Project code style");
        super.loadState(state);
        this.updateFromOldProjectSettings();
        for (Element subStyle : state.getChildren("code_scheme")) {
            String name = subStyle.getAttributeValue("name");
            CodeStyleSettings settings = new CodeStyleSettings();
            settings.readExternal(subStyle);
            if (MAIN_PROJECT_CODE_STYLE_NAME.equals(name)) {
                this.setMainProjectCodeStyle(settings);
            } else {
                this.mySettingsMap.put(name, settings);
            }
            LOG.info(name + " code style loaded");
        }
        this.myIsLoaded = true;
    }

    private void updateFromOldProjectSettings() {
        CodeStyleSettings oldProjectSettings = this.PER_PROJECT_SETTINGS;
        if (oldProjectSettings != null) {
            oldProjectSettings.resetDeprecatedFields();
        }
        this.setMainProjectCodeStyle(oldProjectSettings);
    }

    @Override
    public Element getState() {
        Element e = super.getState();
        if (e != null) {
            LOG.info("Saving Project code style");
            for (String name : this.mySettingsMap.keySet()) {
                CodeStyleSettings settings = this.mySettingsMap.get(name);
                Element codeStyle = new Element("code_scheme");
                codeStyle.setAttribute("name", name);
                settings.writeExternal(codeStyle);
                if (codeStyle.getContent().isEmpty()) continue;
                e.addContent(codeStyle);
                LOG.info(name + " code style saved");
            }
        }
        return e;
    }

    @Override
    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        if (fieldName == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        return "PER_PROJECT_SETTINGS".equals(fieldName);
    }

    @Override
    protected Collection<CodeStyleSettings> enumSettings() {
        return Collections.unmodifiableCollection(this.mySettingsMap.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainProjectCodeStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initProjectSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveProjectAndNotify";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOnSave";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class StateSplitter
    extends MainConfigurationStateSplitter {
        StateSplitter() {
        }

        @Override
        @NotNull
        protected String getComponentStateFileName() {
            return ProjectCodeStyleSettingsManager.PROJECT_CODE_STYLE_CONFIG_FILE_NAME;
        }

        @Override
        @NotNull
        protected String getSubStateTagName() {
            return "code_scheme";
        }

        @Override
        @NotNull
        protected String getSubStateFileName(@NotNull Element element) {
            if (element == null) {
                StateSplitter.$$$reportNull$$$0(0);
            }
            String string = element.getAttributeValue("name");
            if (string == null) {
                StateSplitter.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager$StateSplitter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager$StateSplitter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubStateFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubStateFileName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ShowMoreInfoAction
    extends DumbAwareAction {
        ShowMoreInfoAction() {
            super(IdeBundle.messagePointer("action.ProjectCodeStyleSettingsManager.ShowMoreInfoAction.text.more.info", new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowMoreInfoAction.$$$reportNull$$$0(0);
            }
            BrowserUtil.open("https://confluence.jetbrains.com/display/IDEADEV/New+project+code+style+settings+format+in+2017.3");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager$ShowMoreInfoAction", "actionPerformed"));
        }
    }

    private static class CodeStyleMigrationNotification
    extends Notification {
        CodeStyleMigrationNotification(@NotNull String projectName) {
            if (projectName == null) {
                CodeStyleMigrationNotification.$$$reportNull$$$0(0);
            }
            super(NOTIFICATION_GROUP.getDisplayId(), ApplicationBundle.message("project.code.style.migration.title", new Object[0]), ApplicationBundle.message("project.code.style.migration.message", projectName), NotificationType.INFORMATION);
            this.addAction(new ShowMoreInfoAction());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager$CodeStyleMigrationNotification", "<init>"));
        }
    }
}

