/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsRootSettings;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class VcsDirectoryMapping {
    public static final String DEFAULT_MAPPING_DIR = "";
    public static final String PROJECT_CONSTANT = "<Project>";
    public static final VcsDirectoryMapping[] EMPTY_ARRAY = new VcsDirectoryMapping[0];
    @NotNull
    private final String myDirectory;
    private final String myVcs;
    private VcsRootSettings myRootSettings;

    public VcsDirectoryMapping(@NotNull String directory, @Nullable String vcs) {
        if (directory == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(0);
        }
        this(directory, vcs, null);
    }

    public VcsDirectoryMapping(@NotNull String directory, @Nullable String vcs, @Nullable VcsRootSettings rootSettings) {
        if (directory == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(1);
        }
        this.myDirectory = FileUtil.normalize((String)directory);
        this.myVcs = StringUtil.notNullize((String)vcs);
        this.myRootSettings = rootSettings;
    }

    @NotNull
    public static VcsDirectoryMapping createDefault(@NotNull String vcs) {
        if (vcs == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(2);
        }
        return new VcsDirectoryMapping(DEFAULT_MAPPING_DIR, vcs);
    }

    @NotNull
    public @SystemIndependent String getDirectory() {
        String string = this.myDirectory;
        if (string == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public String systemIndependentPath() {
        String string = this.myDirectory;
        if (string == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getVcs() {
        String string = this.myVcs;
        if (string == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public VcsRootSettings getRootSettings() {
        return this.myRootSettings;
    }

    @Deprecated
    public void setRootSettings(VcsRootSettings rootSettings) {
        this.myRootSettings = rootSettings;
    }

    public boolean isDefaultMapping() {
        return this.myDirectory.length() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsDirectoryMapping mapping = (VcsDirectoryMapping)o;
        if (!this.myDirectory.equals(mapping.myDirectory)) {
            return false;
        }
        if (!Objects.equals(this.myVcs, mapping.myVcs)) {
            return false;
        }
        return Objects.equals(this.myRootSettings, mapping.myRootSettings);
    }

    public int hashCode() {
        int result = this.myDirectory.hashCode();
        result = 31 * result + (this.myVcs != null ? this.myVcs.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.isDefaultMapping() ? PROJECT_CONSTANT : this.myDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsDirectoryMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsDirectoryMapping";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "systemIndependentPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDefault";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

