/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.process;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.TimeUnit;

public abstract class InterruptibleActivity {
    private volatile boolean myIsTouched = true;
    private final long myTimeout;
    private final TimeUnit myTimeUnit;

    protected InterruptibleActivity(long timeout, TimeUnit timeUnit) {
        this.myTimeout = timeout;
        this.myTimeUnit = timeUnit;
    }

    public final void touch() {
        this.myIsTouched = true;
    }

    protected abstract void start();

    protected abstract void interrupt();

    protected abstract int processTimeout();

    public final int execute() {
        Application application = ApplicationManager.getApplication();
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        application.executeOnPooledThread(() -> {
            try {
                this.start();
            }
            finally {
                semaphore.up();
            }
        });
        int rc = this.waitForSemaphore(semaphore);
        if (rc != 0) {
            application.executeOnPooledThread(() -> this.interrupt());
        }
        return rc;
    }

    private int waitForSemaphore(Semaphore semaphore) {
        long idleTime;
        long timeoutMs = this.myTimeUnit.toMillis(this.myTimeout);
        long lastActiveMoment = System.currentTimeMillis();
        do {
            long current = System.currentTimeMillis();
            if (this.myIsTouched) {
                this.myIsTouched = false;
                lastActiveMoment = current;
            }
            if ((idleTime = current - lastActiveMoment) > timeoutMs) {
                int retCode = this.processTimeoutInEDT();
                return semaphore.waitFor(0L) ? 0 : retCode;
            }
            ProgressManager.checkCanceled();
        } while (!semaphore.waitFor(Math.min(500L, timeoutMs - idleTime)));
        return 0;
    }

    protected int processTimeoutInEDT() {
        int[] retcode = new int[1];
        try {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                retcode[0] = this.processTimeout();
                return retcode[0];
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retcode[0];
    }
}

