/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommandLineWrapperUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentFactory;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promises;

public final class JdkUtil {
    public static final Key<Map<String, String>> COMMAND_LINE_CONTENT = Key.create((String)"command.line.content");
    public static final String PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL = "idea.do.not.escape.classpath.url";
    private static final String WRAPPER_CLASS = "com.intellij.rt.execution.CommandLineWrapper";
    private static final String JAVAAGENT = "-javaagent";
    private static final Logger LOG = Logger.getInstance(JdkUtil.class);

    private JdkUtil() {
    }

    @Nullable
    public static String getJdkMainAttribute(@NotNull Sdk jdk, @NotNull Attributes.Name attribute) {
        File signatureJar;
        String homePath;
        String versionString;
        if (jdk == null) {
            JdkUtil.$$$reportNull$$$0(0);
        }
        if (attribute == null) {
            JdkUtil.$$$reportNull$$$0(1);
        }
        if (attribute == Attributes.Name.IMPLEMENTATION_VERSION && (versionString = jdk.getVersionString()) != null) {
            int start = versionString.indexOf(34);
            int end = versionString.lastIndexOf(34);
            if (start >= 0 && end > start) {
                return versionString.substring(start + 1, end);
            }
        }
        if ((homePath = jdk.getHomePath()) != null && (signatureJar = FileUtil.findFirstThatExist((String[])new String[]{homePath + "/jre/lib/rt.jar", homePath + "/lib/rt.jar", homePath + "/lib/jrt-fs.jar", homePath + "/jre/lib/vm.jar", homePath + "/../Classes/classes.jar"})) != null) {
            return JarUtil.getJarAttribute((File)signatureJar, (Attributes.Name)attribute);
        }
        return null;
    }

    @Nullable
    public static String suggestJdkName(@Nullable String versionString) {
        JavaVersion version = JavaVersion.tryParse((String)versionString);
        if (version == null) {
            return null;
        }
        StringBuilder suggested = new StringBuilder();
        if (version.feature < 9) {
            suggested.append("1.");
        }
        suggested.append(version.feature);
        if (version.ea) {
            suggested.append("-ea");
        }
        return suggested.toString();
    }

    public static boolean checkForJdk(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(2);
        }
        return JdkUtil.checkForJdk(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJdk(@NotNull File homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(3);
        }
        return (new File(homePath, "bin/javac").isFile() || new File(homePath, "bin/javac.exe").isFile()) && JdkUtil.checkForRuntime(homePath.getAbsolutePath());
    }

    public static boolean checkForJre(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(4);
        }
        return JdkUtil.checkForJre(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJre(@NotNull File homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(5);
        }
        return new File(homePath, "bin/java").isFile() || new File(homePath, "bin/java.exe").isFile();
    }

    public static boolean checkForRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(6);
        }
        return new File(homePath, "jre/lib/rt.jar").exists() || new File(homePath, "lib/rt.jar").exists() || JdkUtil.isModularRuntime(homePath) || new File(homePath, "../Classes/classes.jar").exists() || new File(homePath, "jre/lib/vm.jar").exists() || new File(homePath, "classes").isDirectory();
    }

    public static boolean isModularRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(7);
        }
        return JdkUtil.isModularRuntime(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean isModularRuntime(@NotNull File homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(8);
        }
        return new File(homePath, "lib/jrt-fs.jar").isFile() || JdkUtil.isExplodedModularRuntime(homePath.getPath());
    }

    public static boolean isExplodedModularRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(9);
        }
        return new File(homePath, "modules/java.base").isDirectory();
    }

    @ApiStatus.Internal
    @NotNull
    public static TargetedCommandLineBuilder setupJVMCommandLine(@NotNull SimpleJavaParameters javaParameters, @NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration targetConfiguration) throws CantRunException {
        JavaLanguageRuntimeConfiguration javaConfiguration;
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(10);
        }
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(11);
        }
        TargetedCommandLineBuilder commandLine = new TargetedCommandLineBuilder();
        JavaLanguageRuntimeConfiguration javaLanguageRuntimeConfiguration = javaConfiguration = targetConfiguration != null ? targetConfiguration.getRuntimes().findByType(JavaLanguageRuntimeConfiguration.class) : null;
        if (request instanceof LocalTargetEnvironmentRequest || targetConfiguration == null) {
            Sdk jdk = javaParameters.getJdk();
            if (jdk == null) {
                throw new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0]));
            }
            SdkTypeId type = jdk.getSdkType();
            if (!(type instanceof JavaSdkType)) {
                throw new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0]));
            }
            String exePath = ((JavaSdkType)((Object)type)).getVMExecutablePath(jdk);
            if (exePath == null) {
                throw new CantRunException(ExecutionBundle.message("run.configuration.cannot.find.vm.executable", new Object[0]));
            }
            commandLine.setExePath(exePath);
        } else {
            if (javaConfiguration == null) {
                throw new CantRunException("Cannot find Java configuration in " + targetConfiguration.getDisplayName() + " target");
            }
            Platform platform = request.getTargetPlatform().getPlatform();
            String java = platform == Platform.WINDOWS ? "java.exe" : "java";
            commandLine.setExePath(StringUtil.join((String[])new String[]{javaConfiguration.getHomePath(), "bin", java}, (String)String.valueOf(platform.fileSeparator)));
        }
        JdkUtil.setupCommandLine(commandLine, request, javaParameters, javaConfiguration);
        TargetedCommandLineBuilder targetedCommandLineBuilder = commandLine;
        if (targetedCommandLineBuilder == null) {
            JdkUtil.$$$reportNull$$$0(12);
        }
        return targetedCommandLineBuilder;
    }

    @NotNull
    public static GeneralCommandLine setupJVMCommandLine(@NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(13);
        }
        LocalTargetEnvironmentFactory environmentFactory = new LocalTargetEnvironmentFactory();
        TargetEnvironmentRequest request = environmentFactory.createRequest();
        GeneralCommandLine generalCommandLine = environmentFactory.prepareRemoteEnvironment(request, new EmptyProgressIndicator()).createGeneralCommandLine(JdkUtil.setupJVMCommandLine(javaParameters, request, null).build());
        if (generalCommandLine == null) {
            JdkUtil.$$$reportNull$$$0(14);
        }
        return generalCommandLine;
    }

    private static void setupCommandLine(@NotNull TargetedCommandLineBuilder commandLine, @NotNull TargetEnvironmentRequest request, @NotNull SimpleJavaParameters javaParameters, @Nullable JavaLanguageRuntimeConfiguration runtimeConfiguration) throws CantRunException {
        String workingDirectory;
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(15);
        }
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(16);
        }
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(17);
        }
        if ((workingDirectory = javaParameters.getWorkingDirectory()) != null) {
            commandLine.setWorkingDirectory(request.createUpload(workingDirectory));
        }
        javaParameters.getEnv().forEach((key, value) -> commandLine.addEnvironmentVariable((String)key, (String)value));
        if (request instanceof LocalTargetEnvironmentRequest) {
            GeneralCommandLine.ParentEnvironmentType type = javaParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE;
            ((LocalTargetEnvironmentRequest)request).setParentEnvironmentType(type);
        }
        ParametersList vmParameters = javaParameters.getVMParametersList();
        boolean dynamicClasspath = javaParameters.isDynamicClasspath();
        boolean dynamicVMOptions = dynamicClasspath && javaParameters.isDynamicVMOptions() && JdkUtil.useDynamicVMOptions();
        boolean dynamicParameters = dynamicClasspath && javaParameters.isDynamicParameters() && JdkUtil.useDynamicParameters();
        boolean dynamicMainClass = false;
        if (JdkUtil.isUrlClassloader(vmParameters)) {
            if (!(request instanceof LocalTargetEnvironmentRequest)) {
                throw new CantRunException("Cannot run application with UrlClassPath on the remote target.");
            }
            for (String string : vmParameters.getParameters()) {
                if (!string.startsWith(JAVAAGENT)) continue;
                int agentArgsIdx = string.indexOf("=", JAVAAGENT.length());
                javaParameters.getClassPath().addFirst(string.substring(JAVAAGENT.length() + 1, agentArgsIdx > -1 ? agentArgsIdx : string.length()));
            }
        }
        if (dynamicClasspath) {
            Class<?> clazz;
            Charset cs = StandardCharsets.UTF_8;
            if (javaParameters.isArgFile()) {
                JdkUtil.setArgFileParams(commandLine, request, runtimeConfiguration, javaParameters, vmParameters, dynamicVMOptions, dynamicParameters, cs);
                dynamicMainClass = dynamicParameters;
            } else if (!JdkUtil.explicitClassPath(vmParameters) && javaParameters.getJarPath() == null && (clazz = JdkUtil.getCommandLineWrapperClass()) != null) {
                if (javaParameters.isUseClasspathJar()) {
                    JdkUtil.setClasspathJarParams(commandLine, request, runtimeConfiguration, javaParameters, vmParameters, clazz, dynamicVMOptions, dynamicParameters);
                } else if (javaParameters.isClasspathFile()) {
                    JdkUtil.setCommandLineWrapperParams(commandLine, request, runtimeConfiguration, javaParameters, vmParameters, clazz, dynamicVMOptions, dynamicParameters, cs);
                }
            } else {
                dynamicParameters = false;
                dynamicClasspath = false;
            }
        }
        if (!dynamicClasspath) {
            JdkUtil.appendParamsEncodingClasspath(commandLine, request, runtimeConfiguration, javaParameters, vmParameters);
        }
        if (!dynamicMainClass) {
            for (TargetValue targetValue : JdkUtil.getMainClassParams(javaParameters, request)) {
                commandLine.addParameter(targetValue);
            }
        }
        if (!dynamicParameters) {
            for (String string : javaParameters.getProgramParametersList().getList()) {
                commandLine.addParameter(string);
            }
        }
    }

    private static void setupCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(18);
        }
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(19);
        }
        TargetedCommandLineBuilder targetedCommandLineBuilder = new TargetedCommandLineBuilder();
        LocalTargetEnvironmentFactory environmentFactory = new LocalTargetEnvironmentFactory();
        TargetEnvironmentRequest request = environmentFactory.createRequest();
        JdkUtil.setupCommandLine(targetedCommandLineBuilder, request, javaParameters, null);
        LocalTargetEnvironment environment = environmentFactory.prepareRemoteEnvironment(request, new EmptyProgressIndicator());
        GeneralCommandLine generalCommandLine = environment.createGeneralCommandLine(targetedCommandLineBuilder.build());
        commandLine.withParentEnvironmentType(javaParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        commandLine.getParametersList().addAll(generalCommandLine.getParametersList().getList());
        commandLine.getEnvironment().putAll(generalCommandLine.getEnvironment());
    }

    private static boolean isUrlClassloader(ParametersList vmParameters) {
        return UrlClassLoader.class.getName().equals(vmParameters.getPropertyValue("java.system.class.loader"));
    }

    private static boolean explicitClassPath(ParametersList vmParameters) {
        return vmParameters.hasParameter("-cp") || vmParameters.hasParameter("-classpath") || vmParameters.hasParameter("--class-path");
    }

    private static boolean explicitModulePath(ParametersList vmParameters) {
        return vmParameters.hasParameter("-p") || vmParameters.hasParameter("--module-path");
    }

    private static void setArgFileParams(@NotNull TargetedCommandLineBuilder commandLine, @NotNull TargetEnvironmentRequest request, @Nullable JavaLanguageRuntimeConfiguration runtimeConfiguration, @NotNull SimpleJavaParameters javaParameters, @NotNull ParametersList vmParameters, boolean dynamicVMOptions, boolean dynamicParameters, Charset cs) throws CantRunException {
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(20);
        }
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(21);
        }
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(22);
        }
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(23);
        }
        try {
            TargetValue modulePathParameter;
            TargetValue classPathParameter;
            Platform platform = request.getTargetPlatform().getPlatform();
            String pathSeparator = String.valueOf(platform.pathSeparator);
            ArrayList promises = new ArrayList();
            PathsList classPath = javaParameters.getClassPath();
            if (!classPath.isEmpty() && !JdkUtil.explicitClassPath(vmParameters)) {
                List pathValues = JdkUtil.getClassPathValues(request, runtimeConfiguration, javaParameters);
                classPathParameter = TargetValue.composite(pathValues, values -> StringUtil.join((Collection)values, (String)pathSeparator));
                promises.add(classPathParameter.getTargetValue());
            } else {
                classPathParameter = null;
            }
            PathsList modulePath = javaParameters.getModulePath();
            if (!modulePath.isEmpty() && !JdkUtil.explicitModulePath(vmParameters)) {
                List pathValues = JdkUtil.getClassPathValues(request, runtimeConfiguration, javaParameters);
                modulePathParameter = TargetValue.composite(pathValues, values -> StringUtil.join((Collection)values, (String)pathSeparator));
                promises.add(modulePathParameter.getTargetValue());
            } else {
                modulePathParameter = null;
            }
            List mainClassParameters = dynamicParameters ? JdkUtil.getMainClassParams(javaParameters, request) : Collections.emptyList();
            promises.addAll(ContainerUtil.map(mainClassParameters, TargetValue::getTargetValue));
            File argFile = FileUtil.createTempFile((String)("idea_arg_file" + new Random().nextInt(Integer.MAX_VALUE)), null);
            commandLine.addFileToDeleteOnTermination(argFile);
            Promises.collectResults(promises).onSuccess(__ -> {
                ArrayList<String> fileArgs = new ArrayList<String>();
                if (dynamicVMOptions) {
                    fileArgs.addAll(vmParameters.getList());
                } else {
                    JdkUtil.appendVmParameters(commandLine, request, vmParameters);
                }
                try {
                    if (classPathParameter != null) {
                        fileArgs.add("-classpath");
                        fileArgs.add((String)classPathParameter.getTargetValue().blockingGet(0));
                    }
                    if (modulePathParameter != null) {
                        fileArgs.add("-p");
                        fileArgs.add((String)modulePathParameter.getTargetValue().blockingGet(0));
                    }
                    for (TargetValue mainClassParameter : mainClassParameters) {
                        fileArgs.add((String)mainClassParameter.getTargetValue().blockingGet(0));
                    }
                    if (dynamicParameters) {
                        fileArgs.addAll(javaParameters.getProgramParametersList().getList());
                    }
                    CommandLineWrapperUtil.writeArgumentsFile((File)argFile, fileArgs, (String)platform.lineSeparator, (Charset)cs);
                }
                catch (IOException iOException) {
                }
                catch (ExecutionException | TimeoutException e) {
                    LOG.error("Couldn't resolve target value", (Throwable)e);
                }
            });
            HashMap<String, String> commandLineContent = new HashMap<String, String>();
            commandLine.putUserData(COMMAND_LINE_CONTENT, commandLineContent);
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            TargetValue<String> argFileParameter = request.createUpload(argFile.getAbsolutePath());
            commandLine.addParameter(TargetValue.map(argFileParameter, s -> "@" + s));
            JdkUtil.addCommandLineContentOnResolve(commandLineContent, argFile, argFileParameter);
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    private static void setCommandLineWrapperParams(@NotNull TargetedCommandLineBuilder commandLine, @NotNull TargetEnvironmentRequest request, @Nullable JavaLanguageRuntimeConfiguration runtimeConfiguration, @NotNull SimpleJavaParameters javaParameters, @NotNull ParametersList vmParameters, @NotNull Class<?> commandLineWrapper, boolean dynamicVMOptions, boolean dynamicParameters, Charset cs) throws CantRunException {
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(24);
        }
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(25);
        }
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(26);
        }
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(27);
        }
        if (commandLineWrapper == null) {
            JdkUtil.$$$reportNull$$$0(28);
        }
        try {
            String lineSeparator = request.getTargetPlatform().getPlatform().lineSeparator;
            int pseudoUniquePrefix = new Random().nextInt(Integer.MAX_VALUE);
            File vmParamsFile = null;
            if (dynamicVMOptions) {
                ArrayList<String> toWrite = new ArrayList<String>();
                for (String param : vmParameters.getList()) {
                    if (JdkUtil.isUserDefinedProperty(param)) {
                        toWrite.add(param);
                        continue;
                    }
                    JdkUtil.appendVmParameter(commandLine, request, param);
                }
                if (!toWrite.isEmpty()) {
                    vmParamsFile = FileUtil.createTempFile((String)("idea_vm_params" + pseudoUniquePrefix), null);
                    commandLine.addFileToDeleteOnTermination(vmParamsFile);
                    CommandLineWrapperUtil.writeWrapperFile((File)vmParamsFile, toWrite, (String)lineSeparator, (Charset)cs);
                }
            } else {
                JdkUtil.appendVmParameters(commandLine, request, vmParameters);
            }
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            File appParamsFile = null;
            if (dynamicParameters) {
                appParamsFile = FileUtil.createTempFile((String)("idea_app_params" + pseudoUniquePrefix), null);
                commandLine.addFileToDeleteOnTermination(appParamsFile);
                CommandLineWrapperUtil.writeWrapperFile((File)appParamsFile, (List)javaParameters.getProgramParametersList().getList(), (String)lineSeparator, (Charset)cs);
            }
            File classpathFile = FileUtil.createTempFile((String)("idea_classpath" + pseudoUniquePrefix), null);
            commandLine.addFileToDeleteOnTermination(classpathFile);
            List<TargetValue<String>> classPathParameters = JdkUtil.getClassPathValues(request, runtimeConfiguration, javaParameters);
            Promises.collectResults((Collection)ContainerUtil.map(classPathParameters, TargetValue::getTargetValue)).onSuccess(pathList -> {
                try {
                    CommandLineWrapperUtil.writeWrapperFile((File)classpathFile, (List)pathList, (String)lineSeparator, (Charset)cs);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            LinkedHashSet classpath = new LinkedHashSet();
            classpath.add(request.createUpload(PathUtil.getJarPathForClass(commandLineWrapper)));
            if (JdkUtil.isUrlClassloader(vmParameters)) {
                if (!(request instanceof LocalTargetEnvironmentRequest)) {
                    throw new CantRunException("Cannot run application with UrlClassPath on the remote target.");
                }
                classpath.add(TargetValue.fixed(PathUtil.getJarPathForClass(UrlClassLoader.class)));
                classpath.add(TargetValue.fixed(PathUtil.getJarPathForClass(StringUtilRt.class)));
                classpath.add(TargetValue.fixed(PathUtil.getJarPathForClass(THashMap.class)));
                Sdk jdk = javaParameters.getJdk();
                if (jdk != null) {
                    for (VirtualFile file : jdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                        String path2 = PathUtil.getLocalPath(file);
                        if (!StringUtil.isNotEmpty((String)path2)) continue;
                        classpath.add(TargetValue.fixed(path2));
                    }
                }
            }
            commandLine.addParameter("-classpath");
            String pathSeparator = String.valueOf(request.getTargetPlatform().getPlatform().pathSeparator);
            commandLine.addParameter(TargetValue.composite(classpath, values -> StringUtil.join((Collection)values, (String)pathSeparator)));
            commandLine.addParameter(commandLineWrapper.getName());
            HashMap<String, String> commandLineContent = new HashMap<String, String>();
            commandLine.putUserData(COMMAND_LINE_CONTENT, commandLineContent);
            TargetValue<String> classPathParameter = request.createUpload(classpathFile.getAbsolutePath());
            commandLine.addParameter(classPathParameter);
            JdkUtil.addCommandLineContentOnResolve(commandLineContent, classpathFile, classPathParameter);
            if (vmParamsFile != null) {
                commandLine.addParameter("@vm_params");
                TargetValue<String> vmParamsParameter = request.createUpload(vmParamsFile.getAbsolutePath());
                commandLine.addParameter(vmParamsParameter);
                JdkUtil.addCommandLineContentOnResolve(commandLineContent, vmParamsFile, vmParamsParameter);
            }
            if (appParamsFile != null) {
                commandLine.addParameter("@app_params");
                TargetValue<String> appParamsParameter = request.createUpload(appParamsFile.getAbsolutePath());
                commandLine.addParameter(appParamsParameter);
                JdkUtil.addCommandLineContentOnResolve(commandLineContent, appParamsFile, appParamsParameter);
            }
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    private static void addCommandLineContentOnResolve(@NotNull Map<String, String> commandLineContent, @NotNull File localFile, @NotNull TargetValue<String> value) {
        if (commandLineContent == null) {
            JdkUtil.$$$reportNull$$$0(29);
        }
        if (localFile == null) {
            JdkUtil.$$$reportNull$$$0(30);
        }
        if (value == null) {
            JdkUtil.$$$reportNull$$$0(31);
        }
        value.getTargetValue().onSuccess(resolved -> {
            try {
                commandLineContent.put((String)resolved, FileUtil.loadFile((File)localFile));
            }
            catch (IOException e) {
                LOG.error("Cannot add command line content for value " + resolved, (Throwable)e);
            }
        });
    }

    private static void setClasspathJarParams(@NotNull TargetedCommandLineBuilder commandLine, @NotNull TargetEnvironmentRequest request, @Nullable JavaLanguageRuntimeConfiguration runtimeConfiguration, @NotNull SimpleJavaParameters javaParameters, @NotNull ParametersList vmParameters, @NotNull Class<?> commandLineWrapper, boolean dynamicVMOptions, boolean dynamicParameters) throws CantRunException {
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(32);
        }
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(33);
        }
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(34);
        }
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(35);
        }
        if (commandLineWrapper == null) {
            JdkUtil.$$$reportNull$$$0(36);
        }
        try {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().putValue("Created-By", ApplicationNamesInfo.getInstance().getFullProductName());
            String manifestText = "";
            if (dynamicVMOptions) {
                ArrayList<String> properties = new ArrayList<String>();
                for (String param : vmParameters.getList()) {
                    if (JdkUtil.isUserDefinedProperty(param)) {
                        properties.add(param);
                        continue;
                    }
                    JdkUtil.appendVmParameter(commandLine, request, param);
                }
                manifest.getMainAttributes().putValue("VM-Options", ParametersListUtil.join(properties));
                manifestText = manifestText + "VM-Options: " + ParametersListUtil.join(properties) + "\n";
            } else {
                JdkUtil.appendVmParameters(commandLine, request, vmParameters);
            }
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            if (dynamicParameters) {
                manifest.getMainAttributes().putValue("Program-Parameters", ParametersListUtil.join((List)javaParameters.getProgramParametersList().getList()));
                manifestText = manifestText + "Program-Parameters: " + ParametersListUtil.join((List)javaParameters.getProgramParametersList().getList()) + "\n";
            }
            String jarFileContentPrefix = manifestText + "Class-Path: ";
            HashMap commandLineContent = new HashMap();
            commandLine.putUserData(COMMAND_LINE_CONTENT, commandLineContent);
            File classpathJarFile = FileUtil.createTempFile((String)("classpath" + Math.abs(new Random().nextInt())), (String)".jar", (boolean)true);
            commandLine.addFileToDeleteOnTermination(classpathJarFile);
            String jarFilePath = classpathJarFile.getAbsolutePath();
            commandLine.addParameter("-classpath");
            if (dynamicVMOptions || dynamicParameters) {
                char pathSeparator = request.getTargetPlatform().getPlatform().pathSeparator;
                commandLine.addParameter(request.createUpload(PathUtil.getJarPathForClass(commandLineWrapper) + pathSeparator + jarFilePath));
                commandLine.addParameter(request.createUpload(commandLineWrapper.getName()));
            }
            TargetValue<String> jarFileValue = request.createUpload(jarFilePath);
            commandLine.addParameter(jarFileValue);
            List<TargetValue<String>> classPathParameters = JdkUtil.getClassPathValues(request, runtimeConfiguration, javaParameters);
            Promises.collectResults((Collection)ContainerUtil.map(classPathParameters, TargetValue::getTargetValue)).onSuccess(targetClassPathParameters -> {
                try {
                    boolean notEscape = vmParameters.hasParameter(PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL);
                    StringBuilder classPath = new StringBuilder();
                    for (TargetValue parameter : classPathParameters) {
                        if (classPath.length() > 0) {
                            classPath.append(' ');
                        }
                        String localValue = (String)parameter.getLocalValue().blockingGet(0);
                        String targetValue = (String)parameter.getTargetValue().blockingGet(0);
                        if (targetValue == null || localValue == null) {
                            throw new ExecutionException("Couldn't resolve target value", null);
                        }
                        File file = new File(targetValue);
                        String url = (notEscape ? file.toURL() : file.toURI().toURL()).toString();
                        classPath.append(!StringUtil.endsWithChar((CharSequence)url, (char)'/') && new File(localValue).isDirectory() ? url + "/" : url);
                    }
                    CommandLineWrapperUtil.fillClasspathJarFile((Manifest)manifest, (String)classPath.toString(), (File)classpathJarFile);
                    jarFileValue.getTargetValue().onSuccess(value -> commandLineContent.put(value, jarFileContentPrefix + classPath.toString()));
                }
                catch (IOException | ExecutionException notEscape) {
                }
                catch (TimeoutException e) {
                    LOG.error("Couldn't resolve target value", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    private static boolean isUserDefinedProperty(String param) {
        return param.startsWith("-D") && !param.startsWith("-Dsun.") && !param.startsWith("-Djava.");
    }

    private static void throwUnableToCreateTempFile(IOException cause) throws CantRunException {
        throw new CantRunException("Failed to create a temporary file in " + FileUtilRt.getTempDirectory(), cause);
    }

    private static void appendParamsEncodingClasspath(@NotNull TargetedCommandLineBuilder commandLine, @NotNull TargetEnvironmentRequest request, @Nullable JavaLanguageRuntimeConfiguration runtimeConfiguration, @NotNull SimpleJavaParameters javaParameters, @NotNull ParametersList vmParameters) {
        PathsList modulePath;
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(37);
        }
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(38);
        }
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(39);
        }
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(40);
        }
        JdkUtil.appendVmParameters(commandLine, request, vmParameters);
        JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
        PathsList classPath = javaParameters.getClassPath();
        if (!classPath.isEmpty() && !JdkUtil.explicitClassPath(vmParameters)) {
            commandLine.addParameter("-classpath");
            List pathValues = JdkUtil.getClassPathValues(request, runtimeConfiguration, javaParameters);
            String pathSeparator = String.valueOf(request.getTargetPlatform().getPlatform().pathSeparator);
            commandLine.addParameter(TargetValue.composite(pathValues, values -> StringUtil.join((Collection)values, (String)pathSeparator)));
        }
        if (!(modulePath = javaParameters.getModulePath()).isEmpty() && !JdkUtil.explicitModulePath(vmParameters)) {
            commandLine.addParameter("-p");
            commandLine.addParameter(modulePath.getPathsString());
        }
    }

    private static void appendVmParameters(@NotNull TargetedCommandLineBuilder commandLine, @NotNull TargetEnvironmentRequest request, @NotNull ParametersList vmParameters) {
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(41);
        }
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(42);
        }
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(43);
        }
        for (String vmParameter : vmParameters.getList()) {
            JdkUtil.appendVmParameter(commandLine, request, vmParameter);
        }
    }

    private static void appendVmParameter(@NotNull TargetedCommandLineBuilder commandLine, @NotNull TargetEnvironmentRequest request, @NotNull String vmParameter) {
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(44);
        }
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(45);
        }
        if (vmParameter == null) {
            JdkUtil.$$$reportNull$$$0(46);
        }
        if (request instanceof LocalTargetEnvironmentRequest || SystemProperties.getBooleanProperty((String)"remote.servers.ignore.vm.parameter", (boolean)false)) {
            commandLine.addParameter(vmParameter);
            return;
        }
        if (vmParameter.startsWith("-agentpath:")) {
            JdkUtil.appendVmAgentParameter(commandLine, request, vmParameter, "-agentpath:");
        } else if (vmParameter.startsWith("-javaagent:")) {
            JdkUtil.appendVmAgentParameter(commandLine, request, vmParameter, "-javaagent:");
        } else {
            commandLine.addParameter(vmParameter);
        }
    }

    private static void appendVmAgentParameter(@NotNull TargetedCommandLineBuilder commandLine, @NotNull TargetEnvironmentRequest request, @NotNull String vmParameter, @NotNull String prefix) {
        String value;
        int equalsSign;
        String path2;
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(47);
        }
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(48);
        }
        if (vmParameter == null) {
            JdkUtil.$$$reportNull$$$0(49);
        }
        if (prefix == null) {
            JdkUtil.$$$reportNull$$$0(50);
        }
        String string = path2 = (equalsSign = (value = StringUtil.trimStart((String)vmParameter, (String)prefix)).indexOf(61)) > -1 ? value.substring(0, equalsSign) : value;
        if (!path2.endsWith(".jar")) {
            return;
        }
        String suffix = equalsSign > -1 ? value.substring(equalsSign) : "";
        commandLine.addParameter(TargetValue.map(request.createUpload(path2), v -> prefix + v + suffix));
    }

    @NotNull
    private static List<TargetValue<String>> getClassPathValues(@NotNull TargetEnvironmentRequest request, @Nullable JavaLanguageRuntimeConfiguration runtimeConfiguration, @NotNull SimpleJavaParameters javaParameters) {
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(51);
        }
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(52);
        }
        String localJdkPath = (String)ObjectUtils.doIfNotNull((Object)javaParameters.getJdk(), jdk -> jdk.getHomePath());
        String remoteJdkPath = runtimeConfiguration != null ? runtimeConfiguration.getHomePath() : null;
        ArrayList<TargetValue<String>> result = new ArrayList<TargetValue<String>>();
        for (String path2 : javaParameters.getClassPath().getPathList()) {
            if (localJdkPath == null || remoteJdkPath == null || !path2.startsWith(localJdkPath)) {
                result.add(request.createUpload(path2));
                continue;
            }
            char separator = request.getTargetPlatform().getPlatform().fileSeparator;
            result.add(TargetValue.fixed(FileUtil.toCanonicalPath((String)(remoteJdkPath + separator + StringUtil.trimStart((String)path2, (String)localJdkPath)), (char)separator)));
        }
        ArrayList<TargetValue<String>> arrayList = result;
        if (arrayList == null) {
            JdkUtil.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    private static void appendEncoding(@NotNull SimpleJavaParameters javaParameters, @NotNull TargetedCommandLineBuilder commandLine, @NotNull ParametersList parametersList) {
        String encoding;
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(54);
        }
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(55);
        }
        if (parametersList == null) {
            JdkUtil.$$$reportNull$$$0(56);
        }
        if ((encoding = parametersList.getPropertyValue("file.encoding")) == null) {
            Charset charset = javaParameters.getCharset();
            if (charset == null) {
                charset = EncodingManager.getInstance().getDefaultCharset();
            }
            commandLine.addParameter("-Dfile.encoding=" + charset.name());
            commandLine.setCharset(charset);
        } else {
            try {
                commandLine.setCharset(Charset.forName(encoding));
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static List<TargetValue<String>> getMainClassParams(SimpleJavaParameters javaParameters, @NotNull TargetEnvironmentRequest request) throws CantRunException {
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(57);
        }
        String mainClass = javaParameters.getMainClass();
        String moduleName = javaParameters.getModuleName();
        String jarPath = javaParameters.getJarPath();
        if (mainClass != null && moduleName != null) {
            return Arrays.asList(TargetValue.fixed("-m"), TargetValue.fixed(moduleName + '/' + mainClass));
        }
        if (mainClass != null) {
            return Collections.singletonList(TargetValue.fixed(mainClass));
        }
        if (jarPath != null) {
            return Arrays.asList(TargetValue.fixed("-jar"), request.createUpload(jarPath));
        }
        throw new CantRunException(ExecutionBundle.message("main.class.is.not.specified.error.message", new Object[0]));
    }

    @Nullable
    private static Class<?> getCommandLineWrapperClass() {
        try {
            return Class.forName(WRAPPER_CLASS);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean useDynamicClasspath(@Nullable Project project) {
        boolean hasDynamicProperty = Boolean.parseBoolean(System.getProperty("idea.dynamic.classpath", "false"));
        return project != null ? PropertiesComponent.getInstance(project).getBoolean("dynamic.classpath", hasDynamicProperty) : hasDynamicProperty;
    }

    public static boolean useDynamicVMOptions() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.vmoptions", true);
    }

    public static boolean useDynamicParameters() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.parameters", true);
    }

    public static boolean useClasspathJar() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.classpath.jar", true);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static GeneralCommandLine setupJVMCommandLine(String exePath, SimpleJavaParameters javaParameters, boolean forceDynamicClasspath) {
        try {
            javaParameters.setUseDynamicClasspath(forceDynamicClasspath);
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{exePath});
            JdkUtil.setupCommandLine(commandLine, javaParameters);
            return commandLine;
        }
        catch (CantRunException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 19: 
            case 22: 
            case 26: 
            case 34: 
            case 39: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 11: 
            case 16: 
            case 21: 
            case 25: 
            case 33: 
            case 38: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 12: 
            case 14: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/JdkUtil";
                break;
            }
            case 15: 
            case 18: 
            case 20: 
            case 24: 
            case 32: 
            case 37: 
            case 41: 
            case 44: 
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 23: 
            case 27: 
            case 35: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmParameters";
                break;
            }
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineWrapper";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineContent";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmParameter";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/JdkUtil";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "setupJVMCommandLine";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPathValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdkMainAttribute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkForJdk";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkForJre";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkForRuntime";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isModularRuntime";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isExplodedModularRuntime";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setupJVMCommandLine";
                break;
            }
            case 12: 
            case 14: 
            case 53: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupCommandLine";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setArgFileParams";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setCommandLineWrapperParams";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addCommandLineContentOnResolve";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setClasspathJarParams";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "appendParamsEncodingClasspath";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "appendVmParameters";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "appendVmParameter";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "appendVmAgentParameter";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getClassPathValues";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "appendEncoding";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getMainClassParams";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

