/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.SmartList;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupElementPresentation {
    private Icon myIcon;
    private Icon myTypeIcon;
    private boolean myTypeIconRightAligned;
    private String myItemText;
    private String myTypeText;
    private boolean myStrikeout;
    private Color myItemTextForeground = JBColor.namedColor((String)"CompletionPopup.foreground", (Color)JBColor.foreground());
    private boolean myItemTextBold;
    private boolean myItemTextUnderlined;
    private boolean myItemTextItalic;
    private boolean myTypeGrayed;
    @Nullable
    private List<TextFragment> myTail;

    public void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
    }

    public void setItemText(@Nullable String text) {
        this.myItemText = text;
    }

    public void setStrikeout(boolean strikeout) {
        this.myStrikeout = strikeout;
    }

    public void setItemTextBold(boolean bold) {
        this.myItemTextBold = bold;
    }

    public void setItemTextItalic(boolean itemTextItalic) {
        this.myItemTextItalic = itemTextItalic;
    }

    public void setTailText(@Nullable String text) {
        this.setTailText(text, false);
    }

    public void clearTail() {
        this.myTail = null;
    }

    public void appendTailText(@NotNull String text, boolean grayed) {
        if (text == null) {
            LookupElementPresentation.$$$reportNull$$$0(0);
        }
        this.appendTailText(new TextFragment(text, grayed, false, null));
    }

    public void appendTailTextItalic(@NotNull String text, boolean grayed) {
        if (text == null) {
            LookupElementPresentation.$$$reportNull$$$0(1);
        }
        this.appendTailText(new TextFragment(text, grayed, true, null));
    }

    private void appendTailText(@NotNull TextFragment fragment) {
        if (fragment == null) {
            LookupElementPresentation.$$$reportNull$$$0(2);
        }
        if (this.myTail == null) {
            this.myTail = new SmartList();
        }
        this.myTail.add(fragment);
    }

    public void setTailText(@Nullable String text, boolean grayed) {
        this.clearTail();
        if (text != null) {
            this.appendTailText(new TextFragment(text, grayed, false, null));
        }
    }

    public void setTailText(@Nullable String text, @Nullable Color foreground) {
        this.clearTail();
        if (text != null) {
            this.appendTailText(new TextFragment(text, false, false, foreground));
        }
    }

    public void setTypeText(@Nullable String text) {
        this.setTypeText(text, null);
    }

    public void setTypeText(@Nullable String text, @Nullable Icon icon) {
        this.myTypeText = text;
        this.myTypeIcon = icon;
    }

    public boolean isReal() {
        return false;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public Icon getTypeIcon() {
        return this.myTypeIcon;
    }

    @Nullable
    public String getItemText() {
        return this.myItemText;
    }

    @NotNull
    public List<TextFragment> getTailFragments() {
        List<TextFragment> list = this.myTail == null ? Collections.emptyList() : Collections.unmodifiableList(this.myTail);
        if (list == null) {
            LookupElementPresentation.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public String getTailText() {
        if (this.myTail == null) {
            return null;
        }
        return StringUtil.join(this.myTail, fragment -> fragment.text, (String)"");
    }

    @Nullable
    public String getTypeText() {
        return this.myTypeText;
    }

    public boolean isStrikeout() {
        return this.myStrikeout;
    }

    @Deprecated
    public boolean isTailGrayed() {
        return this.myTail != null && this.myTail.get(0).myGrayed;
    }

    public boolean isItemTextBold() {
        return this.myItemTextBold;
    }

    public boolean isItemTextItalic() {
        return this.myItemTextItalic;
    }

    public boolean isItemTextUnderlined() {
        return this.myItemTextUnderlined;
    }

    public void setItemTextUnderlined(boolean itemTextUnderlined) {
        this.myItemTextUnderlined = itemTextUnderlined;
    }

    @NotNull
    public Color getItemTextForeground() {
        Color color = this.myItemTextForeground;
        if (color == null) {
            LookupElementPresentation.$$$reportNull$$$0(4);
        }
        return color;
    }

    public void setItemTextForeground(@NotNull Color itemTextForeground) {
        if (itemTextForeground == null) {
            LookupElementPresentation.$$$reportNull$$$0(5);
        }
        this.myItemTextForeground = itemTextForeground;
    }

    public void copyFrom(@NotNull LookupElementPresentation presentation) {
        if (presentation == null) {
            LookupElementPresentation.$$$reportNull$$$0(6);
        }
        this.myIcon = presentation.myIcon;
        this.myTypeIcon = presentation.myTypeIcon;
        this.myItemText = presentation.myItemText;
        List<TextFragment> thatTail = presentation.myTail;
        this.myTail = thatTail == null ? null : new SmartList(thatTail);
        this.myTypeText = presentation.myTypeText;
        this.myStrikeout = presentation.myStrikeout;
        this.myItemTextBold = presentation.myItemTextBold;
        this.myItemTextItalic = presentation.myItemTextItalic;
        this.myTypeGrayed = presentation.myTypeGrayed;
        this.myTypeIconRightAligned = presentation.myTypeIconRightAligned;
        this.myItemTextUnderlined = presentation.myItemTextUnderlined;
        this.myItemTextForeground = presentation.myItemTextForeground;
    }

    public boolean isTypeGrayed() {
        return this.myTypeGrayed;
    }

    public void setTypeGrayed(boolean typeGrayed) {
        this.myTypeGrayed = typeGrayed;
    }

    public boolean isTypeIconRightAligned() {
        return this.myTypeIconRightAligned;
    }

    public void setTypeIconRightAligned(boolean typeIconRightAligned) {
        this.myTypeIconRightAligned = typeIconRightAligned;
    }

    public static LookupElementPresentation renderElement(LookupElement element) {
        LookupElementPresentation presentation = new LookupElementPresentation();
        element.renderElement(presentation);
        return presentation;
    }

    public String toString() {
        return "LookupElementPresentation{itemText='" + this.myItemText + '\'' + ", tail=" + this.myTail + ", typeText='" + this.myTypeText + '\'' + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/LookupElementPresentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemTextForeground";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/LookupElementPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTailFragments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemTextForeground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendTailText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendTailTextItalic";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setItemTextForeground";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TextFragment {
        public final String text;
        private final boolean myGrayed;
        private final boolean myItalic;
        @Nullable
        private final Color myFgColor;

        private TextFragment(String text, boolean grayed, boolean italic, @Nullable Color fgColor) {
            this.text = text;
            this.myGrayed = grayed;
            this.myItalic = italic;
            this.myFgColor = fgColor;
        }

        public String toString() {
            return "TextFragment{text='" + this.text + '\'' + (this.myGrayed ? ", grayed" : "") + (this.myItalic ? ", italic" : "") + (this.myFgColor != null ? ", fgColor=" + this.myFgColor : "") + '}';
        }

        public boolean isGrayed() {
            return this.myGrayed;
        }

        public boolean isItalic() {
            return this.myItalic;
        }

        @Nullable
        public Color getForegroundColor() {
            return this.myFgColor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TextFragment)) {
                return false;
            }
            TextFragment fragment = (TextFragment)o;
            return this.myGrayed == fragment.myGrayed && this.myItalic == fragment.myItalic && Objects.equals(this.text, fragment.text) && Objects.equals(this.myFgColor, fragment.myFgColor);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.myGrayed, this.myItalic, this.myFgColor);
        }
    }
}

