/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.util.NotNullFunction;
import com.intellij.util.SofterReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;

public class SofterCache<T, V> {
    private final NotNullFunction<? super T, ? extends V> myValueProvider;
    private SofterReference<ConcurrentMap<T, V>> myCache;

    public SofterCache(NotNullFunction<? super T, ? extends V> valueProvider) {
        this.myValueProvider = valueProvider;
    }

    public static <T, V> SofterCache<T, V> create(NotNullFunction<? super T, ? extends V> valueProvider) {
        return new SofterCache<T, V>(valueProvider);
    }

    public void clearCache() {
        this.myCache = null;
    }

    public V getCachedValue(T key) {
        Object value;
        ConcurrentMap map;
        SofterReference<ConcurrentMap<T, V>> ref = this.myCache;
        ConcurrentMap concurrentMap = map = ref == null ? null : (ConcurrentMap)ref.get();
        if (map == null) {
            map = ContainerUtil.newConcurrentMap();
            this.myCache = new SofterReference((Object)map);
        }
        if ((value = map.get(key)) == null) {
            value = this.myValueProvider.fun(key);
            map.put(key, value);
        }
        return value;
    }
}

