/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointChangeListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionAssignabilityCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.impl.DomFileMetaData;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VisitorDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class DomApplicationComponent {
    private final MultiMap<String, DomFileMetaData> myRootTagName2FileDescription = MultiMap.createSet();
    private final Set<DomFileMetaData> myAcceptingOtherRootTagNamesDescriptions = new THashSet();
    private final ImplementationClassCache myCachedImplementationClasses = new ImplementationClassCache(DomImplementationClassEP.EP_NAME);
    private final TypeChooserManager myTypeChooserManager = new TypeChooserManager();
    final ReflectionAssignabilityCache assignabilityCache = new ReflectionAssignabilityCache();
    private final Map<Class<?>, DomElementsAnnotator> myClass2Annotator = ConcurrentFactoryMap.createMap(key -> {
        DomFileDescription<?> desc = this.findFileDescription((Class<?>)key);
        return desc == null ? null : desc.createAnnotator();
    });
    private final Map<Class<?>, InvocationCache> myInvocationCaches = ConcurrentFactoryMap.create(InvocationCache::new, ContainerUtil::createConcurrentSoftValueMap);
    private final Map<Class<? extends DomElementVisitor>, VisitorDescription> myVisitorDescriptions = ConcurrentFactoryMap.createMap(VisitorDescription::new);

    public DomApplicationComponent() {
        this.registerDescriptions();
        DomApplicationComponent.addChangeListener(DomFileDescription.EP_NAME, this::extensionsChanged);
        DomApplicationComponent.addChangeListener(DomFileMetaData.EP_NAME, this::extensionsChanged);
    }

    private static <T> void addChangeListener(ExtensionPointName<T> ep, ExtensionPointChangeListener onChange) {
        Application app = ApplicationManager.getApplication();
        if (Disposer.isDisposing((Disposable)app)) {
            return;
        }
        ep.addExtensionPointListener(onChange, (Disposable)app);
    }

    private void registerDescriptions() {
        for (DomFileDescription description : DomFileDescription.EP_NAME.getExtensionList()) {
            this.registerFileDescription(description);
        }
        for (DomFileMetaData meta : DomFileMetaData.EP_NAME.getExtensionList()) {
            this.registerFileDescription(meta);
        }
    }

    private synchronized void extensionsChanged() {
        this.myRootTagName2FileDescription.clear();
        this.myAcceptingOtherRootTagNamesDescriptions.clear();
        this.myClass2Annotator.clear();
        this.myCachedImplementationClasses.clearCache();
        this.myTypeChooserManager.clearCache();
        this.registerDescriptions();
    }

    public static DomApplicationComponent getInstance() {
        return (DomApplicationComponent)ServiceManager.getService(DomApplicationComponent.class);
    }

    public synchronized int getCumulativeVersion(boolean forStubs) {
        int result = 0;
        for (DomFileMetaData meta : this.allMetas()) {
            if (forStubs) {
                if (meta.stubVersion == null) continue;
                result += meta.stubVersion.intValue();
                result += StringUtil.notNullize((String)meta.rootTagName).hashCode();
                continue;
            }
            result += meta.domVersion;
            result += StringUtil.notNullize((String)meta.rootTagName).hashCode();
        }
        return result;
    }

    private Iterable<DomFileMetaData> allMetas() {
        return ContainerUtil.concat((Iterable)this.myRootTagName2FileDescription.values(), this.myAcceptingOtherRootTagNamesDescriptions);
    }

    @Nullable
    public synchronized DomFileMetaData findMeta(DomFileDescription<?> description) {
        return (DomFileMetaData)((Object)ContainerUtil.find(this.allMetas(), m -> m.lazyInstance == description));
    }

    public synchronized Set<DomFileDescription<?>> getFileDescriptions(String rootTagName) {
        return ContainerUtil.map2Set((Collection)this.myRootTagName2FileDescription.get((Object)rootTagName), DomFileMetaData::getDescription);
    }

    public synchronized Set<DomFileDescription<?>> getAcceptingOtherRootTagNameDescriptions() {
        return ContainerUtil.map2Set(this.myAcceptingOtherRootTagNamesDescriptions, DomFileMetaData::getDescription);
    }

    synchronized void registerFileDescription(DomFileDescription<?> description) {
        this.registerFileDescription(new DomFileMetaData(description));
        this.initDescription(description);
    }

    void registerFileDescription(DomFileMetaData meta) {
        if (StringUtil.isEmpty((String)meta.rootTagName)) {
            this.myAcceptingOtherRootTagNamesDescriptions.add(meta);
        } else {
            this.myRootTagName2FileDescription.putValue((Object)meta.rootTagName, (Object)meta);
        }
    }

    void initDescription(DomFileDescription<?> description) {
        Map implementations = description.getImplementations();
        for (Map.Entry entry : implementations.entrySet()) {
            this.registerImplementation((Class)entry.getKey(), (Class)entry.getValue(), null);
        }
        this.myTypeChooserManager.copyFrom(description.getTypeChooserManager());
    }

    synchronized void removeDescription(DomFileDescription<?> description) {
        DomFileMetaData meta = this.findMeta(description);
        this.myRootTagName2FileDescription.get((Object)description.getRootTagName()).remove((Object)meta);
        this.myAcceptingOtherRootTagNamesDescriptions.remove((Object)meta);
    }

    @Nullable
    private synchronized DomFileDescription<?> findFileDescription(Class<?> rootElementClass) {
        for (DomFileMetaData meta : this.allMetas()) {
            DomFileDescription<?> description = meta.lazyInstance;
            if (description == null || description.getRootElementClass() != rootElementClass) continue;
            return description;
        }
        return null;
    }

    public DomElementsAnnotator getAnnotator(Class<?> rootElementClass) {
        return this.myClass2Annotator.get(rootElementClass);
    }

    @Nullable
    final Class<? extends DomElement> getImplementation(Class<?> concreteInterface) {
        return this.myCachedImplementationClasses.get(concreteInterface);
    }

    public final void registerImplementation(Class<? extends DomElement> domElementClass, Class<? extends DomElement> implementationClass, @Nullable Disposable parentDisposable) {
        this.myCachedImplementationClasses.registerImplementation(domElementClass, implementationClass, parentDisposable);
    }

    TypeChooserManager getTypeChooserManager() {
        return this.myTypeChooserManager;
    }

    public final StaticGenericInfo getStaticGenericInfo(Type type) {
        return this.getInvocationCache(ReflectionUtil.getRawType((Type)type)).genericInfo;
    }

    final InvocationCache getInvocationCache(Class<?> type) {
        return this.myInvocationCaches.get(type);
    }

    public final VisitorDescription getVisitorDescription(Class<? extends DomElementVisitor> aClass) {
        return this.myVisitorDescriptions.get(aClass);
    }
}

