/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class LightTempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private final VirtualFile mySourceRoot;

    public LightTempDirTestFixtureImpl() {
        this(false);
    }

    public LightTempDirTestFixtureImpl(boolean usePlatformSourceRoot) {
        if (usePlatformSourceRoot) {
            this.mySourceRoot = null;
        } else {
            VirtualFile fsRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
            Assert.assertNotNull((Object)fsRoot);
            try {
                this.mySourceRoot = (VirtualFile)WriteAction.computeAndWait(() -> fsRoot.createChildDirectory((Object)this, "root"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.deleteAll();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String path) {
        if (path == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(0);
        }
        VirtualFile virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> {
            try {
                return this.findOrCreateChildDir(this.getSourceRoot(), path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        if (dataDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(2);
        }
        if (targetDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(3);
        }
        VirtualFile virtualFile = this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String dataDir, final @NotNull String targetDir, final @NotNull VirtualFileFilter filter) {
        if (dataDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(5);
        }
        if (targetDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(7);
        }
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                Assert.assertNotNull((String)("Cannot find testdata directory " + dataDir), (Object)from);
                try {
                    UsefulTestCase.refreshRecursively(from);
                    VirtualFile tempDir = LightTempDirTestFixtureImpl.this.getSourceRoot();
                    if (targetDir.length() > 0) {
                        tempDir = LightTempDirTestFixtureImpl.this.findOrCreateChildDir(tempDir, targetDir);
                    }
                    VfsUtil.copyDirectory((Object)this, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                    return tempDir;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    private VirtualFile findOrCreateChildDir(VirtualFile root, String relativePath) throws IOException {
        if (relativePath.length() == 0) {
            return root;
        }
        List dirs = StringUtil.split((String)StringUtil.trimStart((String)relativePath, (String)"/"), (String)"/");
        for (String dirName : dirs) {
            if (dirName.equals(".")) continue;
            if (dirName.equals("..")) {
                if ((root = root.getParent()) != null) continue;
                throw new IllegalArgumentException("Invalid path: " + relativePath);
            }
            VirtualFile dir = root.findChild(dirName);
            if (dir != null) {
                root = dir;
                continue;
            }
            root = root.createChildDirectory((Object)this, dirName);
        }
        return root;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        return "temp:///root";
    }

    @Override
    public VirtualFile getFile(@NotNull String path) {
        VirtualFile sourceRoot;
        VirtualFile result;
        if (path == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(9);
        }
        if ((result = (sourceRoot = this.getSourceRoot()).findFileByRelativePath(path)) == null) {
            sourceRoot.refresh(false, true);
            result = sourceRoot.findFileByRelativePath(path);
        }
        return result;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String targetPath) {
        VirtualFile virtualFile;
        if (targetPath == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(10);
        }
        String path = PathUtil.getParentPath((String)targetPath);
        String name = PathUtil.getFileName((String)targetPath);
        try {
            virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> {
                VirtualFile targetDir = this.findOrCreateDir(path);
                return targetDir.createChildData((Object)this, name);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name, @NotNull String text) throws IOException {
        if (name == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(12);
        }
        if (text == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(13);
        }
        VirtualFile file2 = this.createFile(name);
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file2, (String)text));
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(14);
        }
        return virtualFile;
    }

    public void deleteAll() {
        WriteAction.runAndWait(() -> {
            VirtualFile[] toDelete;
            VirtualFile[] virtualFileArray;
            if (this.mySourceRoot != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = this.mySourceRoot;
            } else {
                virtualFileArray = this.getSourceRoot().getChildren();
            }
            for (VirtualFile file2 : toDelete = virtualFileArray) {
                try {
                    file2.delete((Object)this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @NotNull
    private VirtualFile getSourceRoot() {
        VirtualFile virtualFile = this.mySourceRoot != null ? this.mySourceRoot : LightPlatformTestCase.getSourceRoot();
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDir";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateDir";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAll";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateDir";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyAll";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

