/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.api;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.workspace.api.CachedValue;
import com.intellij.workspace.api.CachedValueWithParameter;
import com.intellij.workspace.api.TypedEntityStorage;
import com.intellij.workspace.api.TypedEntityStorageBuilder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011JC\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u000b0\t2\u0006\u0010\u0013\u001a\u0002H\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0005J3\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u000b0\t2\u0006\u0010\u0013\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0017R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0007\u001a \u0012\u0016\u0012\u0014\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/workspace/api/ValuesCache;", "", "()V", "cachedValues", "Lcom/google/common/cache/Cache;", "Lcom/intellij/workspace/api/CachedValue;", "Lcom/intellij/workspace/api/ValuesCache$ValuesCacheData;", "cachedValuesWithParameter", "Lkotlin/Pair;", "Lcom/intellij/workspace/api/CachedValueWithParameter;", "cachedValue", "R", "value", "version", "", "storage", "Lcom/intellij/workspace/api/TypedEntityStorage;", "(Lcom/intellij/workspace/api/CachedValue;JLcom/intellij/workspace/api/TypedEntityStorage;)Ljava/lang/Object;", "P", "parameter", "(Lcom/intellij/workspace/api/CachedValueWithParameter;Ljava/lang/Object;JLcom/intellij/workspace/api/TypedEntityStorage;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/workspace/api/CachedValueWithParameter;Ljava/lang/Object;)V", "ValuesCacheData", "intellij.platform.workspaceModel.core"})
public final class ValuesCache {
    private final Cache<CachedValue<?>, ValuesCacheData> cachedValues;
    private final Cache<Pair<CachedValueWithParameter<?, ?>, ?>, ValuesCacheData> cachedValuesWithParameter;

    public final <R> R cachedValue(@NotNull CachedValue<R> value2, long version2, @NotNull TypedEntityStorage storage) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        if (storage instanceof TypedEntityStorageBuilder) {
            String string = "storage must be immutable";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ValuesCacheData o = (ValuesCacheData)this.cachedValues.getIfPresent(value2);
        if (o != null && o.getVersion() == version2) {
            return (R)o.getValue();
        }
        Object newValue = value2.getSource().invoke((Object)storage);
        this.cachedValues.put(value2, (Object)new ValuesCacheData(version2, newValue));
        return (R)newValue;
    }

    public final <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter, long version2, @NotNull TypedEntityStorage storage) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        if (storage instanceof TypedEntityStorageBuilder) {
            String string = "storage must be immutable";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ValuesCacheData o = (ValuesCacheData)this.cachedValuesWithParameter.getIfPresent((Object)TuplesKt.to(value2, parameter));
        if (o != null && o.getVersion() == version2) {
            return (R)o.getValue();
        }
        Object newValue = value2.getSource().invoke((Object)storage, parameter);
        this.cachedValuesWithParameter.put((Object)TuplesKt.to(value2, parameter), (Object)new ValuesCacheData(version2, newValue));
        return (R)newValue;
    }

    public final <R> void clearCachedValue(@NotNull CachedValue<R> value2) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        this.cachedValues.invalidate(value2);
    }

    public final <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        this.cachedValuesWithParameter.invalidate((Object)TuplesKt.to(value2, parameter));
    }

    public ValuesCache() {
        Cache cache = CacheBuilder.newBuilder().weakValues().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache, (String)"CacheBuilder.newBuilder().weakValues().build()");
        this.cachedValues = cache;
        Cache cache2 = CacheBuilder.newBuilder().weakValues().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache2, (String)"CacheBuilder.newBuilder().weakValues().build()");
        this.cachedValuesWithParameter = cache2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/workspace/api/ValuesCache$ValuesCacheData;", "", "version", "", "value", "(JLjava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "getVersion", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.workspaceModel.core"})
    private static final class ValuesCacheData {
        private final long version;
        @Nullable
        private final Object value;

        public final long getVersion() {
            return this.version;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }

        public ValuesCacheData(long version2, @Nullable Object value2) {
            this.version = version2;
            this.value = value2;
        }

        public final long component1() {
            return this.version;
        }

        @Nullable
        public final Object component2() {
            return this.value;
        }

        @NotNull
        public final ValuesCacheData copy(long version2, @Nullable Object value2) {
            return new ValuesCacheData(version2, value2);
        }

        public static /* synthetic */ ValuesCacheData copy$default(ValuesCacheData valuesCacheData, long l, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                l = valuesCacheData.version;
            }
            if ((n & 2) != 0) {
                object = valuesCacheData.value;
            }
            return valuesCacheData.copy(l, object);
        }

        @NotNull
        public String toString() {
            return "ValuesCacheData(version=" + this.version + ", value=" + this.value + ")";
        }

        public int hashCode() {
            Object object = this.value;
            return Long.hashCode(this.version) * 31 + (object != null ? object.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ValuesCacheData)) break block3;
                    ValuesCacheData valuesCacheData = (ValuesCacheData)object;
                    if (this.version != valuesCacheData.version || !Intrinsics.areEqual((Object)this.value, (Object)valuesCacheData.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

