/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReloadablePanel<T> {
    private static final String CONTROL_PLACE = "UI.Configuration.Component.Reload.Panel";
    private final AsyncProcessIcon myLoadingVersionIcon = new AsyncProcessIcon("Getting possible values");
    private final JLabel myErrorMessage = new JLabel();
    @Nullable
    private volatile DataProvider<T> myDataProvider;
    @Nullable
    private volatile UpdateStatus myUpdateStatus;
    protected JPanel myActionPanel;

    public ReloadablePanel() {
        this.myErrorMessage.setForeground((Color)JBColor.RED);
        this.createActionPanel();
        this.fillActionPanel();
    }

    private void createActionPanel() {
        this.myActionPanel = new JPanel(new CardLayout());
    }

    public final void setDataProvider(@NotNull DataProvider<T> dataProvider) {
        if (dataProvider == null) {
            ReloadablePanel.$$$reportNull$$$0(0);
        }
        this.myDataProvider = dataProvider;
        Set<T> cachedValues = dataProvider.getCachedValues();
        if (cachedValues != null) {
            this.onUpdateValues(cachedValues);
        }
    }

    protected abstract void doUpdateValues(@NotNull Set<T> var1);

    public abstract T getSelectedValue();

    @NotNull
    public final JLabel getErrorComponent() {
        JLabel jLabel = this.myErrorMessage;
        if (jLabel == null) {
            ReloadablePanel.$$$reportNull$$$0(1);
        }
        return jLabel;
    }

    public final boolean isBackgroundJobRunning() {
        return this.myUpdateStatus == UpdateStatus.UPDATING;
    }

    public final void onUpdateValues(@NotNull Set<T> values2) {
        if (values2 == null) {
            ReloadablePanel.$$$reportNull$$$0(2);
        }
        this.changeUpdateStatus(UpdateStatus.IDLE);
        this.doUpdateValues(values2);
    }

    public final void reloadValuesInBackground() {
        if (this.myUpdateStatus == UpdateStatus.UPDATING) {
            return;
        }
        this.changeUpdateStatus(UpdateStatus.UPDATING);
        this.myErrorMessage.setText(null);
        DataProvider<T> provider = this.myDataProvider;
        assert (provider != null);
        provider.updateValuesAsynchronously();
    }

    private void changeUpdateStatus(@NotNull UpdateStatus status) {
        if (status == null) {
            ReloadablePanel.$$$reportNull$$$0(3);
        }
        CardLayout cardLayout = (CardLayout)this.myActionPanel.getLayout();
        cardLayout.show(this.myActionPanel, status.name());
        if (status == UpdateStatus.UPDATING) {
            this.myLoadingVersionIcon.resume();
        } else {
            this.myLoadingVersionIcon.suspend();
        }
        this.myUpdateStatus = status;
    }

    protected void fillActionPanel() {
        this.myActionPanel.add((Component)this.createReloadButtonPanel(), UpdateStatus.IDLE.name());
        this.myActionPanel.add((Component)this.createReloadInProgressPanel(), UpdateStatus.UPDATING.name());
        this.changeUpdateStatus(UpdateStatus.IDLE);
    }

    public final void onValuesUpdateError(@NotNull String errorMessage) {
        if (errorMessage == null) {
            ReloadablePanel.$$$reportNull$$$0(4);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.getSelectedValue() == null) {
                this.myErrorMessage.setText(errorMessage);
            }
            this.changeUpdateStatus(UpdateStatus.IDLE);
        });
    }

    @NotNull
    private JPanel createReloadButtonPanel() {
        ReloadAction reloadAction = new ReloadAction();
        ActionButton reloadButton = new ActionButton(reloadAction, reloadAction.getTemplatePresentation().clone(), CONTROL_PLACE, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        JPanel panel2 = new JPanel(new BorderLayout(0, 0));
        panel2.add((Component)reloadButton, "West");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ReloadablePanel.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    public abstract JPanel getMainPanel();

    @NotNull
    JPanel getActionPanel() {
        JPanel jPanel = this.myActionPanel;
        if (jPanel == null) {
            ReloadablePanel.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    private JPanel createReloadInProgressPanel() {
        JPanel panel2 = new JPanel();
        panel2.add((Component)this.myLoadingVersionIcon);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ReloadablePanel.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/ReloadablePanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/ReloadablePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReloadButtonPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createReloadInProgressPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDataProvider";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onUpdateValues";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changeUpdateStatus";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onValuesUpdateError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum UpdateStatus {
        UPDATING,
        IDLE;

    }

    private final class ReloadAction
    extends AnAction {
        ReloadAction() {
            super(IdeBundle.messagePointer((String)"action.AnAction.text.reload.list", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.AnAction.description.reload.list", (Object[])new Object[0]), AllIcons.Actions.Refresh);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ReloadAction.$$$reportNull$$$0(0);
            }
            ReloadablePanel.this.reloadValuesInBackground();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ReloadAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/util/ui/ReloadablePanel$ReloadAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface DataProvider<T> {
        @Nullable
        public Set<T> getCachedValues();

        public void updateValuesAsynchronously();
    }
}

