/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.CompressionUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.forward.AbstractForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.indexing.impl.perFileVersion.PersistentSubIndexerRetriever;
import com.intellij.util.indexing.snapshot.CompositeHashIdEnumerator;
import com.intellij.util.indexing.snapshot.HashIdForwardIndexAccessor;
import com.intellij.util.indexing.snapshot.HashedInputData;
import com.intellij.util.indexing.snapshot.IndexedHashesSupport;
import com.intellij.util.indexing.snapshot.UpdatableSnapshotInputMappingIndex;
import com.intellij.util.io.ByteSequenceDataExternalizer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.NullableDataExternalizer;
import com.intellij.util.io.PersistentHashMap;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnapshotInputMappings<Key, Value>
implements UpdatableSnapshotInputMappingIndex<Key, Value, FileContent> {
    private static final Logger LOG = Logger.getInstance(SnapshotInputMappings.class);
    private final ID<Key, Value> myIndexId;
    private final DataExternalizer<Map<Key, Value>> myMapExternalizer;
    private final DataExternalizer<Value> myValueExternalizer;
    private final DataIndexer<Key, Value, FileContent> myIndexer;
    private final PersistentMapBasedForwardIndex myContents;
    private volatile PersistentHashMap<Integer, String> myIndexingTrace;
    private final HashIdForwardIndexAccessor<Key, Value, FileContent> myHashIdForwardIndexAccessor;
    private final CompositeHashIdEnumerator myCompositeHashIdEnumerator;
    private final boolean myIsPsiBackedIndex;
    private PersistentSubIndexerRetriever<?, ?> mySubIndexerRetriever;
    private static final Key<Integer> ourSavedContentHashIdKey = Key.create((String)"saved.content.hash.id");
    private static final Key<Integer> ourSavedUncommittedHashIdKey = Key.create((String)"saved.uncommitted.hash.id");

    public static int getVersion() {
        assert (FileBasedIndex.ourSnapshotMappingsEnabled);
        return 4096;
    }

    public SnapshotInputMappings(IndexExtension<Key, Value, FileContent> indexExtension) throws IOException {
        this.myIndexId = (ID)indexExtension.getName();
        this.myIsPsiBackedIndex = FileBasedIndexImpl.isPsiDependentIndex(indexExtension);
        boolean storeOnlySingleValue = indexExtension instanceof SingleEntryFileBasedIndexExtension;
        this.myMapExternalizer = storeOnlySingleValue ? null : new InputMapExternalizer<Key, Value>(indexExtension);
        this.myValueExternalizer = storeOnlySingleValue ? new NullableDataExternalizer(indexExtension.getValueExternalizer()) : null;
        this.myIndexer = indexExtension.getIndexer();
        this.myContents = this.createContentsIndex();
        this.myHashIdForwardIndexAccessor = new HashIdForwardIndexAccessor(this, storeOnlySingleValue);
        this.myIndexingTrace = DebugAssertions.EXTRA_SANITY_CHECKS ? this.createIndexingTrace() : null;
        this.myCompositeHashIdEnumerator = VfsAwareMapReduceIndex.isCompositeIndexer(this.myIndexer) ? new CompositeHashIdEnumerator(this.myIndexId) : null;
    }

    public HashIdForwardIndexAccessor<Key, Value, FileContent> getForwardIndexAccessor() {
        return this.myHashIdForwardIndexAccessor;
    }

    public File getInputIndexStorageFile() {
        return new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "fileIdToHashId");
    }

    @Override
    @NotNull
    public Map<Key, Value> readData(int hashId) throws IOException {
        Map map2 = (Map)ObjectUtils.notNull(this.doReadData(hashId), Collections.emptyMap());
        if (map2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(0);
        }
        return map2;
    }

    @Override
    @Nullable
    public InputData<Key, Value> readData(@NotNull FileContent content2) throws IOException {
        Map contentData;
        boolean sameValueForSavedIndexedResultAndCurrentOne;
        int hashId;
        Map data2;
        if (content2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(1);
        }
        if ((data2 = this.doReadData(hashId = this.getHashId(content2))) != null && DebugAssertions.EXTRA_SANITY_CHECKS && !(sameValueForSavedIndexedResultAndCurrentOne = (contentData = this.myIndexer.map((Object)content2)).equals(data2))) {
            data2 = contentData;
            DebugAssertions.error((String)"Unexpected difference in indexing of %s by index %s\ndiff %s\nprevious indexed info %s", (Object[])new Object[]{SnapshotInputMappings.getContentDebugData(content2), this.myIndexId, this.buildDiff(data2, contentData), this.myIndexingTrace.get((Object)hashId)});
        }
        return data2 == null ? null : new HashedInputData<Key, Value>(data2, hashId);
    }

    @Nullable
    private Map<Key, Value> doReadData(int hashId) throws IOException {
        ByteArraySequence byteSequence = this.readContents(hashId);
        return byteSequence != null ? this.deserialize(byteSequence) : null;
    }

    @NotNull
    private Map<Key, Value> deserialize(@NotNull ByteArraySequence byteSequence) throws IOException {
        if (byteSequence == null) {
            SnapshotInputMappings.$$$reportNull$$$0(2);
        }
        if (this.myMapExternalizer != null) {
            Map map2 = (Map)AbstractForwardIndexAccessor.deserializeFromByteSeq((ByteArraySequence)byteSequence, this.myMapExternalizer);
            if (map2 == null) {
                SnapshotInputMappings.$$$reportNull$$$0(3);
            }
            return map2;
        }
        assert (this.myValueExternalizer != null);
        Object value2 = AbstractForwardIndexAccessor.deserializeFromByteSeq((ByteArraySequence)byteSequence, this.myValueExternalizer);
        Map<Integer, Object> map3 = Collections.singletonMap(0, value2);
        if (map3 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(4);
        }
        return map3;
    }

    @NotNull
    private ByteArraySequence serializeData(@NotNull Map<Key, Value> data2) throws IOException {
        if (data2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(5);
        }
        if (this.myMapExternalizer != null) {
            ByteArraySequence byteArraySequence = AbstractForwardIndexAccessor.serializeToByteSeq(data2, this.myMapExternalizer, (int)data2.size());
            if (byteArraySequence == null) {
                SnapshotInputMappings.$$$reportNull$$$0(6);
            }
            return byteArraySequence;
        }
        assert (this.myValueExternalizer != null);
        ByteArraySequence byteArraySequence = AbstractForwardIndexAccessor.serializeToByteSeq((Object)ContainerUtil.getFirstItem(data2.values()), this.myValueExternalizer, (int)data2.size());
        if (byteArraySequence == null) {
            SnapshotInputMappings.$$$reportNull$$$0(7);
        }
        return byteArraySequence;
    }

    @Override
    public InputData<Key, Value> putData(@Nullable FileContent content2, @NotNull InputData<Key, Value> data2) throws IOException {
        InputData result2;
        int hashId;
        if (data2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(8);
        }
        if (data2 instanceof HashedInputData) {
            hashId = ((HashedInputData)data2).getHashId();
            result2 = data2;
        } else {
            hashId = this.getHashId(content2);
            result2 = hashId == 0 ? InputData.empty() : new HashedInputData(data2.getKeyValues(), hashId);
        }
        boolean saved = this.savePersistentData(data2.getKeyValues(), hashId);
        if (DebugAssertions.EXTRA_SANITY_CHECKS && saved) {
            try {
                this.myIndexingTrace.put((Object)hashId, (Object)(SnapshotInputMappings.getContentDebugData(content2) + "," + ExceptionUtil.getThrowableText((Throwable)new Throwable())));
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
        }
        return result2;
    }

    @NotNull
    private static String getContentDebugData(FileContent input) {
        FileContentImpl content2 = (FileContentImpl)input;
        String string = "[" + content2.getFile().getPath() + ";" + content2.getFileType().getName() + ";" + content2.getCharset() + "]";
        if (string == null) {
            SnapshotInputMappings.$$$reportNull$$$0(9);
        }
        return string;
    }

    private int getHashId(@Nullable FileContent content2) throws IOException {
        if (content2 == null) {
            return 0;
        }
        int hash2 = this.getHashOfContent((FileContentImpl)content2);
        if (this.myCompositeHashIdEnumerator != null) {
            int subIndexerTypeId = this.mySubIndexerRetriever.getFileIndexerId((IndexedFile)content2);
            return this.myCompositeHashIdEnumerator.enumerate(hash2, subIndexerTypeId);
        }
        return hash2;
    }

    @Override
    public void flush() {
        if (this.myContents != null) {
            this.myContents.force();
        }
        if (this.myIndexingTrace != null) {
            this.myIndexingTrace.force();
        }
        if (this.myCompositeHashIdEnumerator != null) {
            this.myCompositeHashIdEnumerator.force();
        }
    }

    @Override
    public void clear() throws IOException {
        try {
            if (this.myCompositeHashIdEnumerator != null) {
                try {
                    this.myCompositeHashIdEnumerator.clear();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (this.myIndexingTrace != null) {
                PersistentHashMap.deleteMap(this.myIndexingTrace);
                this.myIndexingTrace = this.createIndexingTrace();
            }
        }
        finally {
            if (this.myContents != null) {
                try {
                    this.myContents.clear();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public void close() {
        IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.myContents, this.myIndexingTrace, this.myCompositeHashIdEnumerator});
    }

    private PersistentMapBasedForwardIndex createContentsIndex() throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled && !SharedIndicesData.DO_CHECKS) {
            return null;
        }
        File saved = new File(IndexInfrastructure.getPersistentIndexRootDir(this.myIndexId), "values");
        try {
            return new PersistentMapBasedForwardIndex(saved.toPath(), false);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)saved);
            throw ex;
        }
    }

    private PersistentHashMap<Integer, String> createIndexingTrace() throws IOException {
        File mapFile = new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "indextrace");
        try {
            return new PersistentHashMap(mapFile.toPath(), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<String>(){

                public void save(@NotNull DataOutput out, String value2) throws IOException {
                    if (out == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    out.write((byte[])CompressionUtil.compressStringRawBytes((CharSequence)value2));
                }

                public String read(@NotNull DataInput in) throws IOException {
                    if (in == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    byte[] b = new byte[((InputStream)((Object)in)).available()];
                    in.readFully(b);
                    return (String)CompressionUtil.uncompressStringRawBytes((Object)b);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "out";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "in";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/util/indexing/snapshot/SnapshotInputMappings$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "save";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "read";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, 4096);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)mapFile);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArraySequence readContents(Integer hashId) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            if (SharedIndicesData.DO_CHECKS) {
                PersistentMapBasedForwardIndex persistentMapBasedForwardIndex = this.myContents;
                synchronized (persistentMapBasedForwardIndex) {
                    ByteArraySequence contentBytes = (ByteArraySequence)SharedIndicesData.recallContentData(hashId, this.myIndexId, ByteSequenceDataExternalizer.INSTANCE);
                    ByteArraySequence contentBytesFromContents = this.myContents.get(hashId);
                    if (contentBytes == null && contentBytesFromContents != null || !Comparing.equal((Object)contentBytesFromContents, (Object)contentBytes)) {
                        SharedIndicesData.associateContentData(hashId, this.myIndexId, contentBytesFromContents, ByteSequenceDataExternalizer.INSTANCE);
                        if (contentBytes != null) {
                            LOG.error("Unexpected indexing diff with hash id " + this.myIndexId + "," + hashId);
                        }
                        contentBytes = contentBytesFromContents;
                    }
                    return contentBytes;
                }
            }
            return (ByteArraySequence)SharedIndicesData.recallContentData(hashId, this.myIndexId, ByteSequenceDataExternalizer.INSTANCE);
        }
        return this.myContents.get(hashId);
    }

    private Integer getHashOfContent(FileContentImpl content2) throws IOException {
        if (this.myIsPsiBackedIndex) {
            return SnapshotInputMappings.doGetContentHash(content2, true);
        }
        return SnapshotInputMappings.doGetContentHash(content2, false);
    }

    public void setSubIndexerRetriever(@NotNull PersistentSubIndexerRetriever<?, ?> retriever) {
        if (retriever == null) {
            SnapshotInputMappings.$$$reportNull$$$0(10);
        }
        assert (this.myCompositeHashIdEnumerator != null);
        this.mySubIndexerRetriever = retriever;
    }

    @NotNull
    private static Integer doGetContentHash(FileContentImpl content2, boolean fromDocument) throws IOException {
        Key<Integer> key = fromDocument ? ourSavedUncommittedHashIdKey : ourSavedContentHashIdKey;
        Integer previouslyCalculatedContentHashId = (Integer)content2.getUserData(key);
        if (previouslyCalculatedContentHashId == null) {
            byte[] hash2 = IndexedHashesSupport.getOrInitIndexedHash(content2, fromDocument);
            previouslyCalculatedContentHashId = IndexedHashesSupport.enumerateHash(hash2);
            content2.putUserData(key, previouslyCalculatedContentHashId);
        }
        Integer n = previouslyCalculatedContentHashId;
        if (n == null) {
            SnapshotInputMappings.$$$reportNull$$$0(11);
        }
        return n;
    }

    private StringBuilder buildDiff(Map<Key, Value> data2, Map<Key, Value> contentData) {
        Value value2;
        StringBuilder moreInfo = new StringBuilder();
        if (contentData.size() != data2.size()) {
            moreInfo.append("Indexer has different number of elements, previously ").append(data2.size()).append(" after ").append(contentData.size()).append("\n");
        } else {
            moreInfo.append("total ").append(contentData.size()).append(" entries\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : contentData.entrySet()) {
            if (!data2.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("Previous data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value2 = data2.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value2)) continue;
            moreInfo.append("Previous data has different value for key:").append(keyValueEntry.getKey()).append(", new value ").append(keyValueEntry.getValue()).append(", oldValue:").append(value2).append("\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : data2.entrySet()) {
            if (!contentData.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("New data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value2 = contentData.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value2)) continue;
            moreInfo.append("New data has different value for key:").append(keyValueEntry.getKey()).append(" new value ").append(value2).append(", oldValue:").append(keyValueEntry.getValue()).append("\n");
        }
        return moreInfo;
    }

    private boolean savePersistentData(@NotNull Map<Key, Value> data2, int id2) {
        if (data2 == null) {
            SnapshotInputMappings.$$$reportNull$$$0(12);
        }
        try {
            if (this.myContents != null && this.myContents.containsMapping(id2)) {
                return false;
            }
            ByteArraySequence bytes = this.serializeData(data2);
            this.saveContents(id2, bytes);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveContents(int id2, ByteArraySequence byteSequence) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            if (SharedIndicesData.DO_CHECKS) {
                PersistentMapBasedForwardIndex persistentMapBasedForwardIndex = this.myContents;
                synchronized (persistentMapBasedForwardIndex) {
                    this.myContents.put(Integer.valueOf(id2), byteSequence);
                    SharedIndicesData.associateContentData(id2, this.myIndexId, byteSequence, ByteSequenceDataExternalizer.INSTANCE);
                }
            } else {
                SharedIndicesData.associateContentData(id2, this.myIndexId, byteSequence, ByteSequenceDataExternalizer.INSTANCE);
            }
        } else {
            this.myContents.put(Integer.valueOf(id2), byteSequence);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/snapshot/SnapshotInputMappings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteSequence";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retriever";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "readData";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/snapshot/SnapshotInputMappings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentDebugData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetContentHash";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setSubIndexerRetriever";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "savePersistentData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

