/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.layout.singleRowLayout;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.layout.singleRowLayout.SingleRowLayout;
import com.intellij.ui.tabs.layout.singleRowLayout.SingleRowPassInfo;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;

public abstract class SingleRowLayoutStrategy {
    private static final int MIN_TAB_WIDTH = 50;
    private static final int SELECTION_TAB_V_SHIFT = 2;
    final SingleRowLayout myLayout;

    protected SingleRowLayoutStrategy(SingleRowLayout layout) {
        this.myLayout = layout;
    }

    abstract int getMoreRectAxisSize();

    public abstract int getStartPosition(SingleRowPassInfo var1);

    public abstract int getToFitLength(SingleRowPassInfo var1);

    public abstract int getLengthIncrement(Dimension var1);

    public abstract int getMinPosition(Rectangle var1);

    public abstract int getMaxPosition(Rectangle var1);

    protected abstract int getFixedFitLength(SingleRowPassInfo var1);

    public Rectangle getLayoutRect(SingleRowPassInfo data2, int position, int length) {
        return this.getLayoutRec(position, this.getFixedPosition(data2), length, this.getFixedFitLength(data2));
    }

    protected abstract Rectangle getLayoutRec(int var1, int var2, int var3, int var4);

    protected abstract Rectangle getTabRectangle(SingleRowPassInfo var1);

    protected abstract int getFixedPosition(SingleRowPassInfo var1);

    public abstract Rectangle getMoreRect(SingleRowPassInfo var1);

    public abstract boolean isToCenterTextWhenStretched();

    public abstract ShapeTransform createShapeTransform(Rectangle var1);

    public abstract void layoutComp(SingleRowPassInfo var1);

    public boolean isToolbarOnTabs() {
        return false;
    }

    public abstract boolean isDragOut(TabLabel var1, int var2, int var3);

    public abstract boolean drawPartialOverflowTabs();

    public abstract int getScrollUnitIncrement(TabLabel var1);

    public abstract LayoutPassInfo.LineCoordinates computeExtraBorderLine(SingleRowPassInfo var1);

    public void layoutComp(SingleRowPassInfo data2, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        JComponent hToolbar = (JComponent)data2.hToolbar.get();
        JComponent vToolbar = (JComponent)data2.vToolbar.get();
        if (hToolbar != null) {
            int toolbarHeight = hToolbar.getPreferredSize().height;
            int hSeparatorHeight = toolbarHeight > 0 ? 1 : 0;
            Rectangle compRect = this.myLayout.layoutComp(deltaX, toolbarHeight + hSeparatorHeight + deltaY, (JComponent)data2.comp.get(), deltaWidth, deltaHeight);
            this.myLayout.layout(hToolbar, compRect.x, compRect.y - toolbarHeight - hSeparatorHeight, compRect.width, toolbarHeight);
        } else if (vToolbar != null) {
            int vSeparatorWidth;
            int toolbarWidth = vToolbar.getPreferredSize().width;
            int n = vSeparatorWidth = toolbarWidth > 0 ? 1 : 0;
            if (this.myLayout.getCallback().isToolbarBeforeTabs()) {
                Rectangle compRect = this.myLayout.layoutComp(toolbarWidth + vSeparatorWidth + deltaX, deltaY, (JComponent)data2.comp.get(), deltaWidth, deltaHeight);
                this.myLayout.layout(vToolbar, compRect.x - toolbarWidth - vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
            } else {
                Rectangle compRect = this.myLayout.layoutComp(new Rectangle(deltaX, deltaY, this.myLayout.getCallback().getComponent().getWidth() - toolbarWidth - vSeparatorWidth, this.myLayout.getCallback().getComponent().getHeight()), (JComponent)data2.comp.get(), deltaWidth, deltaHeight);
                this.myLayout.layout(vToolbar, compRect.x + compRect.width + vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
            }
        } else {
            this.myLayout.layoutComp(deltaX, deltaY, (JComponent)data2.comp.get(), deltaWidth, deltaHeight);
        }
    }

    static class Right
    extends Vertical {
        Right(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data2) {
            if (this.myLayout.getCallback().isHiddenTabs()) {
                this.layoutComp(data2, 0, 0, 0, 0);
            } else {
                this.layoutComp(data2, 0, 0, -data2.headerToFitWidth, 0);
            }
        }

        @Override
        public LayoutPassInfo.LineCoordinates computeExtraBorderLine(SingleRowPassInfo data2) {
            int x = data2.tabRectangle.x;
            int y1 = 0;
            int y2 = this.myLayout.getCallback().getComponent().getSize().height;
            return new LayoutPassInfo.LineCoordinates(x, y1, x, y2);
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Right(labelRec);
        }

        @Override
        public Rectangle getLayoutRec(int position, int fixedPos, int length, int fixedFitLength) {
            return new Rectangle(fixedPos, position, fixedFitLength - 1, length);
        }

        @Override
        protected Rectangle getTabRectangle(SingleRowPassInfo data2) {
            return new Rectangle(data2.layoutRectWithoutInsets.x + data2.layoutRectWithoutInsets.width - data2.headerToFitWidth, data2.layoutRectWithoutInsets.y, data2.headerToFitWidth, data2.layoutRectWithoutInsets.height);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data2) {
            return data2.layoutSize.width - data2.headerToFitWidth - data2.insets.right;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data2) {
            return new Rectangle(data2.layoutSize.width - data2.insets.right - data2.headerToFitWidth, this.myLayout.getCallback().getComponent().getHeight() - data2.insets.bottom - data2.moreRectAxisSize - 1, data2.headerToFitWidth, data2.moreRectAxisSize - 1);
        }
    }

    static class Left
    extends Vertical {
        Left(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data2) {
            if (this.myLayout.getCallback().isHiddenTabs()) {
                this.layoutComp(data2, 0, 0, 0, 0);
            } else {
                this.layoutComp(data2, data2.headerToFitWidth, 0, 0, 0);
            }
        }

        @Override
        public LayoutPassInfo.LineCoordinates computeExtraBorderLine(SingleRowPassInfo data2) {
            int x = data2.tabRectangle.x + data2.tabRectangle.width - this.myLayout.getCallback().getBorderThickness();
            int y1 = 0;
            int y2 = this.myLayout.getCallback().getComponent().getSize().height;
            return new LayoutPassInfo.LineCoordinates(x, y1, x, y2);
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Left(labelRec);
        }

        @Override
        public Rectangle getLayoutRec(int position, int fixedPos, int length, int fixedFitLength) {
            return new Rectangle(fixedPos, position, fixedFitLength, length);
        }

        @Override
        protected Rectangle getTabRectangle(SingleRowPassInfo data2) {
            return new Rectangle(data2.layoutRectWithoutInsets.x, data2.layoutRectWithoutInsets.y, data2.headerToFitWidth, data2.layoutRectWithoutInsets.height);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data2) {
            return data2.insets.left;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data2) {
            return new Rectangle(data2.insets.left + 2, this.myLayout.getCallback().getComponent().getHeight() - data2.insets.bottom - data2.moreRectAxisSize - 1, data2.headerToFitWidth, data2.moreRectAxisSize - 1);
        }
    }

    static abstract class Vertical
    extends SingleRowLayoutStrategy {
        protected Vertical(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public boolean isDragOut(TabLabel tabLabel, int deltaX, int deltaY) {
            return (double)Math.abs(deltaX) > (double)tabLabel.getHeight() * this.myLayout.getDragOutMultiplier();
        }

        @Override
        public boolean isToCenterTextWhenStretched() {
            return false;
        }

        @Override
        int getMoreRectAxisSize() {
            return ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width + 6;
        }

        @Override
        public int getStartPosition(SingleRowPassInfo data2) {
            return data2.insets.top;
        }

        @Override
        public int getToFitLength(SingleRowPassInfo data2) {
            return data2.layoutRectWithoutInsets.height;
        }

        @Override
        public int getLengthIncrement(Dimension labelPrefSize) {
            return labelPrefSize.height;
        }

        @Override
        public int getMinPosition(Rectangle bounds2) {
            return (int)bounds2.getMinY();
        }

        @Override
        public int getMaxPosition(Rectangle bounds2) {
            return (int)bounds2.getMaxY();
        }

        @Override
        public int getFixedFitLength(SingleRowPassInfo data2) {
            return data2.headerToFitWidth;
        }

        @Override
        public boolean drawPartialOverflowTabs() {
            return false;
        }

        @Override
        public int getScrollUnitIncrement(TabLabel label2) {
            return label2.getPreferredSize().height;
        }
    }

    static class Bottom
    extends Horizontal {
        Bottom(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        protected Rectangle getTabRectangle(SingleRowPassInfo data2) {
            return new Rectangle(data2.layoutRectWithoutInsets.x, data2.layoutRectWithoutInsets.y + data2.layoutRectWithoutInsets.height - data2.tabsRowHeight, data2.layoutRectWithoutInsets.width, data2.tabsRowHeight);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data2) {
            if (this.myLayout.getCallback().isHiddenTabs()) {
                this.layoutComp(data2, 0, 0, 0, 0);
            } else {
                this.layoutComp(data2, 0, 0, 0, -data2.tabsRowHeight);
            }
        }

        @Override
        public LayoutPassInfo.LineCoordinates computeExtraBorderLine(SingleRowPassInfo data2) {
            int x1 = 0;
            int x2 = this.myLayout.getCallback().getComponent().getSize().width;
            int y = data2.tabRectangle.y;
            return new LayoutPassInfo.LineCoordinates(x1, y, x2, y);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data2) {
            return this.myLayout.getCallback().getComponent().getSize().height - data2.insets.bottom - data2.tabsRowHeight;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data2) {
            return new Rectangle(this.myLayout.getCallback().getComponent().getWidth() - data2.insets.right - data2.moreRectAxisSize + 2, this.getFixedPosition(data2), data2.moreRectAxisSize - 1, data2.tabsRowHeight);
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Bottom(labelRec);
        }
    }

    static class Top
    extends Horizontal {
        Top(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        protected Rectangle getTabRectangle(SingleRowPassInfo data2) {
            return new Rectangle(data2.layoutRectWithoutInsets.x, data2.layoutRectWithoutInsets.y, data2.layoutRectWithoutInsets.width, data2.tabsRowHeight);
        }

        @Override
        public boolean isToolbarOnTabs() {
            return this.myLayout.getCallback().isHorizontalToolbar() && this.myLayout.getCallback().isToolbarOnTabs();
        }

        @Override
        public LayoutPassInfo.LineCoordinates computeExtraBorderLine(SingleRowPassInfo data2) {
            int x1 = 0;
            int x2 = this.myLayout.getCallback().getComponent().getSize().width;
            int y = data2.tabRectangle.y + data2.tabRectangle.height - this.myLayout.getCallback().getBorderThickness();
            return new LayoutPassInfo.LineCoordinates(x1, y, x2, y);
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Top(labelRec);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data2) {
            return data2.insets.top;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data2) {
            int x = this.myLayout.getCallback().isEditorTabs() ? data2.layoutSize.width - data2.moreRectAxisSize : data2.position;
            return new Rectangle(x, data2.insets.top, data2.moreRectAxisSize, data2.tabsRowHeight);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data2) {
            if (this.myLayout.getCallback().isHiddenTabs()) {
                this.layoutComp(data2, 0, 0, 0, 0);
            } else {
                JComponent vToolbar = (JComponent)data2.vToolbar.get();
                int vToolbarWidth = vToolbar != null ? vToolbar.getPreferredSize().width : 0;
                int vSeparatorWidth = vToolbarWidth > 0 ? this.myLayout.getCallback().getBorderThickness() : 0;
                int x = vToolbarWidth > 0 ? vToolbarWidth + vSeparatorWidth : 0;
                JComponent hToolbar = (JComponent)data2.hToolbar.get();
                int hToolbarHeight = !this.myLayout.getCallback().isToolbarOnTabs() && hToolbar != null ? hToolbar.getPreferredSize().height : 0;
                int y = data2.tabsRowHeight + Math.max(hToolbarHeight, 0);
                JComponent comp = (JComponent)data2.comp.get();
                if (hToolbar != null) {
                    Rectangle compBounds = this.myLayout.layoutComp(x, y, comp, 0, 0);
                    if (this.myLayout.getCallback().isToolbarOnTabs()) {
                        int toolbarX = (data2.moreRect != null ? (int)data2.moreRect.getMaxX() : data2.position) + this.myLayout.getCallback().getToolbarInsetForOnTabsMode();
                        Rectangle rec = new Rectangle(toolbarX, data2.insets.top, this.myLayout.getCallback().getComponent().getSize().width - data2.insets.left - toolbarX, data2.tabsRowHeight - this.myLayout.getCallback().getBorderThickness());
                        this.myLayout.layout(hToolbar, rec);
                    } else {
                        int toolbarHeight = hToolbar.getPreferredSize().height;
                        this.myLayout.layout(hToolbar, compBounds.x, compBounds.y - toolbarHeight, compBounds.width, toolbarHeight);
                    }
                } else if (vToolbar != null) {
                    if (this.myLayout.getCallback().isToolbarBeforeTabs()) {
                        Rectangle compBounds = this.myLayout.layoutComp(x, y, comp, 0, 0);
                        this.myLayout.layout(vToolbar, compBounds.x - vToolbarWidth - vSeparatorWidth, compBounds.y, vToolbarWidth, compBounds.height);
                    } else {
                        int width = vToolbarWidth > 0 ? this.myLayout.getCallback().getComponent().getWidth() - vToolbarWidth - vSeparatorWidth : this.myLayout.getCallback().getComponent().getWidth();
                        Rectangle compBounds = this.myLayout.layoutComp(new Rectangle(0, y, width, this.myLayout.getCallback().getComponent().getHeight()), comp, 0, 0);
                        this.myLayout.layout(vToolbar, compBounds.x + compBounds.width + vSeparatorWidth, compBounds.y, vToolbarWidth, compBounds.height);
                    }
                } else {
                    this.myLayout.layoutComp(x, y, comp, 0, 0);
                }
            }
        }
    }

    static abstract class Horizontal
    extends SingleRowLayoutStrategy {
        protected Horizontal(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public boolean isToCenterTextWhenStretched() {
            return true;
        }

        @Override
        public boolean isDragOut(TabLabel tabLabel, int deltaX, int deltaY) {
            return (double)Math.abs(deltaY) > (double)tabLabel.getHeight() * this.myLayout.getDragOutMultiplier();
        }

        @Override
        public int getMoreRectAxisSize() {
            return ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width + 6;
        }

        @Override
        public int getToFitLength(SingleRowPassInfo data2) {
            JComponent hToolbar = (JComponent)data2.hToolbar.get();
            if (hToolbar != null) {
                return data2.layoutRectWithoutInsets.width - hToolbar.getMinimumSize().width;
            }
            return data2.layoutRectWithoutInsets.width;
        }

        @Override
        public int getLengthIncrement(Dimension labelPrefSize) {
            return this.myLayout.getCallback().isEditorTabs() ? (labelPrefSize.width < 50 ? 50 : labelPrefSize.width) : labelPrefSize.width;
        }

        @Override
        public int getMinPosition(Rectangle bounds2) {
            return (int)bounds2.getX();
        }

        @Override
        public int getMaxPosition(Rectangle bounds2) {
            return (int)bounds2.getMaxX();
        }

        @Override
        public int getFixedFitLength(SingleRowPassInfo data2) {
            return data2.tabsRowHeight;
        }

        @Override
        public Rectangle getLayoutRec(int position, int fixedPos, int length, int fixedFitLength) {
            return new Rectangle(position, fixedPos, length, fixedFitLength);
        }

        @Override
        public int getStartPosition(SingleRowPassInfo data2) {
            return data2.insets.left;
        }

        @Override
        public boolean drawPartialOverflowTabs() {
            return true;
        }

        @Override
        public int getScrollUnitIncrement(TabLabel label2) {
            return 10;
        }
    }
}

