/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.debugger.extensions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.debugger.UiDebuggerExtension;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultCaret;
import org.jetbrains.annotations.NotNull;

public class FocusDebugger
implements UiDebuggerExtension,
PropertyChangeListener,
ListSelectionListener {
    private static final Logger LOG = Logger.getInstance(FocusDebugger.class);
    private JComponent myComponent;
    private JList myLog;
    private DefaultListModel myLogModel;
    private JEditorPane myAllocation;

    @Override
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = this.init();
        }
        return this.myComponent;
    }

    private JComponent init() {
        JPanel result2 = new JPanel(new BorderLayout());
        this.myLogModel = new DefaultListModel();
        this.myLog = new JBList((ListModel)this.myLogModel);
        this.myLog.setCellRenderer(new FocusElementRenderer());
        this.myAllocation = new JEditorPane();
        DefaultCaret caret = new DefaultCaret();
        this.myAllocation.setCaret(caret);
        caret.setUpdatePolicy(1);
        this.myAllocation.setEditable(false);
        Splitter splitter = new Splitter(true);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myLog));
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myAllocation));
        this.myLog.addListSelectionListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
        result2.add((Component)splitter, "Center");
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ClearAction());
        result2.add((Component)ActionManager.getInstance().createActionToolbar("FocusDbg", (ActionGroup)group, true).getComponent(), "North");
        return result2;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.myLog.getSelectedIndex() == -1) {
            this.myAllocation.setText(null);
        } else {
            FocusElement element2 = (FocusElement)this.myLog.getSelectedValue();
            StringWriter s = new StringWriter();
            PrintWriter writer = new PrintWriter(s);
            element2.getAllocation().printStackTrace(writer);
            this.myAllocation.setText(s.toString());
        }
    }

    private boolean isInsideDebuggerDialog(Component c) {
        Window debuggerWindow = SwingUtilities.getWindowAncestor(this.myComponent);
        if (!(debuggerWindow instanceof Dialog)) {
            return false;
        }
        return c == debuggerWindow || SwingUtilities.getWindowAncestor(c) == debuggerWindow;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        boolean affectsDebugger = false;
        if (newValue instanceof Component && this.isInsideDebuggerDialog((Component)newValue)) {
            affectsDebugger |= true;
        }
        if (oldValue instanceof Component && this.isInsideDebuggerDialog((Component)oldValue)) {
            affectsDebugger |= true;
        }
        SimpleColoredText text2 = new SimpleColoredText();
        text2.append(evt.getPropertyName(), this.maybeGrayOut(new SimpleTextAttributes(16, null), affectsDebugger));
        text2.append(" newValue=", this.maybeGrayOut(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, affectsDebugger));
        text2.append(evt.getNewValue() + "", this.maybeGrayOut(SimpleTextAttributes.REGULAR_ATTRIBUTES, affectsDebugger));
        text2.append(" oldValue=" + evt.getOldValue(), this.maybeGrayOut(SimpleTextAttributes.REGULAR_ATTRIBUTES, affectsDebugger));
        this.myLogModel.addElement(new FocusElement(text2, new Throwable()));
        SwingUtilities.invokeLater(() -> {
            if (this.myLog != null && this.myLog.isShowing()) {
                int h = this.myLog.getFixedCellHeight();
                this.myLog.scrollRectToVisible(new Rectangle(0, this.myLog.getPreferredSize().height - h, this.myLog.getWidth(), h));
                if (this.myLog.getModel().getSize() > 0) {
                    this.myLog.setSelectedIndex(this.myLog.getModel().getSize() - 1);
                }
            }
        });
    }

    private SimpleTextAttributes maybeGrayOut(SimpleTextAttributes attr, boolean greyOut) {
        return greyOut ? attr.derive(attr.getStyle(), Color.gray, attr.getBgColor(), attr.getWaveColor()) : attr;
    }

    @Override
    public String getName() {
        return "Focus";
    }

    @Override
    public void disposeUiResources() {
        this.myComponent = null;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
    }

    static class FocusElement {
        private final SimpleColoredText myText;
        private final Throwable myAllocation;

        FocusElement(SimpleColoredText text2, Throwable allocation) {
            this.myText = text2;
            this.myAllocation = allocation;
        }

        public SimpleColoredText getText() {
            return this.myText;
        }

        public Throwable getAllocation() {
            return this.myAllocation;
        }
    }

    static class FocusElementRenderer
    extends ColoredListCellRenderer {
        FocusElementRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                FocusElementRenderer.$$$reportNull$$$0(0);
            }
            this.clear();
            FocusElement element2 = (FocusElement)value2;
            SimpleColoredText text2 = element2.getText();
            ArrayList strings = text2.getTexts();
            ArrayList attributes = element2.getText().getAttributes();
            for (int i = 0; i < strings.size(); ++i) {
                this.append((String)strings.get(i), (SimpleTextAttributes)attributes.get(i));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/debugger/extensions/FocusDebugger$FocusElementRenderer", "customizeCellRenderer"));
        }
    }

    class ClearAction
    extends AnAction {
        ClearAction() {
            super(IdeBundle.messagePointer((String)"action.AnAction.text.clear", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.AnAction.description.clear", (Object[])new Object[0]), AllIcons.Actions.Close);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(0);
            }
            FocusDebugger.this.myLogModel.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/debugger/extensions/FocusDebugger$ClearAction", "actionPerformed"));
        }
    }
}

